/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.mrcrayfish.furniture.refurbished.Constants;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class BlockEntityHelper {
    public static void sendCustomUpdate(BlockEntity entity, Consumer<ValueOutput> consumer) {
        ChunkSource chunkSource;
        Level level = entity.getLevel();
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = entity.getBlockPos();
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)entity, (blockEntity, registryAccess) -> {
                try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector(entity.problemPath(), Constants.LOG);){
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)registryAccess);
                    consumer.accept((ValueOutput)output);
                    CompoundTag compoundTag = output.buildResult();
                    return compoundTag;
                }
            });
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> player.connection.send((Packet)packet));
        }
    }

    public static void sendCustomUpdate(BlockEntity entity, BiFunction<BlockEntity, RegistryAccess, CompoundTag> consumer) {
        ChunkSource chunkSource;
        Level level = entity.getLevel();
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = entity.getBlockPos();
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)entity, consumer);
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> player.connection.send((Packet)packet));
        }
    }

    public static void saveItems(String key, ValueOutput output, NonNullList<ItemStack> items) {
        ValueOutput.TypedOutputList list = output.list(key, ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < items.size(); ++slot) {
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.isEmpty()) continue;
            list.add((Object)new ItemStackWithSlot(slot, stack));
        }
    }

    public static void loadItems(String key, ValueInput input, NonNullList<ItemStack> items) {
        input.list(key, ItemStackWithSlot.CODEC).ifPresent(slots -> {
            items.clear();
            for (ItemStackWithSlot withSlot : slots) {
                if (!withSlot.isValidInContainer(items.size())) continue;
                items.set(withSlot.slot(), (Object)withSlot.stack());
            }
        });
    }

    public static NonNullList<ItemStack> nonNullListFromContainer(Container container) {
        int size = container.getContainerSize();
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)container.getItem(i));
        }
        return items;
    }

    public static Optional<Component> readCustomName(ValueInput input) {
        return input.read("CustomName", ComponentSerialization.CODEC);
    }

    public static void saveCustomName(ValueOutput output, @Nullable Component component) {
        if (component != null) {
            output.store("CustomName", ComponentSerialization.CODEC, (Object)component);
        }
    }
}

