/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.client.electricity.CachedElectricityNodes;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchHandler;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ElectricityRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.LinkingConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.NodeRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.PowerableAreaRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_6367;
import net.minecraft.class_7833;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class ElectricityRenderer
implements class_4013 {
    public static final String PASS_NAME = "refurbished_furniture_electricity";
    public static final class_2960 ID = Utils.resource("electricity_renderer");
    private static final class_2960 POWERABLE_AREA = Utils.resource("textures/misc/powerable_area.png");
    private static final class_2960 UNPOWERABLE_AREA = Utils.resource("textures/misc/unpowerable_area.png");
    private static ElectricityRenderer instance;
    private final SubmitStorage storage = new SubmitStorage();
    private final class_4587 poseStack = new class_4587();
    private final ElectricityRenderState renderState = new ElectricityRenderState();
    @Nullable
    private Class<?> irisClass;
    private Method shaderPack;
    private Boolean shaderEnabled;
    private class_6367 electricityTarget;
    private class_9925<class_6367> handle;
    private boolean takenScreenshot;

    public static ElectricityRenderer get() {
        if (instance == null) {
            instance = new ElectricityRenderer();
        }
        return instance;
    }

    private ElectricityRenderer() {
        this.setupIrisSupport();
    }

    private void setupIrisSupport() {
        try {
            this.irisClass = Class.forName("net.irisshaders.iris.Iris");
            this.shaderPack = this.irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            this.shaderPack.setAccessible(true);
            Constants.LOG.info("Iris detected! Will use modified rendering for electricity when shaders are enabled");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to locate Iris shader pack getter", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public boolean isIrisShadersEnabled() {
        if (this.irisClass != null && this.shaderPack != null && this.shaderEnabled == null) {
            try {
                Optional optional = (Optional)this.shaderPack.invoke(null, new Object[0]);
                this.shaderEnabled = optional.isPresent();
                return this.shaderEnabled;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke shader pack getter", e);
            }
        }
        return this.shaderEnabled != null && this.shaderEnabled != false;
    }

    public void method_14491(class_3300 manager) {
        if (this.electricityTarget != null) {
            this.electricityTarget.method_1238();
        }
        class_1041 window = class_310.method_1551().method_22683();
        this.electricityTarget = new class_6367("Refurbished Furniture Electricity Overlay", window.method_4489(), window.method_4506(), true);
    }

    public void resize(int width, int height) {
        if (this.electricityTarget != null) {
            this.electricityTarget.method_1234(width, height);
        }
    }

    public class_6367 getTextureTarget() {
        return this.electricityTarget;
    }

    public ElectricityRenderState getRenderState() {
        return this.renderState;
    }

    public void extract(class_4184 camera) {
        this.renderState.reset();
        if (WrenchHandler.isHoldingWrench()) {
            WrenchHandler handler = WrenchHandler.get();
            handler.extractLinkingConnection(this.renderState);
            this.forEachVisibleElectricityNode(camera, node -> {
                boolean nodeCanBeSelected = handler.isTargetNode((IElectricityNode)node) && !handler.isCreatingLink() && !node.isNodeConnectionLimitReached();
                boolean nodeIsBeingLinked = handler.isSelectedNode((IElectricityNode)node);
                boolean nodeIsJoinable = handler.canLinkToNode((IElectricityNode)node) && handler.isTargetNode((IElectricityNode)node);
                boolean nodeHighlighted = nodeCanBeSelected || nodeIsBeingLinked || nodeIsJoinable;
                NodeRenderState nodeState = new NodeRenderState();
                nodeState.box = node.getNodeInteractBox().method_996(node.getNodePosition());
                nodeState.highlighted = nodeHighlighted;
                nodeState.highlightColour = handler.getLinkColour();
                this.renderState.nodes.add(nodeState);
                for (Connection connection : node.getNodeConnections()) {
                    class_2338 start = connection.getPosA();
                    class_2338 end = connection.getPosB();
                    boolean hovered = !handler.isCreatingLink() && connection.equals(handler.getTargetConnection());
                    int colour = connection.getColour(node.getNodeLevel());
                    this.renderState.connections.add(new ConnectionRenderState(start, end, hovered, colour));
                }
            });
        }
    }

    private void submitElectricityRenderState(ElectricityRenderState renderState, class_4587 stack) {
        renderState.nodes.forEach(box -> this.storage.submitNode(stack, (NodeRenderState)box));
        renderState.connections.forEach(connection -> this.storage.submitConnection(stack, (ConnectionRenderState)connection));
        if (renderState.link != null) {
            this.storage.submitLinkingConnection(stack, renderState.link);
        }
    }

    public void setupFramePass(class_9909 builder, class_243 camera) {
        this.shaderEnabled = null;
        class_9925 handle = builder.method_61914(PASS_NAME, (Object)this.electricityTarget);
        class_9916 pass = builder.method_61911(PASS_NAME);
        this.handle = pass.method_61933(handle);
        pass.method_61929(() -> {
            GpuTexture colorTexture = this.electricityTarget.method_30277();
            GpuTexture depthTexture = this.electricityTarget.method_30278();
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colorTexture, 0, depthTexture, 1.0);
            class_4587 stack = new class_4587();
            stack.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
            this.submitElectricityRenderState(this.renderState, stack);
            class_1921 renderType = ClientServices.PLATFORM.getElectricityRenderType();
            class_4597.class_4598 source = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = source.method_73477(renderType);
            this.storage.linkingConnectionSubmits.forEach(submit -> this.renderLinkingConnection(submit.pose, vertexConsumer, submit.linkingConnectionRenderState));
            this.storage.nodeSubmits.forEach(submit -> submit.renderer.accept(submit.pose, vertexConsumer));
            this.storage.connectionSubmits.forEach(submit -> this.renderConnection(submit.pose, vertexConsumer, submit.connectionRenderState));
            source.method_22994(renderType);
            this.storage.clear();
        });
    }

    public void blitToScreen() {
        this.tryAndTakeDebugScreenshot();
        if (this.handle != null) {
            GpuTextureView mainTexture = class_310.method_1551().method_1522().method_71639();
            GpuTextureView electricityTexture = this.electricityTarget.method_71639();
            if (electricityTexture != null && mainTexture != null) {
                try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Blit", mainTexture, OptionalInt.empty());){
                    pass.setPipeline(ModRenderPipelines.ELECTRICITY_BLIT);
                    RenderSystem.bindDefaultUniforms((RenderPass)pass);
                    pass.bindSampler("InSampler", electricityTexture);
                    pass.draw(0, 3);
                }
            }
        }
        this.handle = null;
    }

    private void renderConnection(class_4587.class_4665 pose, class_4588 vertexConsumer, ConnectionRenderState state) {
        this.poseStack.method_22903();
        this.poseStack.method_23760().method_66521(pose);
        class_2338 start = state.a();
        this.poseStack.method_46416((float)start.method_10263(), (float)start.method_10264(), (float)start.method_10260());
        this.poseStack.method_22904(0.5, 0.5, 0.5);
        class_243 delta = class_243.method_24954((class_2382)state.b().method_10059((class_2382)state.a()));
        double yaw = Math.atan2(-delta.field_1350, delta.field_1352) + Math.PI;
        double pitch = Math.atan2(delta.method_37267(), delta.field_1351) + 1.5707963705062866;
        this.poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)yaw));
        this.poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation((float)pitch));
        float offset = (float)(Math.sin((double)class_156.method_658() / 500.0) + 1.0) / 2.0f * 0.2f;
        class_238 box = new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125);
        ElectricityRenderer.drawColouredBox(this.poseStack.method_23760(), vertexConsumer, box, state.colour(), 0.7f + offset);
        ElectricityRenderer.drawColouredBox(this.poseStack.method_23760(), vertexConsumer, box.method_1014(0.03125), state.colour(), 0.5f + offset);
        if (state.hovered()) {
            ElectricityRenderer.drawColouredBox(this.poseStack.method_23760(), vertexConsumer, box.method_1014(0.03125), -1, 0.8f);
        }
        this.poseStack.method_22909();
    }

    private void renderLinkingConnection(class_4587.class_4665 pose, class_4588 vertexConsumer, LinkingConnectionRenderState state) {
        this.poseStack.method_22903();
        this.poseStack.method_23760().method_66521(pose);
        class_243 delta = state.end.method_1020(state.start);
        double yaw = Math.atan2(-delta.field_1350, delta.field_1352) + Math.PI;
        double pitch = Math.atan2(delta.method_37267(), delta.field_1351) + 1.5707963705062866;
        this.poseStack.method_22904(state.start.field_1352, state.start.field_1351, state.start.field_1350);
        this.poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)yaw));
        this.poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation((float)pitch));
        ElectricityRenderer.drawColouredBox(this.poseStack.method_23760(), vertexConsumer, new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125), state.colour, 0.8f);
        ElectricityRenderer.drawColouredBox(this.poseStack.method_23760(), vertexConsumer, new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125).method_1014(0.03125), state.colour, 0.6f);
        this.poseStack.method_22909();
    }

    public void renderPowerableArea(class_243 camera) {
        block19: {
            PowerableAreaRenderState renderState = new PowerableAreaRenderState();
            WrenchHandler handler = WrenchHandler.get();
            handler.extractPowerableArea(renderState, camera);
            if (renderState.shape == null || renderState.alpha <= 0.0f) {
                return;
            }
            class_4587 stack = new class_4587();
            stack.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
            boolean shaders = ElectricityRenderer.get().isIrisShadersEnabled();
            RenderPipeline pipeline = shaders ? class_10799.field_56869 : ModRenderPipelines.POWERABLE_AREA;
            try (class_9799 quadBuilder = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);){
                class_287 vertexBuilder = new class_287(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
                renderState.shape.method_1090().forEach(box -> ElectricityRenderer.drawPowerableAreaBox(stack.method_23760(), (class_4588)vertexBuilder, box));
                try (class_9801 data = vertexBuilder.method_60794();){
                    if (data == null) break block19;
                    class_276 mainTarget = class_310.method_1551().method_1522();
                    class_276 weatherTarget = class_310.method_1551().field_1769.method_29363();
                    GpuTextureView mainColor = mainTarget.method_71639();
                    GpuTextureView mainDepth = mainTarget.method_71640();
                    if (weatherTarget != null) {
                        // empty if block
                    }
                    GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 0.6f * renderState.alpha), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                    RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
                    VertexFormat.class_5595 indexType = autoIndexBuffer.method_31924();
                    GpuBuffer indexBuffer = autoIndexBuffer.method_68274(data.method_60822().comp_751());
                    GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Powerable Area vertex buffer", 40, data.method_60818().remaining());
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer.slice(), data.method_60818());
                    class_1044 texture = class_310.method_1551().method_1531().method_4619(renderState.invalid ? UNPOWERABLE_AREA : POWERABLE_AREA);
                    texture.method_70950(false);
                    try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Powerable Area", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());){
                        pass.setPipeline(pipeline);
                        RenderSystem.bindDefaultUniforms((RenderPass)pass);
                        pass.setUniform("DynamicTransforms", slice);
                        pass.setIndexBuffer(indexBuffer, indexType);
                        pass.bindSampler("Sampler0", texture.method_71659());
                        pass.setVertexBuffer(0, vertexBuffer);
                        pass.drawIndexed(0, 0, data.method_60822().comp_751(), 1);
                    }
                }
            }
        }
    }

    private void tryAndTakeDebugScreenshot() {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            class_310 mc = class_310.method_1551();
            if (mc.method_74187() && mc.method_74189() && mc.method_74188()) {
                if (!this.takenScreenshot) {
                    class_318.method_22690((File)mc.field_1697, null, (class_276)this.electricityTarget, (int)1, component -> {});
                    this.takenScreenshot = true;
                }
            } else {
                this.takenScreenshot = false;
            }
        }
    }

    private void forEachVisibleElectricityNode(class_4184 camera, Consumer<IElectricityNode> consumer) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        ((CachedElectricityNodes)mc.field_1687).refurbishedFurniture$ElectricityNodes().forEach(node -> {
            double maxDistance = ((Integer)Config.CLIENT.electricityViewDistance.get()).intValue();
            double distance = node.getNodePosition().method_19770((class_2374)camera.method_19326());
            if (distance <= maxDistance * maxDistance) {
                consumer.accept((IElectricityNode)node);
            }
        });
    }

    public static void drawColouredBox(class_4587.class_4665 pose, class_4588 consumer, class_238 box, int colour, float alpha) {
        float red = (float)class_9848.method_61327((int)colour) / 255.0f;
        float green = (float)class_9848.method_61329((int)colour) / 255.0f;
        float blue = (float)class_9848.method_61331((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
    }

    public static void drawInvertedColouredBox(class_4587.class_4665 pose, class_4588 consumer, class_238 box, int colour, float alpha) {
        float red = (float)class_9848.method_61327((int)colour) / 255.0f;
        float green = (float)class_9848.method_61329((int)colour) / 255.0f;
        float blue = (float)class_9848.method_61331((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
    }

    public static void drawTexturedBox(class_4587.class_4665 pose, class_4588 consumer, class_238 box, float minU, float minV, float maxU, float maxV) {
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxV, minU).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minV, minU).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minV, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxV, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void drawPowerableAreaBox(class_4587.class_4665 pose, class_4588 consumer, class_238 box) {
        float offset = (float)class_156.method_658() * 0.001f;
        float width = (float)(box.field_1320 - box.field_1323);
        float height = (float)(box.field_1325 - box.field_1322);
        if ((double)width > 0.01) {
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(width, offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, height + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(width, height + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(width, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
        }
        if ((double)(width = (float)(box.field_1324 - box.field_1321)) > 0.01) {
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, height + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(width, offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(width, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(width, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, offset);
        }
        width = (float)(box.field_1320 - box.field_1323);
        height = (float)(box.field_1324 - box.field_1321);
        if ((double)width > 0.01) {
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(height, width + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(height, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, width + offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_56824(pose, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(width, offset);
            consumer.method_56824(pose, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, offset);
        }
    }

    private static class SubmitStorage {
        private final List<NodeSubmit> nodeSubmits = new ArrayList<NodeSubmit>();
        private final List<ConnectionSubmit> connectionSubmits = new ArrayList<ConnectionSubmit>();
        private final List<LinkingConnectionSubmit> linkingConnectionSubmits = new ArrayList<LinkingConnectionSubmit>();

        private SubmitStorage() {
        }

        public void submitNode(class_4587 poseStack, NodeRenderState state) {
            this.nodeSubmits.add(new NodeSubmit(poseStack.method_23760().method_56822(), (pose, consumer) -> {
                ElectricityRenderer.drawTexturedBox(pose, consumer, state.box, 0.0f, 0.0f, 0.25f, 0.25f);
                if (state.highlighted) {
                    ElectricityRenderer.drawInvertedColouredBox(pose, consumer, state.box.method_1014(0.03125), state.highlightColour, 0.7f);
                }
            }));
        }

        public void submitConnection(class_4587 poseStack, ConnectionRenderState state) {
            this.connectionSubmits.add(new ConnectionSubmit(poseStack.method_23760().method_56822(), state));
        }

        public void submitLinkingConnection(class_4587 poseStack, LinkingConnectionRenderState state) {
            this.linkingConnectionSubmits.add(new LinkingConnectionSubmit(poseStack.method_23760().method_56822(), state));
        }

        private void clear() {
            this.nodeSubmits.clear();
            this.connectionSubmits.clear();
            this.linkingConnectionSubmits.clear();
        }

        private record NodeSubmit(class_4587.class_4665 pose, BiConsumer<class_4587.class_4665, class_4588> renderer) {
        }

        private record ConnectionSubmit(class_4587.class_4665 pose, ConnectionRenderState connectionRenderState) {
        }

        private record LinkingConnectionSubmit(class_4587.class_4665 pose, LinkingConnectionRenderState linkingConnectionRenderState) {
        }
    }
}

