/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.electricity.ElectricityRenderer;
import com.mrcrayfish.furniture.refurbished.client.electricity.PowerableArea;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchContext;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.ElectricityRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.LinkingConnectionRenderState;
import com.mrcrayfish.furniture.refurbished.client.electricity.state.PowerableAreaRenderState;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.ConnectionHitResult;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import com.mrcrayfish.furniture.refurbished.item.WrenchItem;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Vector3d;

public class WrenchHandler {
    private static final int DEFAULT_LINK_COLOUR = -1;
    private static final int SUCCESS_LINK_COLOUR = -4849844;
    private static final int ERROR_LINK_COLOUR = -3983818;
    private static final double NEAR_DISTANCE = 10.0;
    private static WrenchHandler instance;
    private final PowerableArea powerableArea = new PowerableArea();
    @Nullable
    private class_2338 selectedNodePos;
    private class_239 result;
    private double linkLength;
    private boolean linkInsideArea;

    public static WrenchHandler get() {
        if (instance == null) {
            instance = new WrenchHandler();
        }
        return instance;
    }

    private WrenchHandler() {
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == Config.SERVER) {
                this.powerableArea.invalidate();
            }
        });
    }

    public void setSelectedNodePos(@Nullable class_2338 pos) {
        this.selectedNodePos = pos;
    }

    public boolean isSelectedNode(IElectricityNode node) {
        return this.selectedNodePos != null && this.selectedNodePos.equals((Object)node.getNodePosition());
    }

    public boolean isCreatingLink() {
        return this.selectedNodePos != null;
    }

    public boolean isLinkOutsidePowerableArea() {
        return !this.linkInsideArea;
    }

    public double getLinkLength() {
        return this.selectedNodePos != null ? this.linkLength : 0.0;
    }

    public boolean isTargetNode(IElectricityNode node) {
        NodeHitResult nodeResult;
        class_239 class_2393 = this.result;
        return class_2393 instanceof NodeHitResult && (nodeResult = (NodeHitResult)class_2393).getNode() == node;
    }

    @Nullable
    public IElectricityNode getTargetNode() {
        IElectricityNode iElectricityNode;
        class_239 class_2393 = this.result;
        if (class_2393 instanceof NodeHitResult) {
            NodeHitResult nodeResult = (NodeHitResult)class_2393;
            iElectricityNode = nodeResult.getNode();
        } else {
            iElectricityNode = null;
        }
        return iElectricityNode;
    }

    @Nullable
    public Connection getTargetConnection() {
        Connection connection;
        class_239 class_2393 = this.result;
        if (class_2393 instanceof ConnectionHitResult) {
            ConnectionHitResult linkResult = (ConnectionHitResult)class_2393;
            connection = linkResult.getConnection();
        } else {
            connection = null;
        }
        return connection;
    }

    @Nullable
    public IElectricityNode getSelectedNode() {
        IElectricityNode node;
        class_1937 level = WrenchHandler.getClientLevel();
        if (level == null || this.selectedNodePos == null) {
            return null;
        }
        class_2818 chunk = level.method_8500(this.selectedNodePos);
        if (chunk == null) {
            return null;
        }
        Object v = chunk.method_12214().get(this.selectedNodePos);
        if (v instanceof IElectricityNode && (node = (IElectricityNode)v).isNodeValid()) {
            return node;
        }
        return null;
    }

    public void startRenderLevel(float partialTick) {
        if (!WrenchHandler.isHoldingWrench()) {
            this.selectedNodePos = null;
        }
        this.updateHitResult(partialTick);
        this.updateLinkState(partialTick);
    }

    private void updateHitResult(float partialTick) {
        class_239 last = this.result;
        this.result = null;
        class_1657 player = WrenchHandler.getClientPlayer();
        class_1937 level = WrenchHandler.getClientLevel();
        if (player == null || level == null) {
            return;
        }
        if (!player.method_6047().method_31574((class_1792)ModItems.WRENCH.get())) {
            return;
        }
        double range = player.method_55754();
        NodeHitResult newResult = WrenchItem.pickElectricityNode(level, player, range, partialTick);
        if (newResult.method_17783() == class_239.class_240.field_1333) {
            newResult = this.pickConnection(player, partialTick, range);
        }
        if (newResult.method_17783() != class_239.class_240.field_1333) {
            this.playHoverSound(last, newResult, player, level);
            this.result = newResult;
        }
    }

    private void playHoverSound(@Nullable class_239 oldResult, @Nullable class_239 newResult, class_1657 player, class_1937 level) {
        if (this.selectedNodePos != null) {
            return;
        }
        if ((oldResult == null || !oldResult.equals(newResult)) && newResult instanceof ConnectionHitResult) {
            class_243 pos = newResult.method_17784();
            float pitch = 1.0f + 0.05f * level.field_9229.method_43057();
            level.method_43128((class_1297)player, pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.ITEM_WRENCH_HOVER_LINK.get(), class_3419.field_15245, 1.0f, pitch);
        }
    }

    private void updateLinkState(float partialTick) {
        ConnectionHitResult hitResult;
        Connection connection;
        class_243 end;
        class_243 start;
        this.linkInsideArea = false;
        class_1657 player = WrenchHandler.getClientPlayer();
        class_1937 level = WrenchHandler.getClientLevel();
        if (player == null || level == null) {
            return;
        }
        this.powerableArea.updatePowerSources(level, this.createWrenchContext());
        if (this.selectedNodePos != null) {
            start = class_243.method_24953((class_2382)this.selectedNodePos);
            end = this.getLinkEnd(player, partialTick);
            this.linkLength = end.method_1020(start).method_1033();
        }
        if (!this.powerableArea.exists()) {
            this.linkInsideArea = true;
            return;
        }
        if (this.selectedNodePos != null) {
            start = this.selectedNodePos.method_46558();
            end = this.getLinkEnd(player, partialTick);
            this.linkInsideArea = this.powerableArea.containsLine(level, start, end);
            return;
        }
        end = this.result;
        if (end instanceof ConnectionHitResult && (connection = (hitResult = (ConnectionHitResult)end).getConnection()) != null) {
            class_243 start2 = connection.getPosA().method_46558();
            class_243 end2 = connection.getPosB().method_46558();
            this.linkInsideArea = this.powerableArea.containsLine(level, start2, end2);
        }
    }

    private WrenchContext createWrenchContext() {
        IElectricityNode linkingNode = this.getSelectedNode();
        IElectricityNode targetNode = this.getTargetNode();
        Connection targetConnection = this.getTargetConnection();
        return new WrenchContext(linkingNode, targetNode, targetConnection);
    }

    public void extractLinkingConnection(ElectricityRenderState renderState) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1724.method_6047().method_31574((class_1792)ModItems.WRENCH.get()) && this.selectedNodePos != null) {
            LinkingConnectionRenderState state = new LinkingConnectionRenderState();
            state.start = class_243.method_24953((class_2382)this.selectedNodePos);
            state.end = this.getLinkEnd((class_1657)mc.field_1724, mc.method_61966().method_60637(false));
            state.colour = this.getLinkColour();
            renderState.link = state;
        }
    }

    public void extractPowerableArea(PowerableAreaRenderState renderState, class_243 camera) {
        class_265 areaShape = this.powerableArea.getPowerableAreaShape();
        if (areaShape == null) {
            return;
        }
        renderState.shape = areaShape;
        renderState.alpha = 1.0f;
        boolean bl = renderState.invalid = !this.linkInsideArea;
        if (this.linkInsideArea) {
            double nearDistanceSqr = 100.0;
            renderState.alpha = renderState.shape.method_33661(camera).map(vec -> vec.method_1025(camera)).map(val -> Float.valueOf(1.0f - (float)class_3532.method_15350((double)(val / nearDistanceSqr), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
            renderState.alpha = 1.0f - (float)Math.pow(1.0f - renderState.alpha, 5.0);
        }
    }

    private class_243 getLinkEnd(class_1657 player, float partialTick) {
        IElectricityNode node = this.getTargetNode();
        if (node != null && !this.isSelectedNode(node) && this.canLinkToNode(node)) {
            return node.getNodePosition().method_46558();
        }
        return player.method_5828(partialTick).method_1029().method_1021(1.5).method_1019(player.method_5836(partialTick));
    }

    public int getLinkColour() {
        IElectricityNode linking = this.getSelectedNode();
        if (linking == null) {
            return -1;
        }
        if (this.linkLength > 512.0) {
            return -3983818;
        }
        IElectricityNode target = this.getTargetNode();
        if (target != null && !this.isSelectedNode(target)) {
            if (this.canLinkToNode(target)) {
                return -4849844;
            }
            return -3983818;
        }
        if (!this.linkInsideArea) {
            return -3983818;
        }
        return -1;
    }

    public boolean canLinkToNode(IElectricityNode target) {
        IElectricityNode lastNode;
        class_1937 level = WrenchHandler.getClientLevel();
        if (level != null && this.selectedNodePos != null && (lastNode = this.getSelectedNode()) != null && target != null && lastNode != target) {
            if (level != target.getNodeLevel()) {
                return false;
            }
            if (target.isSourceNode() && lastNode.isSourceNode()) {
                return false;
            }
            if (target.isNodeConnectionLimitReached()) {
                return false;
            }
            return !lastNode.isConnectedToNode(target);
        }
        return false;
    }

    private class_239 pickConnection(class_1657 player, float partialTick, double range) {
        double closestDistance = Double.POSITIVE_INFINITY;
        ConnectionRenderState closestConnection = null;
        class_243 hit = class_243.field_1353;
        ElectricityRenderState renderState = ElectricityRenderer.get().getRenderState();
        for (ConnectionRenderState connectionRenderState : renderState.connections) {
            class_243 rayStart = player.method_5836(partialTick);
            class_243 rayEnd = rayStart.method_1019(player.method_5828(partialTick).method_1029().method_1021(range));
            class_243 linkStart = connectionRenderState.a().method_46558();
            class_243 linkEnd = connectionRenderState.b().method_46558();
            Vector3d result = new Vector3d();
            double squareDistance = Intersectiond.findClosestPointsLineSegments((double)rayStart.field_1352, (double)rayStart.field_1351, (double)rayStart.field_1350, (double)rayEnd.field_1352, (double)rayEnd.field_1351, (double)rayEnd.field_1350, (double)linkStart.field_1352, (double)linkStart.field_1351, (double)linkStart.field_1350, (double)linkEnd.field_1352, (double)linkEnd.field_1351, (double)linkEnd.field_1350, (Vector3d)new Vector3d(), (Vector3d)result);
            double distance = Math.sqrt(squareDistance);
            if (!(distance < 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestConnection = connectionRenderState;
            hit = new class_243(result.x, result.y, result.z);
        }
        if (closestConnection != null) {
            return new ConnectionHitResult(hit, Connection.of(closestConnection.a(), closestConnection.b()));
        }
        return new ConnectionHitResult(hit, null);
    }

    public boolean onPerformAttack(class_1937 level) {
        ConnectionHitResult connectionHitResult;
        Connection connection;
        class_239 class_2393;
        if (!this.isCreatingLink() && (class_2393 = this.result) instanceof ConnectionHitResult && (connection = (connectionHitResult = (ConnectionHitResult)class_2393).getConnection()) != null) {
            class_243 hit = connectionHitResult.method_17784();
            level.method_8486(hit.field_1352, hit.field_1351, hit.field_1350, (class_3414)ModSounds.ITEM_WRENCH_REMOVE_LINK.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            Network.getPlay().sendToServer((Object)new MessageDeleteLink(connection.getPosA(), connection.getPosB()));
            return true;
        }
        return false;
    }

    public static boolean isHoldingWrench() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 != null && mc.field_1724.method_5805() && mc.field_1724.method_6047().method_31574((class_1792)ModItems.WRENCH.get());
    }

    @Nullable
    private static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Nullable
    private static class_1937 getClientLevel() {
        return class_310.method_1551().field_1687;
    }
}

