/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.google.common.collect.Sets;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import org.jetbrains.annotations.Nullable;

public class Connection {
    private static final int DEFAULT_COLOUR = -1;
    private static final int POWERED_COLOUR = -9652;
    private static final int CROSSING_ZONE_COLOUR = -3983818;
    private final Node a;
    private final Node b;

    private Connection(class_2338 a, class_2338 b) {
        int c = a.method_10265((class_2382)b);
        this.a = new Node(c > 0 ? a : b);
        this.b = new Node(c > 0 ? b : a);
    }

    public class_2338 getPosA() {
        return this.a.pos;
    }

    public class_2338 getPosB() {
        return this.b.pos;
    }

    @Nullable
    public IElectricityNode getNodeA(class_1937 level) {
        return this.a.getElectricNode(level);
    }

    @Nullable
    public IElectricityNode getNodeB(class_1937 level) {
        return this.b.getElectricNode(level);
    }

    public boolean isConnected(class_1937 level) {
        return this.a.isValid(level) && this.b.isValid(level);
    }

    public boolean isPowered(class_1937 level) {
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        if (a == null || b == null) {
            return false;
        }
        if (!a.canPowerTraverseNode() && !b.canPowerTraverseNode()) {
            return a.isNodePowered() && a.isSourceNode() || b.isNodePowered() && b.isSourceNode();
        }
        return a.isNodePowered() && b.isNodePowered();
    }

    public boolean isCrossingPowerableZone(class_1937 level) {
        Set<class_2338> bPowerSources;
        Set<class_2338> aPowerSources;
        IElectricityNode a = this.a.getElectricNode(level);
        IElectricityNode b = this.b.getElectricNode(level);
        if (a != null && b != null && !(aPowerSources = a.getPowerSources()).equals(bPowerSources = b.getPowerSources())) {
            class_243 aPos = this.a.pos.method_46558();
            class_243 bPos = this.b.pos.method_46558();
            for (class_2338 source : Sets.symmetricDifference(aPowerSources, bPowerSources)) {
                class_238 box = ISourceNode.createPowerableZone(level, source);
                if (box.method_1006(aPos) && box.method_1006(bPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IElectricityNode getOtherNode(IElectricityNode node) {
        if (this.a.pos.equals((Object)node.getNodePosition())) {
            return this.b.getElectricNode(node.getNodeLevel());
        }
        if (this.b.pos.equals((Object)node.getNodePosition())) {
            return this.a.getElectricNode(node.getNodeLevel());
        }
        return null;
    }

    @Nullable
    public class_2338 getOtherPos(class_2338 pos) {
        if (this.a.pos.equals((Object)pos)) {
            return this.b.pos;
        }
        if (this.b.pos.equals((Object)pos)) {
            return this.a.pos;
        }
        return null;
    }

    public int getColour(class_1937 level) {
        if (this.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        if (this.isPowered(level)) {
            return -9652;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return this.a.equals(other.a) && this.b.equals(other.b);
    }

    public int hashCode() {
        int result = this.a.hashCode();
        result = 31 * result + this.b.hashCode();
        return result;
    }

    public static Connection of(class_2338 a, class_2338 b) {
        return new Connection(a, b);
    }

    private static class Node {
        private final class_2338 pos;
        private WeakReference<IElectricityNode> ref;
        private Status status = Status.ACTIVE;

        private Node(class_2338 pos) {
            this.pos = pos;
            this.ref = new WeakReference<Object>(null);
        }

        private boolean isValid(class_1937 level) {
            this.updateStatus(level);
            return this.status.valid;
        }

        @Nullable
        private IElectricityNode getElectricNode(class_1937 level) {
            this.updateStatus(level);
            return (IElectricityNode)this.ref.get();
        }

        private void updateStatus(class_1937 level) {
            IElectricityNode node = (IElectricityNode)this.ref.get();
            if (node != null && node.isNodeValid()) {
                this.status = Status.ACTIVE;
                return;
            }
            if (level.method_8477(this.pos)) {
                IElectricityNode found;
                Object v;
                class_2818 chunk = level.method_8500(this.pos);
                if (chunk != null && (v = chunk.method_12214().get(this.pos)) instanceof IElectricityNode && (found = (IElectricityNode)v).isNodeValid()) {
                    this.ref = new WeakReference<IElectricityNode>(found);
                    this.status = Status.ACTIVE;
                } else {
                    this.ref.clear();
                    this.status = Status.INVALID;
                }
            } else {
                this.ref.clear();
                this.status = Status.UNDETERMINED;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public static enum Status {
            ACTIVE(true),
            UNDETERMINED(true),
            INVALID(false);

            final boolean valid;

            private Status(boolean valid) {
                this.valid = valid;
            }
        }
    }
}

