/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.StoveBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ForgeStoveBlockEntity
extends StoveBlockEntity {
    @Nullable
    private LazyOptional<IItemHandlerModifiable>[] handlers;

    public ForgeStoveBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void onNeighbourChanged() {
        super.onNeighbourChanged();
        this.invalidateItemHandlers();
    }

    @Override
    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.invalidateItemHandlers();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !this.remove) {
            LazyOptional<IItemHandlerModifiable>[] handlers = this.getOrCreateItemHandlers();
            if (side == Direction.DOWN) {
                return handlers[1].cast();
            }
            return handlers[0].cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandlerModifiable>[] getOrCreateItemHandlers() {
        if (this.handlers == null) {
            LazyOptional[] handlers = new LazyOptional[]{LazyOptional.of(() -> new InvWrapper((Container)this)), LazyOptional.of(() -> new SidedInvWrapper(this.getContainer(), Direction.DOWN))};
            this.handlers = handlers;
        }
        return this.handlers;
    }

    private void invalidateItemHandlers() {
        this.handlers = null;
    }
}

