/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.LightswitchBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LightswitchBlockEntity
extends ElectricityModuleBlockEntity
implements IHomeControlDevice,
Nameable {
    @Nullable
    private Component name;

    public LightswitchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LIGHTSWITCH.get(), pos, state);
    }

    @Override
    public boolean canPowerTraverseNode() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.ENABLED) && (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) != false;
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.POWERED) && (Boolean)state.getValue((Property)LightswitchBlock.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public BlockPos getDevicePos() {
        return this.worldPosition;
    }

    @Override
    public boolean isDeviceEnabled() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)LightswitchBlock.ENABLED) && (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) != false;
    }

    @Override
    public void toggleDeviceState() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.ENABLED)) {
            boolean enabled = (Boolean)state.getValue((Property)LightswitchBlock.ENABLED) == false;
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        }
    }

    @Override
    public void setDeviceState(boolean enabled) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)LightswitchBlock.ENABLED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)LightswitchBlock.ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        }
    }

    private Component getDefaultName() {
        return Utils.translation("container", "lightswitch", new Object[0]);
    }

    @Override
    public Component getDeviceName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return this.getDefaultName();
    }

    public Component getName() {
        return this.getBlockState().getBlock().getName();
    }

    public Component getDisplayName() {
        return this.name != null ? this.name : this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("CustomName", 8)) {
            this.name = LightswitchBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        BlockEntityHelper.saveCustomName(tag, this.name, provider);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return super.getUpdateTag(provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput getter) {
        super.applyImplicitComponents(getter);
        this.name = (Component)getter.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.name != null) {
            builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        }
    }
}

