/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.FreezerBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FreezerBlockEntity
extends ElectricityModuleProcessingLootBlockEntity
implements IPowerSwitch,
IHomeControlDevice,
StackedContentsCompatible {
    public static final int[] PROCESSABLE_INPUT_SLOTS = new int[]{0};
    public static final int[] PROCESSABLE_OUTPUT_SLOTS = new int[]{1};
    public static final int[] PUSHABLE_SLOTS = new int[]{0};
    public static final int[] PULLABLE_SLOTS = new int[]{0, 1};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESS_TIME = 2;
    public static final int DATA_MAX_PROCESS_TIME = 3;
    protected boolean enabled;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {
            this.processingTime = value;
        });
        builder.add(3, () -> this.totalProcessingTime, value -> {
            this.totalProcessingTime = value;
        });
    });

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FREEZER.get(), pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
    }

    public FreezerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "freezer", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return Services.MENU.createFreezerMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        return direction == Direction.DOWN ? PULLABLE_SLOTS : PUSHABLE_SLOTS;
    }

    @Override
    public int[] getInputSlots() {
        return PROCESSABLE_INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return PROCESSABLE_OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        return slotIndex != 0 || !this.isRecipe(stack);
    }

    @Override
    public boolean canProcess() {
        return super.canProcess() && this.enabled;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        Vec3 door = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)FreezerBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, door.x, door.y, door.z, (SoundEvent)ModSounds.BLOCK_FREEZER_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        Vec3 door = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)FreezerBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, door.x, door.y, door.z, (SoundEvent)ModSounds.BLOCK_FREEZER_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.setChanged();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Enabled", 1)) {
            this.enabled = tag.getBoolean("Enabled");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("Enabled", this.enabled);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putBoolean("Enabled", this.enabled);
        return tag;
    }

    @Override
    public BlockPos getDevicePos() {
        return this.worldPosition;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.setChanged();
        this.syncDataToTrackingClients();
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.setChanged();
        this.syncDataToTrackingClients();
    }

    @Override
    public Component getDeviceName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return this.getDefaultName();
    }

    public void fillStackedContents(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }
}

