/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IconButton
extends Button {
    public static final ResourceLocation ICON_TEXTURES = Utils.resource("textures/gui/icons.png");
    private final Component label;
    private final int u;
    private final int v;

    public IconButton(int x, int y, int u, int v, Button.OnPress onPress) {
        this(x, y, u, v, 20, CommonComponents.EMPTY, onPress);
    }

    public IconButton(int x, int y, int u, int v, int width, Component label, Button.OnPress onPress) {
        this(x, y, u, v, width, 20, label, onPress);
    }

    public IconButton(int x, int y, int u, int v, int width, int height, Component label, Button.OnPress onPress) {
        super(x, y, width, height, CommonComponents.EMPTY, onPress, Button.DEFAULT_NARRATION);
        this.label = label;
        this.u = u;
        this.v = v;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        Minecraft mc = Minecraft.getInstance();
        int contentWidth = 10 + mc.font.width((FormattedText)this.label) + (!this.label.getString().isEmpty() ? 4 : 0);
        int contentLeft = (this.width - contentWidth) / 2;
        int iconX = this.getX() + contentLeft;
        int iconY = this.getY() + 5;
        float brightness = this.active ? 1.0f : 0.5f;
        RenderSystem.enableBlend();
        graphics.setColor(brightness, brightness, brightness, this.alpha);
        graphics.blit(ICON_TEXTURES, iconX, iconY, (float)this.u, (float)this.v, 10, 10, 64, 64);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int start = iconX + 14;
        int end = iconX + contentWidth;
        int labelColour = 0xFFFFFF | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        IconButton.renderScrollingString((GuiGraphics)graphics, (Font)mc.font, (Component)this.label, (int)start, (int)this.getY(), (int)end, (int)(this.getY() + this.getHeight()), (int)labelColour);
    }
}

