/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class BathBlockEntity
extends class_2586
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)BathBlock.DIRECTION)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)BathBlock.DIRECTION);
            class_1937 level = Objects.requireNonNull(this.field_11863);
            class_2586 class_25862 = level.method_8321(this.field_11867.method_10093(direction));
            if (class_25862 instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)class_25862;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(class_2680 state) {
        if (state.method_28498(BathBlock.TYPE) && state.method_11654(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.method_5431();
                container.sync(this);
            });
        }
        return null;
    }

    public class_9062 interact(class_1657 player, class_1268 hand, class_3965 result) {
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return class_9062.field_47729;
        }
        if (this.interactWithBottle(player, hand, this.field_11867).method_23665()) {
            return class_9062.field_47728;
        }
        if (this.performPlatformInteraction(player, hand, this.field_11867, result.method_17780()).method_55643()) {
            return class_9062.field_47728;
        }
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && result.method_17780() != class_2350.field_11033) {
            if (this.tryAndFillWithFluid(this.field_11863, this.field_11867, (class_3611)class_3612.field_15910, class_243.method_24953((class_2382)this.field_11867)).method_23665()) {
                return class_9062.field_47728;
            }
            if (this.tryAndCreateObsidian(this.field_11863, this.field_11867, (class_3611)class_3612.field_15910, class_243.method_24955((class_2382)this.field_11867).method_1031(0.0, 1.0, 0.0)).method_23665()) {
                return class_9062.field_47728;
            }
        }
        return class_9062.field_47729;
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        } else {
            class_2680 state = this.method_11010();
            if (state.method_28498((class_2769)BathBlock.DIRECTION)) {
                BathBlockEntity bath;
                class_2586 class_25862;
                class_2338 headPos = this.field_11867.method_10093((class_2350)state.method_11654((class_2769)BathBlock.DIRECTION));
                if (this.field_11863 != null && (class_25862 = this.field_11863.method_8321(headPos)) instanceof BathBlockEntity && (bath = (BathBlockEntity)class_25862).isHead()) {
                    bath.playWaterAnimation();
                }
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            class_243 tap = class_243.method_24955((class_2382)pos).method_1031(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.method_43206((class_2350)state.method_11654((class_2769)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.field_1352 + Utils.pixels(0.5) * level.field_9229.method_43059();
                double z = tap.field_1350 + Utils.pixels(0.5) * level.field_9229.method_43059();
                level.method_8406((class_2394)ModParticleTypes.TAP_WATER.get(), x, tap.field_1351, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (this.tank != null) {
            this.tank.load(tag.method_10562("FluidTank"), provider);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.tank != null) {
            class_2487 tankTag = new class_2487();
            this.tank.save(tankTag, provider);
            tag.method_10566("FluidTank", (class_2520)tankTag);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }
}

