/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.juujks.craft_defense.network.QueueGUIButtonMessage;
import net.juujks.craft_defense.procedures.ReturnMapPProcedure;
import net.juujks.craft_defense.procedures.ReturnQueuePlayersProcedure;
import net.juujks.craft_defense.procedures.ReturnVotesToStartProcedure;
import net.juujks.craft_defense.world.inventory.QueueGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class QueueGUIScreen
extends AbstractContainerScreen<QueueGUIMenu> {
    private static final HashMap<String, Object> guistate = QueueGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_start;
    Button button_cancel;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"craft_defense:textures/screens/queue_gui.png");

    public QueueGUIScreen(QueueGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 170;
        this.imageHeight = 90;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.queue_gui.label_queue"), 12, 5, -12829636, false);
        guiGraphics.drawString(this.font, ReturnQueuePlayersProcedure.execute((LevelAccessor)this.world), 12, 23, -12829636, false);
        guiGraphics.drawString(this.font, ReturnVotesToStartProcedure.execute((LevelAccessor)this.world), 21, 50, -10027162, false);
        guiGraphics.drawString(this.font, ReturnMapPProcedure.execute((LevelAccessor)this.world), 12, 37, -256, false);
    }

    public void init() {
        super.init();
        this.button_start = Button.builder((Component)Component.translatable((String)"gui.craft_defense.queue_gui.button_start"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new QueueGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            QueueGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 21, this.topPos + 59, 51, 20).build();
        guistate.put("button:button_start", this.button_start);
        this.addRenderableWidget((GuiEventListener)this.button_start);
        this.button_cancel = Button.builder((Component)Component.translatable((String)"gui.craft_defense.queue_gui.button_cancel"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new QueueGUIButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            QueueGUIButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 93, this.topPos + 59, 56, 20).build();
        guistate.put("button:button_cancel", this.button_cancel);
        this.addRenderableWidget((GuiEventListener)this.button_cancel);
    }
}

