/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.juujks.craft_defense.network.UnitMachineGUIButtonMessage;
import net.juujks.craft_defense.procedures.LRCreeperProcedure;
import net.juujks.craft_defense.procedures.LRSkeletonProcedure;
import net.juujks.craft_defense.procedures.LRSlimeProcedure;
import net.juujks.craft_defense.procedures.LRSpiderProcedure;
import net.juujks.craft_defense.procedures.LRVillagerProcedure;
import net.juujks.craft_defense.procedures.LRWitchProcedure;
import net.juujks.craft_defense.procedures.LRZombieProcedure;
import net.juujks.craft_defense.procedures.ReturnAmountOfGemsProcedure;
import net.juujks.craft_defense.procedures.ReturnEntityTypeProcedure;
import net.juujks.craft_defense.procedures.ReturnNameOfEntityProcedure;
import net.juujks.craft_defense.procedures.ReturnRarityProcedure;
import net.juujks.craft_defense.world.inventory.UnitMachineGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class UnitMachineGUIScreen
extends AbstractContainerScreen<UnitMachineGUIMenu> {
    private static final HashMap<String, Object> guistate = UnitMachineGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_roll;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"craft_defense:textures/screens/unit_machine_gui.png");

    public UnitMachineGUIScreen(UnitMachineGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 200;
        this.imageHeight = 230;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/eba3.png"), this.leftPos + 99, this.topPos + 21, 0.0f, 0.0f, 90, 90, 90, 90);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/towergem.png"), this.leftPos + 18, this.topPos + 125, 0.0f, 0.0f, 16, 16, 16, 16);
        if (LRCreeperProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/creeperunit2.png"), this.leftPos + 131, this.topPos + 35, 0.0f, 0.0f, 32, 65, 32, 65);
        }
        if (LRZombieProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/zombie_unit2.png"), this.leftPos + 126, this.topPos + 44, 0.0f, 0.0f, 32, 56, 32, 56);
        }
        if (LRSkeletonProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/skeleton2.png"), this.leftPos + 126, this.topPos + 39, 0.0f, 0.0f, 32, 57, 32, 57);
        }
        if (LRSlimeProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/slime.png"), this.leftPos + 126, this.topPos + 53, 0.0f, 0.0f, 32, 35, 32, 35);
        }
        if (LRWitchProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/witch.png"), this.leftPos + 126, this.topPos + 30, 0.0f, 0.0f, 32, 74, 32, 74);
        }
        if (LRSpiderProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/spider.png"), this.leftPos + 113, this.topPos + 39, 0.0f, 0.0f, 64, 53, 64, 53);
        }
        if (LRVillagerProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/villager_-_converted.png"), this.leftPos + 131, this.topPos + 39, 0.0f, 0.0f, 32, 54, 32, 54);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.unit_machine_gui.label_unit_machine"), 9, 8, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.unit_machine_gui.label_info"), 36, 21, -12829636, false);
        guiGraphics.drawString(this.font, ReturnAmountOfGemsProcedure.execute((LevelAccessor)this.world, (Entity)this.entity), 36, 129, -12829636, false);
        guiGraphics.drawString(this.font, ReturnNameOfEntityProcedure.execute((Entity)this.entity), 5, 39, -12829636, false);
        guiGraphics.drawString(this.font, ReturnRarityProcedure.execute((Entity)this.entity), 5, 57, -12829636, false);
        guiGraphics.drawString(this.font, ReturnEntityTypeProcedure.execute((Entity)this.entity), 5, 75, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.unit_machine_gui.label_upgrades"), 27, 93, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.unit_machine_gui.label_2x_gems_to_roll"), 68, 116, -12829636, false);
    }

    public void init() {
        super.init();
        this.button_roll = Button.builder((Component)Component.translatable((String)"gui.craft_defense.unit_machine_gui.button_roll"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UnitMachineGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            UnitMachineGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 81, this.topPos + 125, 46, 20).build();
        guistate.put("button:button_roll", this.button_roll);
        this.addRenderableWidget((GuiEventListener)this.button_roll);
    }
}

