/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.procedures;

import java.util.Comparator;
import java.util.List;
import net.juujks.craft_defense.entity.AlexEntity;
import net.juujks.craft_defense.entity.CreeperUnitEntity;
import net.juujks.craft_defense.entity.SkeletonUnitEntity;
import net.juujks.craft_defense.entity.SlimeUnitEntity;
import net.juujks.craft_defense.entity.SpiderUnitEntity;
import net.juujks.craft_defense.entity.SteveEntity;
import net.juujks.craft_defense.entity.WitchUnitEntity;
import net.juujks.craft_defense.entity.ZombieUnitEntity;
import net.juujks.craft_defense.procedures.CallCommonProcedure;
import net.juujks.craft_defense.procedures.CallRareProcedure;
import net.juujks.craft_defense.procedures.CreeperExplosionProcedure;
import net.juujks.craft_defense.procedures.DamageClientProcedure;
import net.juujks.craft_defense.procedures.DmgP2Procedure;
import net.juujks.craft_defense.procedures.ShowEntityTestProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OnTickUpdate2Procedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        List<Entity> _entfound;
        Vec3 _center;
        LivingEntity _livingEntity1;
        if (entity == null) {
            return;
        }
        boolean found = false;
        Entity nearestEnemy = null;
        double powerfulChance = 0.0;
        double nearestDistSq = 0.0;
        double dx = 0.0;
        double dz = 0.0;
        double distSq = 0.0;
        double yaw = 0.0;
        entity.getPersistentData().putBoolean("unit", true);
        if (entity instanceof LivingEntity && (_livingEntity1 = (LivingEntity)entity).getAttributes().hasAttribute(Attributes.SCALE)) {
            _livingEntity1.getAttribute(Attributes.SCALE).setBaseValue(0.5);
        }
        ShowEntityTestProcedure.execute(world, x, y, z, entity);
        DmgP2Procedure.execute(world, x, y, z, entity);
        CallCommonProcedure.execute(entity);
        CallRareProcedure.execute(entity);
        DamageClientProcedure.execute(entity);
        nearestDistSq = entity.getPersistentData().getDouble("range") * (entity.getPersistentData().getDouble("range") + 1.0);
        entity.getPersistentData().putDouble("cooldown", entity.getPersistentData().getDouble("cooldown") + 1.0);
        if (entity.getPersistentData().getDouble("cooldown") >= 20.0 * entity.getPersistentData().getDouble("spa")) {
            _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
            _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(entity.getPersistentData().getDouble("range") / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                entity.getPersistentData().putDouble("cooldown", 0.0);
                if (!entityiterator.getPersistentData().getBoolean("attackable") || !((distSq = (dx = entityiterator.getX() - entity.getX()) * dx + (dz = entityiterator.getZ() - entity.getZ()) * dz) < nearestDistSq)) continue;
                nearestDistSq = distSq;
                nearestEnemy = entityiterator;
                found = true;
            }
        }
        CreeperExplosionProcedure.execute(world, x, y, z, entity);
        if (found) {
            Level _level;
            if (entity instanceof CreeperUnitEntity) {
                _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
                _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(entity.getPersistentData().getDouble("range") / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    if (!(entityiterator.getPersistentData().getDouble("powerful") <= entity.getPersistentData().getDouble("level")) || !entityiterator.getPersistentData().getBoolean("attackable")) continue;
                    entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
                }
            } else if (nearestEnemy.getPersistentData().getDouble("powerful") <= entity.getPersistentData().getDouble("level") && !nearestEnemy.getPersistentData().getBoolean("aerial")) {
                LivingEntity _entity;
                nearestEnemy.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
                if (entity instanceof WitchUnitEntity && nearestEnemy instanceof LivingEntity && !(_entity = (LivingEntity)nearestEnemy).level().isClientSide()) {
                    _entity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 2, true, true));
                }
                if (entity instanceof SlimeUnitEntity) {
                    nearestEnemy.getPersistentData().putBoolean("slow", true);
                }
            } else if (nearestEnemy.getPersistentData().getBoolean("aerial") && (entity instanceof AlexEntity || entity instanceof SkeletonUnitEntity)) {
                nearestEnemy.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
            }
            if (entity instanceof SteveEntity) {
                ((SteveEntity)entity).setAnimation("steve.attack");
            }
            if (entity instanceof AlexEntity) {
                ((AlexEntity)entity).setAnimation("attack");
            }
            if (entity instanceof ZombieUnitEntity) {
                ((ZombieUnitEntity)entity).setAnimation("zombie.attack");
            }
            if (entity instanceof CreeperUnitEntity) {
                CreeperUnitEntity animatable = (CreeperUnitEntity)entity;
                animatable.setTexture("creeper");
            }
            entity.getPersistentData().putDouble("cooldown", 0.0);
            if (entity instanceof SteveEntity || entity instanceof SpiderUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                world.addParticle((ParticleOptions)ParticleTypes.SWEEP_ATTACK, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 0.0, 1.0, 0.0);
            }
            if (entity instanceof WitchUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.experience_bottle.throw")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.experience_bottle.throw")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 20, 0.0, 0.0, 0.0, 0.2);
                }
            }
            if (entity instanceof CreeperUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 5, 6.0, 1.0, 6.0, 1.0);
                }
            }
            if (entity instanceof SlimeUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 20, 0.0, 0.0, 0.0, 1.0);
                }
            }
            if (entity instanceof AlexEntity || entity instanceof SkeletonUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.CRIT, nearestEnemy.getX(), nearestEnemy.getY(), nearestEnemy.getZ(), 10, 0.0, 0.0, 0.0, 0.2);
                }
            }
            yaw = Math.atan2(dz, dx) * 57.29577951308232 - 90.0;
            Entity _ent = entity;
            _ent.setYRot((float)yaw);
            _ent.setXRot(0.0f);
            _ent.setYBodyRot(_ent.getYRot());
            _ent.setYHeadRot(_ent.getYRot());
            _ent.yRotO = _ent.getYRot();
            _ent.xRotO = _ent.getXRot();
            if (_ent instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)_ent;
                _entity.yBodyRotO = _entity.getYRot();
                _entity.yHeadRotO = _entity.getYRot();
            }
        }
    }
}

