/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.NoiseRenderType;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;

public class BlackboardBlockTileRenderer
implements BlockEntityRenderer<BlackboardBlockTile> {
    public static final int WIDTH = 6;
    private final Minecraft mc = Minecraft.getInstance();
    private final Camera camera;
    private final boolean noise;

    public BlackboardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.camera = this.mc.gameRenderer.getMainCamera();
        this.noise = MiscUtils.FESTIVITY.isAprilsFool();
    }

    public int getViewDistance() {
        return this.noise ? 64 : 8;
    }

    public boolean shouldRender(BlackboardBlockTile blockEntity, Vec3 cameraPos) {
        return super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(BlackboardBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int combinedOverlayIn) {
        LocalPlayer player;
        BlockHitResult blockHit;
        if (!CommonConfigs.Building.BLACKBOARD_MODE.get().canManualDraw() && !this.noise) {
            return;
        }
        Direction dir = tile.getDirection();
        float yaw = -dir.toYRot();
        Vec3 cameraPos = this.camera.getPosition();
        BlockPos pos = tile.getBlockPos();
        if (this.noise) {
            int lu = VertexUtil.lightU((int)light);
            int lv = VertexUtil.lightV((int)light);
            Uniform intensity = ClientRegistry.NOISE_SHADER.get().getUniform("Intensity");
            if (intensity != null) {
                intensity.set(1.0f);
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.rot((Direction)dir));
            poseStack.translate(-0.5, -0.5, 0.1865);
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.buffer(bufferSource, NoiseRenderType.RENDER_TYPE);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)255, (int)lu, (int)lv);
            poseStack.popPose();
            return;
        }
        if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)pos, (float)yaw, (float)0.0f, (Direction)dir, (float)0.375f)) {
            return;
        }
        HitResult hit = this.mc.hitResult;
        if (hit != null && hit.getType() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).getBlockPos().equals((Object)pos) && tile.getDirection() == blockHit.getDirection() && (player = this.mc.player) != null && Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)player.getMainHandItem()) && BlackboardBlock.getStackChalkColor(player.getMainHandItem()) != null) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.rot((Direction)dir));
            poseStack.translate(-0.5, -0.5, 0.1865);
            int lu = VertexUtil.lightU((int)light);
            int lv = VertexUtil.lightV((int)light);
            Vector2i pair = BlackboardBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)pair.x() * p;
            float y = (float)pair.y() * p;
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.buffer(bufferSource, RenderType::entityCutout);
            poseStack.translate(1.0f - x - p, 1.0f - y - p, 0.0f);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)p, (float)p, (int)lu, (int)lv);
            poseStack.popPose();
        }
    }
}

