/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.IFrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FrameBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FrameBlock
extends MimicBlock
implements EntityBlock,
IFrameBlock {
    public static final List<Block> FRAMED_BLOCKS = new ArrayList<Block>();
    public static final BooleanProperty HAS_BLOCK = ModBlockProperties.HAS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_15;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape OCCLUSION_SHAPE = Block.box((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)15.99, (double)15.99);
    private final Map<Block, Block> filledBlocks = new HashMap<Block, Block>();

    public FrameBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Integer)state.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)HAS_BLOCK, (Comparable)Boolean.valueOf(false)));
        FRAMED_BLOCKS.add((Block)this);
    }

    public void registerFilledBlock(Block inserted, Block filled) {
        this.filledBlocks.put(inserted, filled);
    }

    @Override
    @Nullable
    public Block getFilledBlock(Block inserted) {
        return this.filledBlocks.get(inserted);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.getBlock() instanceof FrameBlock) {
            boolean neighborHasBlock;
            boolean hasBlock = (Boolean)state.getValue((Property)HAS_BLOCK);
            return hasBlock == (neighborHasBlock = ((Boolean)adjacentBlockState.getValue((Property)HAS_BLOCK)).booleanValue()) || super.skipRendering(state, adjacentBlockState, side);
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FrameBlockTile(pPos, pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHT_LEVEL, HAS_BLOCK, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FrameBlockTile) {
            FrameBlockTile tile = (FrameBlockTile)blockEntity;
            return tile.interactWithPlayer(level, pos, player, hand, hitResult, stack, true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        FrameBlockTile tile;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)HAS_BLOCK)).booleanValue() && (blockEntity = reader.getBlockEntity(pos)) instanceof FrameBlockTile && !(tile = (FrameBlockTile)blockEntity).getHeldBlock().isAir()) {
            return Shapes.block();
        }
        return OCCLUSION_SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.block();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)HAS_BLOCK)).booleanValue()) {
            return Shapes.block();
        }
        return super.getCollisionShape(state, reader, pos, context);
    }

    public float getShadeBrightness(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_BLOCK) != false ? 0.2f : 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_BLOCK) == false || super.propagatesSkylightDown(state, reader, pos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FrameBlockTile) {
            FrameBlockTile tile = (FrameBlockTile)blockEntity;
            tile.getHeldBlock().getAnalogOutputSignal(world, pos);
        }
        return 0;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        if (((Boolean)state.getValue((Property)HAS_BLOCK)).booleanValue()) {
            return false;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> true;
            case PathComputationType.WATER -> state.getFluidState().is(FluidTags.WATER);
        };
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)HAS_BLOCK)).booleanValue()) {
            return level.getMaxLightLevel();
        }
        return super.getLightBlock(state, level, pos);
    }
}

