/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FlagBlockTile
extends BlockEntity
implements Nameable,
IColored {
    public final float offset;
    @Nullable
    private Component name;
    private final DyeColor baseColor;
    private BannerPatternLayers patterns;

    public FlagBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, ((IColored)state.getBlock()).getColor());
    }

    public FlagBlockTile(BlockPos pos, BlockState state, DyeColor color) {
        super(ModRegistry.FLAG_TILE.get(), pos, state);
        this.baseColor = color;
        this.offset = 3.0f * (Mth.sin((float)this.worldPosition.getX()) + Mth.sin((float)this.worldPosition.getZ()));
        this.patterns = BannerPatternLayers.EMPTY;
    }

    public void setCustomName(Component component) {
        this.name = component;
    }

    public BannerPatternLayers getPatterns() {
        return this.patterns;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.patterns.equals((Object)BannerPatternLayers.EMPTY)) {
            tag.put("patterns", (Tag)BannerPatternLayers.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.patterns).getOrThrow());
        }
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        if (tag.contains("patterns")) {
            BannerPatternLayers.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("patterns")).resultOrPartial(string -> Supplementaries.LOGGER.error("Failed to parse flag patterns: '{}'", string)).ifPresent(bannerPatternLayers -> {
                this.patterns = bannerPatternLayers;
            });
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.patterns = (BannerPatternLayers)componentInput.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.BANNER_PATTERNS, (Object)this.patterns);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("patterns");
        tag.remove("CustomName");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)FlagBlock.FACING);
    }

    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)("block.supplementaries.flag_" + this.baseColor.getName()));
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Nullable
    public DyeColor getColor() {
        return this.baseColor;
    }
}

