/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.WeatheredHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WeatheredMapRecipe
extends CustomRecipe {
    private final Ingredient ink;
    private final boolean setAntique;
    private static WeakReference<ServerLevel> lastLevelHack = null;

    public WeatheredMapRecipe(CraftingBookCategory category, Ingredient ink, boolean setAntique) {
        super(category);
        this.ink = ink;
        this.setAntique = setAntique;
    }

    public static void onWorldUnload() {
        lastLevelHack = null;
    }

    public boolean matches(CraftingInput inv, Level level) {
        boolean match;
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (WeatheredMapRecipe.isMap(stack)) {
                if (itemstack != null) {
                    return false;
                }
                itemstack = stack;
                continue;
            }
            if (this.ink.test(stack)) {
                if (itemstack1 != null) {
                    return false;
                }
                itemstack1 = stack;
                continue;
            }
            return false;
        }
        boolean bl = match = itemstack != null && itemstack1 != null;
        if (match && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            lastLevelHack = new WeakReference<ServerLevel>(serverLevel);
        }
        return match;
    }

    private static boolean isMap(ItemStack stack) {
        return stack.getItem() == Items.FILLED_MAP;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof MapItem)) continue;
            ItemStack s = stack.copy();
            s.setCount(1);
            if (lastLevelHack != null) {
                WeatheredHandler.setAntique((Level)lastLevelHack.get(), s, this.setAntique, false);
                AntiqueInkItem.setAntiqueInk(s, true);
            }
            return s;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ANTIQUE_MAP.get();
    }

    public static class Serializer
    implements RecipeSerializer<WeatheredMapRecipe> {
        private static final MapCodec<WeatheredMapRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ink), (App)Codec.BOOL.optionalFieldOf("set_antique", (Object)false).forGetter(recipe -> recipe.setAntique)).apply((Applicative)instance, WeatheredMapRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, WeatheredMapRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.ink, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.setAntique, WeatheredMapRecipe::new);

        public MapCodec<WeatheredMapRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WeatheredMapRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

