/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.components.QuiverContent;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomArrowFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RandomArrowFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> RandomArrowFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.INT.optionalFieldOf("min", (Object)3).forGetter(f -> f.min), (App)Codec.INT.optionalFieldOf("max", (Object)12).forGetter(f -> f.max))).apply((Applicative)instance, RandomArrowFunction::new));
    private static final List<ItemStack> RANDOM_ARROWS = new ArrayList<ItemStack>();
    private final int min;
    private final int max;

    public static void setup() {
        for (Holder potion : BuiltInRegistries.POTION.holders().toList()) {
            if (potion.is(ModTags.QUIVER_POTION_BLACKLIST)) continue;
            boolean isNegative = false;
            for (MobEffectInstance e : ((Potion)potion.value()).getEffects()) {
                if (((MobEffect)e.getEffect().value()).isBeneficial()) continue;
                isNegative = true;
                break;
            }
            if (!isNegative) continue;
            RANDOM_ARROWS.add(PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)potion));
        }
        RANDOM_ARROWS.add(new ItemStack((ItemLike)Items.SPECTRAL_ARROW));
    }

    public RandomArrowFunction(List<LootItemCondition> pConditions, int min, int max) {
        super(pConditions);
        this.min = min;
        this.max = max;
    }

    public LootItemFunctionType<RandomArrowFunction> getType() {
        return ModRegistry.RANDOM_ARROW_FUNCTION.get();
    }

    public ItemStack run(ItemStack pStack, LootContext pContext) {
        RandomSource random = pContext.getRandom();
        RandomArrowFunction.createRandomQuiver(random, pStack, random.nextInt(this.min, this.max + 1));
        return pStack;
    }

    public static ItemStack createRandomQuiver(RandomSource random, float specialMultiplier) {
        ItemStack quiver = new ItemStack((ItemLike)ModRegistry.QUIVER_ITEM.get());
        int amount = random.nextInt(3, (int)(8.0f + specialMultiplier * 4.0f));
        return RandomArrowFunction.createRandomQuiver(random, quiver, amount);
    }

    private static ItemStack createRandomQuiver(RandomSource random, ItemStack quiver, int amount) {
        int stackAmount;
        QuiverContent data = (QuiverContent)quiver.get(ModComponents.QUIVER_CONTENT.get());
        if (data == null) {
            return quiver;
        }
        QuiverContent.Mutable mutable = data.toMutable();
        for (int tries = 0; amount > 0 && tries < 10; amount -= stackAmount, ++tries) {
            stackAmount = random.nextInt(1, 7);
            ItemStack arrow = RANDOM_ARROWS.get(random.nextInt(RANDOM_ARROWS.size())).copy();
            stackAmount = Math.min(amount, stackAmount);
            arrow.setCount(stackAmount);
            mutable.tryAdding(arrow);
        }
        mutable.setSelectedSlot(0);
        quiver.set(ModComponents.QUIVER_CONTENT.get(), (Object)mutable.toImmutable());
        return quiver;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final int min;
        private final int max;

        public Builder() {
            this(3, 12);
        }

        public Builder(int min, int max) {
            this.min = min;
            this.max = max;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new RandomArrowFunction(this.getConditions(), this.min, this.max);
        }
    }
}

