/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ServerBoundCycleSelectableContainerItemPacket(int amount, SlotReference slotReference, boolean setSlot) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundCycleSelectableContainerItemPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_cycle_selectable_container_item"), ServerBoundCycleSelectableContainerItemPacket::new);

    public ServerBoundCycleSelectableContainerItemPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), (SlotReference)SlotReference.STREAM_CODEC.decode((Object)buf), buf.readBoolean());
    }

    public ServerBoundCycleSelectableContainerItemPacket(int amount, SlotReference slot) {
        this(amount, slot, false);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.amount);
        SlotReference.STREAM_CODEC.encode((Object)buf, (Object)this.slotReference);
        buf.writeBoolean(this.setSlot);
    }

    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = this.slotReference.get((LivingEntity)player2);
            Item item = stack.getItem();
            if (!(item instanceof SelectableContainerItem)) {
                Supplementaries.error();
            } else {
                SelectableContainerItem item2 = (SelectableContainerItem)item;
                item2.modify(stack, data -> {
                    if (this.setSlot) {
                        data.setSelectedSlot(this.amount);
                    } else {
                        data.cycle(this.amount);
                    }
                    return true;
                });
            }
        } else {
            Supplementaries.error();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

