/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.cannon;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class CannonUtils {
    public static Pair<@Nullable CannonTrajectory, Float> computeTrajectory(CannonAccess access, class_243 targetPos, ShootingMode shootingMode) {
        CannonBlockTile cannonTile = access.getInternalCannon();
        class_243 cannonPos = access.getCannonGlobalPosition(0.0f);
        class_243 localTarget = targetPos.method_1020(cannonPos);
        localTarget = localTarget.method_1019(localTarget.method_1029().method_1021((double)0.05f));
        CannonAccess.Restraint restraints = access.getPitchAndYawRestrains();
        IBallisticBehavior.Data ballistic = cannonTile.getTrajectoryData();
        float minPitch = restraints.minPitch() * ((float)Math.PI / 180);
        float maxPitch = restraints.maxPitch() * ((float)Math.PI / 180);
        Pair<class_241, Float> vec3ToPoint = CannonUtils.vec3ToPoint2d(localTarget);
        class_241 targetPoint = (class_241)vec3ToPoint.getFirst();
        float initialYaw = ((Float)vec3ToPoint.getSecond()).floatValue();
        CannonTrajectory trajectory = CannonTrajectory.findBest(targetPoint, ballistic.gravity(), ballistic.drag(), cannonTile.getFirePower() * ballistic.initialSpeed(), shootingMode, minPitch, maxPitch);
        return Pair.of((Object)trajectory, (Object)Float.valueOf(initialYaw));
    }

    public static class_243 point2dToVec3(class_241 point, float yaw) {
        return new class_243(0.0, (double)point.field_1342, (double)(-point.field_1343)).method_1024(-yaw);
    }

    public static Pair<class_241, Float> vec3ToPoint2d(class_243 point) {
        float yaw = (float)Math.PI + (float)class_3532.method_15349((double)(-point.field_1352), (double)point.field_1350);
        class_241 vec2 = new class_241((float)class_3532.method_39241((double)point.field_1352, (double)point.field_1350), (float)point.field_1351);
        return Pair.of((Object)vec2, (Object)Float.valueOf(yaw));
    }

    public static void spawnSmokeTrail(class_1937 level, class_4587 poseStack, class_5819 ran, class_243 sp) {
        int smokeCount = 40;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.method_22903();
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((class_5819)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.method_46416(-aperture / 2.0f + ran.method_43057() * aperture, -aperture / 2.0f + ran.method_43057() * aperture, 0.0f);
            Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            level.method_8406((class_2394)class_2398.field_11251, (double)p.x, (double)p.y, (double)p.z, (double)speed.x + sp.field_1352, (double)speed.y + sp.field_1351, (double)speed.z + sp.field_1350);
            poseStack.method_22909();
        }
    }

    public static void spawnDustRing(class_1937 level, class_4587 poseStack, class_243 sp) {
        poseStack.method_22903();
        Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(380.0f * (float)i / (float)dustCount));
            float vel = 0.05f;
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, vel, 0.0f));
            class_2400 campfireCosySmoke = ModParticles.BOMB_SMOKE_PARTICLE.get();
            level.method_8406((class_2394)campfireCosySmoke, (double)p.x, (double)p.y, (double)p.z, (double)speed.x + sp.field_1352, (double)speed.y + sp.field_1351, (double)speed.z + sp.field_1350);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }
}

