/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.components.CannonballWhitelist;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonballExplosionPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2490;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CannonBallEntity
extends ImprovedProjectileEntity {
    private final List<CannonBallEntity> justCollidedWith = new ArrayList<CannonBallEntity>();
    private int bounces = 0;

    public CannonBallEntity(class_1309 thrower) {
        super(ModEntities.CANNONBALL.get(), thrower, thrower.method_37908());
        this.maxAge = 6000;
        this.field_23807 = true;
    }

    public CannonBallEntity(class_1299<CannonBallEntity> type, class_1937 level) {
        super(type, level);
        this.maxAge = 6000;
        this.field_23807 = true;
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("bounces", this.bounces);
    }

    public void method_5651(class_2487 compound) {
        super.method_5651(compound);
        this.bounces = compound.method_10550("bounces");
    }

    protected class_1792 method_16942() {
        return ModRegistry.CANNONBALL.get().method_8389();
    }

    public void method_5773() {
        super.method_5773();
        this.justCollidedWith.clear();
    }

    protected double method_7490() {
        return 0.035f;
    }

    public float getDefaultShootVelocity() {
        return 0.9f;
    }

    public void spawnTrailParticles() {
        class_243 speed = this.method_18798();
        class_243 normalSpeed = speed.method_1029();
        double pitch = Math.asin(normalSpeed.field_1351);
        double yaw = Math.atan2(normalSpeed.field_1352, normalSpeed.field_1350);
        double dx = this.method_23317() - this.field_6014;
        double dy = this.method_23318() - this.field_6036;
        double dz = this.method_23321() - this.field_5969;
        for (int k = 0; k < 2; ++k) {
            if (!((double)this.field_5974.method_43057() < speed.method_1033() * 0.35)) continue;
            Vector3f offset = new Vector3f(0.0f, this.field_5974.method_43057() * this.method_17681() * 0.7f, 0.0f);
            offset.rotateZ(this.method_37908().field_9229.method_43057() * ((float)Math.PI * 2));
            offset.rotateX((float)pitch);
            offset.rotateY((float)yaw);
            float j = this.field_5974.method_43057() * -0.5f;
            this.method_37908().method_8406((class_2394)ModParticles.WIND_STREAM.get(), (double)offset.x + (double)j * dx, (double)offset.y + (double)j * dy + (double)(this.method_17681() / 3.0f), (double)offset.z + (double)j * dz, (double)this.method_5628(), 0.0, 0.0);
        }
    }

    public void method_5711(byte id) {
        class_2388 particleData;
        super.method_5711(id);
        Object object = particleData = ClientConfigs.Items.CANNONBALL_3D.get() != false ? new class_2388(class_2398.field_11217, ModRegistry.CANNONBALL.get().method_9564()) : new class_2392(class_2398.field_11218, this.method_7495());
        if (id == 3) {
            float speed = 0.05f;
            for (int i = 0; i < 8; ++i) {
                double k = this.field_5974.method_43059() * (double)speed;
                double l = this.field_5974.method_43059() * (double)speed;
                double m = this.field_5974.method_43059() * (double)speed;
                this.method_37908().method_8406((class_2394)particleData, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), k, l, m);
            }
        }
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        if (this.maybeBounce(result)) {
            return;
        }
        if (!this.method_37908().field_9236) {
            double radius = CommonConfigs.Functional.CANNONBALL_RADIUS.get();
            class_243 movement = this.method_18798();
            double vel = Math.abs(movement.method_1033());
            float scaling = 5.0f;
            float maxAmount = (float)(vel * vel * (double)scaling);
            class_243 loc = this.method_19538();
            class_2338 pos = result.method_17777();
            CannonballWhitelist wl = (CannonballWhitelist)this.method_7495().method_57824(ModComponents.CANNONBALL_WHITELIST.get());
            Set<class_2248> whitelist = wl != null ? wl.blocks() : null;
            CannonBallExplosion exp = new CannonBallExplosion(this.method_37908(), (class_1297)this, loc.method_10216(), loc.method_10214(), loc.method_10215(), pos, maxAmount, (float)radius, whitelist);
            exp.method_8348();
            exp.method_8350(true);
            float exploded = exp.getExploded();
            if (exploded != 0.0f) {
                double speedUsed = exploded / maxAmount;
                double factor = 1.0 - speedUsed;
                if (factor <= 0.0 || factor > 1.0) {
                    Supplementaries.error();
                }
                this.method_18799(movement.method_1021(factor));
                ClientBoundCannonballExplosionPacket message = ClientBoundCannonballExplosionPacket.cannonball(exp, this);
                NetworkHelper.sendToAllClientPlayersInDefaultRange((class_3218)((class_3218)this.method_37908()), (class_2338)pos, (class_8710)message);
            }
            this.field_6007 = true;
            if (this.method_18798().method_1027() < 0.04000000000000001 || exploded == 0.0f) {
                this.method_5783(ModSounds.CANNONBALL_BREAK.get(), 1.0f, 1.5f);
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_31472();
            } else {
                class_243 targetPos = new class_243(this.field_6014, this.field_6036, this.field_5969).method_1019(this.movementOld);
                class_243 missingMovement = targetPos.method_1020(this.method_19538());
                if (missingMovement.method_1027() > 1.0E-4) {
                    this.method_5784(class_1313.field_6308, missingMovement);
                }
            }
        }
    }

    private boolean maybeBounce(class_3965 hit) {
        boolean shouldBounce;
        if (this.bounces >= 3) {
            return false;
        }
        ++this.bounces;
        class_2350 hitDirection = hit.method_17780();
        class_2338 pos = hit.method_17777();
        class_243 velocity = this.method_18798();
        Vector3f surfaceNormal = hitDirection.method_23955();
        class_1937 level = this.method_37908();
        class_2680 hitBlock = level.method_8320(pos);
        if (hitBlock.method_26204() instanceof class_2490) {
            shouldBounce = true;
        } else {
            float bounceCosAngle;
            double dot = surfaceNormal.dot((Vector3fc)velocity.method_46409());
            double cosAngle = Math.abs(dot / velocity.method_1033());
            boolean bl = shouldBounce = cosAngle < (double)(bounceCosAngle = class_3532.method_15362((float)1.3089969f));
        }
        if (shouldBounce) {
            class_243 newVel = new class_243(velocity.method_46409().reflect((Vector3fc)surfaceNormal));
            this.method_18799(newVel);
            this.field_6007 = true;
            double missingDistance = velocity.method_1020(this.method_19538().method_1020(new class_243(this.field_6014, this.field_6036, this.field_5969))).method_1033();
            this.method_33574(this.method_19538().method_1019(newVel.method_1029().method_1021(missingDistance)));
            level.method_32888((class_6880)class_5712.field_28159, this.method_19538(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)hitBlock));
            this.addLandingEffects(hit);
            return true;
        }
        return false;
    }

    private void addLandingEffects(class_3965 hit) {
        this.method_5783(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        class_2338 pos = hit.method_17777();
        class_2680 state = this.method_37908().method_8320(pos);
        double speed = this.method_18798().method_1027();
        double minSpeed = 0.2f;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sl = (class_3218)class_19372;
            if (!state.method_26215() && speed > minSpeed) {
                double x = hit.method_17784().field_1352;
                double y = hit.method_17784().field_1351;
                double z = hit.method_17784().field_1350;
                int count = Math.min(10, (int)(speed * 4.0) + 1);
                class_2388 blockParticleOption = new class_2388(class_2398.field_11217, state);
                SuppPlatformStuff.setParticlePos(blockParticleOption, pos);
                sl.method_14199((class_2394)blockParticleOption, x, y, z, count, 0.0, 0.0, 0.0, 0.15);
            }
        }
    }

    protected void method_7454(class_3966 result) {
        float f;
        class_1297 target = result.method_17782();
        if (target instanceof class_1309) {
            class_1309 le = (class_1309)target;
            f = 0.1f;
        } else {
            f = 0.8f;
        }
        float lossFactor = f;
        float cannonballDensity = 8.0f;
        float m2 = (float)target.method_5829().method_995() * (target instanceof CannonBallEntity ? cannonballDensity : 0.0f);
        float m1 = (float)this.method_5829().method_995() * cannonballDensity;
        Vector3f v2i = target.method_18798().method_46409();
        Vector3f v1i = this.method_18798().method_46409();
        double initialKineticEnergy = 0.5f * m1 * v1i.lengthSquared() + 0.5f * m2 * v2i.lengthSquared();
        float elasticity = 1.0f;
        if (target instanceof class_1309) {
            class_1309 le = (class_1309)target;
            double lostEnergy = initialKineticEnergy * (double)(1.0f - lossFactor);
            double dmgMult = CommonConfigs.Functional.CANNONBALL_POWER_SCALING.get();
            float amount = (float)(lostEnergy * dmgMult);
            float oldHealth = le.method_6032();
            if (le.method_5643(ModDamageSources.cannonBallExplosion(this.method_37908(), (class_1297)this, this.method_24921()), amount)) {
                elasticity = class_3532.method_15355((float)(1.0f - lossFactor));
            }
            if (!this.method_37908().field_9236 && le instanceof class_1548 && oldHealth >= le.method_6063()) {
                this.maybeDropDisc(le);
            }
        }
        Vector3f v1f = new Vector3f();
        Vector3f v2f = new Vector3f();
        for (int i = 0; i < 3; ++i) {
            float c1 = (v1i.get(i) * (m1 - m2) + elasticity * 2.0f * m2 * v2i.get(i)) / (m1 + m2);
            float c2 = (v2i.get(i) * (m2 - m1) + elasticity * 2.0f * m1 * v1i.get(i)) / (m1 + m2);
            v1f.setComponent(i, c1);
            v2f.setComponent(i, c2);
        }
        this.method_18799(new class_243(v1f));
        target.method_18799(new class_243(v2f));
        this.field_6007 = true;
        Vector3f finalMomentum = v1f.mul(m1, new Vector3f()).add((Vector3fc)v2f.mul(m2, new Vector3f()));
        double finalKineticEnergy = 0.5f * m1 * v1f.lengthSquared() + 0.5f * m2 * v2f.lengthSquared();
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            c.justCollidedWith.add(this);
            this.method_5783(ModSounds.CANNONBALL_BOUNCE.get(), 2.2f, 1.0f);
        }
    }

    private void maybeDropDisc(class_1309 le) {
        if (!le.method_5805() && CommonConfigs.Functional.PIRATE_DISC_ENABLED.get().booleanValue() && this.method_24921() instanceof class_1657 && ((LivingEntityAccessor)le).invokeShouldDropLoot() && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
            le.method_5706((class_1935)ModRegistry.PIRATE_DISC.get());
        }
    }

    protected boolean method_26958(class_1297 target) {
        if (target instanceof CannonBallEntity) {
            CannonBallEntity c = (CannonBallEntity)target;
            return !c.justCollidedWith.contains((Object)this);
        }
        return super.method_26958(target);
    }

    public boolean method_49108() {
        return true;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, amount);
    }
}

