/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5819;

public class ManeuverAndShootCannonBehavior
extends class_4097<class_1309> {
    private int attackDelay;
    private CannonAccess access;

    public ManeuverAndShootCannonBehavior() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18438, (Object)class_4141.field_18456, (Object)class_4140.field_20616, (Object)class_4141.field_18458));
    }

    protected boolean method_18919(class_3218 level, class_1309 owner) {
        class_1297 boat = owner.method_49694();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasFuelAndProjectiles();
        }
        class_1309 livingentity = ManeuverAndShootCannonBehavior.getAttackTarget(owner);
        return class_4215.method_24565((class_1309)owner, (class_1309)livingentity);
    }

    private static class_1309 getAttackTarget(class_1309 shooter) {
        return (class_1309)shooter.method_18868().method_18904(class_4140.field_22355).get();
    }

    protected boolean method_18927(class_3218 level, class_1309 owner, long gameTime) {
        class_1297 boat = owner.method_49694();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            return cb.getInternalCannon().hasFuelAndProjectiles();
        }
        return false;
    }

    protected void method_18920(class_3218 level, class_1309 owner, long gameTime) {
        class_1297 boat = owner.method_49694();
        if (boat instanceof CannonBoatEntity) {
            CannonBoatEntity cb = (CannonBoatEntity)boat;
            this.access = cb;
        }
    }

    protected boolean method_18915(long gameTime) {
        return false;
    }

    protected void method_18926(class_3218 level, class_1309 entity, long gameTime) {
        this.access = null;
    }

    protected void method_18924(class_3218 level, class_1309 owner, long gameTime) {
        class_1309 livingentity = ManeuverAndShootCannonBehavior.getAttackTarget(owner);
        this.lookAtTarget(owner, livingentity);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (ManeuverAndShootCannonBehavior.aimCannonAndShoot(this.access, owner, livingentity, this.attackDelay <= 0)) {
            this.attackDelay = class_3532.method_32751((class_5819)level.field_9229, (int)20, (int)40);
        }
    }

    public static boolean aimCannonAndShoot(CannonAccess access, class_1309 shooter, class_1309 target, boolean canShoot) {
        CannonBlockTile cannonTile = access.getInternalCannon();
        if (cannonTile.isOnCooldown()) {
            return false;
        }
        class_243 cannonGlobalPosition = access.getCannonGlobalPosition(0.0f);
        class_243 targetLoc = target.method_19538();
        byte power = 1;
        int maxPower = cannonTile.getFuel().method_7947();
        float distance = (float)targetLoc.method_1022(cannonGlobalPosition);
        if (distance > 64.0f) {
            power = 4;
        } else if (distance > 32.0f) {
            power = 3;
        } else if (distance > 16.0f) {
            power = 2;
        }
        targetLoc = targetLoc.method_1019(target.method_18798().method_1021((double)distance * 0.2)).method_1031(0.0, 0.6, 0.0);
        power = (byte)Math.min(power, maxPower);
        cannonTile.setPowerLevel(power);
        Pair<CannonTrajectory, Float> comp = CannonUtils.computeTrajectory(access, targetLoc, ShootingMode.DOWN);
        CannonTrajectory cannonTrajectory = (CannonTrajectory)comp.getFirst();
        float wantedGlobalYawDeg = ((Float)comp.getSecond()).floatValue() * 57.295776f;
        if (cannonTrajectory != null) {
            float newCannonGlobalYaw;
            class_243 hitLoc;
            double distance1;
            float cannonGlobalYawOffsetDeg = access.getCannonGlobalYawOffset(0.0f);
            float wantedLocalYawDeg = wantedGlobalYawDeg + cannonGlobalYawOffsetDeg;
            ManeuverAndShootCannonBehavior.setCannonAnglesToFollowTrajectory(access, cannonTrajectory, wantedLocalYawDeg);
            if (canShoot && (distance1 = (hitLoc = cannonTrajectory.getHitLocation(cannonGlobalPosition, newCannonGlobalYaw = (cannonTile.getYaw() - cannonGlobalYawOffsetDeg) * ((float)Math.PI / 180))).method_1022(targetLoc)) < 0.1) {
                cannonTile.ignite((class_1297)shooter, access);
                return true;
            }
        }
        return false;
    }

    private static void setCannonAnglesToFollowTrajectory(CannonAccess access, CannonTrajectory trajectory, float wantedLocalYawDeg) {
        if (trajectory != null) {
            float followSpeed = 1.0f;
            CannonBlockTile cannon = access.getInternalCannon();
            cannon.setPitch(access, class_3532.method_17821((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
            cannon.setYaw(access, wantedLocalYawDeg);
            cannon.method_5431();
            access.updateClients();
        }
    }

    private void lookAtTarget(class_1309 shooter, class_1309 target) {
        shooter.method_18868().method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)target, true));
    }
}

