/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.supplementaries.common.inventories.VariableSizeContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class VariableSizePreviewRenderer
implements PreviewRenderer {
    private static final PreviewRenderer DELEGATE = PreviewRenderer.getModRendererInstance();
    private final Supplier<Integer> unlockedSlots;
    private final class_2960 texture;
    private List<class_1799> items;
    private PreviewType previewType;
    private int[] dims;

    public VariableSizePreviewRenderer(Supplier<Integer> unlockedSlots, class_2960 texture) {
        this.unlockedSlots = unlockedSlots;
        this.items = List.of();
        this.initDims();
        this.texture = texture;
    }

    public int getHeight() {
        if (this.previewType != PreviewType.FULL) {
            return DELEGATE.getHeight();
        }
        return 7 + this.dims[1] * 18 + 7;
    }

    public int getWidth() {
        if (this.previewType != PreviewType.FULL) {
            return DELEGATE.getHeight();
        }
        return 7 + this.dims[0] * 18 + 7;
    }

    public void setPreview(PreviewContext context, PreviewProvider provider) {
        this.items = provider.getInventory(context);
        this.initDims();
        DELEGATE.setPreview(context, provider);
    }

    private void initDims() {
        int size = this.unlockedSlots.get();
        this.dims = VariableSizeContainerMenu.getRatio(size);
        if (this.dims[0] > 9) {
            this.dims[0] = 9;
            this.dims[1] = (int)Math.ceil((float)size / 9.0f);
        }
    }

    public void setPreviewType(PreviewType type) {
        this.previewType = type;
        DELEGATE.setPreviewType(type);
    }

    public void draw(int x, int y, class_332 graphics, class_327 font, int mouseX, int mouseY) {
        if (this.previewType != PreviewType.FULL) {
            DELEGATE.draw(x, y, graphics, font, mouseX, mouseY);
            return;
        }
        RenderSystem.enableDepthTest();
        this.renderBackground(x, y, graphics);
        this.renderSlots(x, y, graphics, font, mouseX, mouseY);
        this.renderInnerTooltip(x, y, graphics, font, mouseX, mouseY);
    }

    private void renderBackground(int x, int y, class_332 graphics) {
        int w = this.dims[0] * 18;
        int h = this.dims[1] * 18;
        int rEdgeOffset = 7 + w;
        int bEdgeOffset = 7 + h;
        graphics.method_25302(this.texture, x, y, 0, 0, rEdgeOffset, 7);
        graphics.method_25302(this.texture, x + rEdgeOffset, y, 169, 0, 7, 7);
        graphics.method_25302(this.texture, x, y + 7, 0, 7, rEdgeOffset, h);
        graphics.method_25302(this.texture, x + rEdgeOffset, y + 7, 169, 7, 7, h);
        graphics.method_25302(this.texture, x, y + bEdgeOffset, 0, 159, rEdgeOffset, 7);
        graphics.method_25302(this.texture, x + rEdgeOffset, y + bEdgeOffset, 169, 159, 7, 7);
    }

    private void renderSlots(int x, int y, class_332 graphics, class_327 font, int mouseX, int mouseY) {
        int slot = 0;
        int size = this.unlockedSlots.get();
        for (int h = 0; h < this.dims[1]; ++h) {
            int dimx = Math.min(this.dims[0], size);
            int xp = 7 + this.dims[0] * 18 / 2 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                int slotX = xp + x + j * 18;
                int slotY = 7 + y + 18 * h;
                graphics.method_52706(ModTextures.SLOT_SPRITE, slotX, slotY, 18, 18);
                if (mouseX >= slotX && mouseX < slotX + 18 && mouseY >= slotY && mouseY < slotY + 18) {
                    class_465.method_33285((class_332)graphics, (int)(slotX + 1), (int)(slotY + 1), (int)0);
                }
                if (slot < this.items.size()) {
                    class_1799 stack = this.items.get(slot);
                    graphics.method_51445(stack, slotX + 1, slotY + 1);
                    graphics.method_51431(font, stack, slotX + 1, slotY + 1);
                }
                ++slot;
            }
            size -= this.dims[0];
        }
    }

    private class_1799 getStackAt(int x, int y) {
        int slot = -1;
        if (y >= 7) {
            int slotX;
            int slotY = (y - 7) / 18;
            int size = this.unlockedSlots.get() - this.dims[0] * slotY;
            int dimx = Math.min(this.dims[0], size);
            int xp = 7 + this.dims[0] * 18 / 2 - dimx * 18 / 2;
            if (x >= xp && (slotX = (x - xp) / 18) < dimx) {
                slot = slotX + slotY * this.dims[0];
            }
        }
        if (slot >= 0 && slot < this.items.size()) {
            return this.items.get(slot);
        }
        return class_1799.field_8037;
    }

    private void renderInnerTooltip(int x, int y, class_332 graphics, class_327 font, int mouseX, int mouseY) {
        class_1799 stack = this.getStackAt(mouseX - x, mouseY - y);
        if (!stack.method_7960()) {
            graphics.method_51446(font, stack, mouseX, mouseY);
        }
    }
}

