/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.common.utils.RopeHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractRopeBlock
extends WaterBlock
implements IRopeConnection {
    public static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    public static final BooleanProperty KNOT = ModBlockProperties.KNOT;
    private final Map<BlockState, VoxelShape> shapes;

    public AbstractRopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes.getOrDefault(state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    protected abstract Map<BlockState, VoxelShape> makeShapes();

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, KNOT});
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return this.hasConnection(Direction.DOWN, state) && (this.hasConnection(Direction.UP, state) || entity.m_20182_().m_7098_() - (double)pos.m_123342_() < 0.8125);
    }

    public abstract boolean hasConnection(Direction var1, BlockState var2);

    public abstract BlockState setConnection(Direction var1, BlockState var2, boolean var3);

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (!CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return Shapes.m_83040_();
        }
        return !this.hasConnection(Direction.UP, state) && (context.m_6513_(COLLISION_SHAPE, pos, true) || !this.hasConnection(Direction.DOWN, state)) || !(context instanceof EntityCollisionContext) || !((ec = (EntityCollisionContext)context).m_193113_() instanceof LivingEntity) ? this.m_5940_(state, worldIn, pos, context) : Shapes.m_83040_();
    }

    public boolean shouldConnectToDir(BlockState thisState, BlockPos currentPos, LevelReader world, Direction dir) {
        if (dir.m_122434_().m_122479_() && !CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return false;
        }
        BlockPos facingPos = currentPos.m_121945_(dir);
        return this.shouldConnectToFace(thisState, world.m_8055_(facingPos), facingPos, dir, world);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.m_5776_()) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if (facing == Direction.UP) {
            stateIn = this.setConnection(Direction.DOWN, stateIn, this.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, Direction.DOWN));
        }
        stateIn = this.setConnection(facing, stateIn, this.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, facing));
        if (facing == Direction.DOWN && !worldIn.m_5776_() && CompatHandler.DECO_BLOCKS) {
            DecoBlocksCompat.tryConvertingRopeChandelier(facingState, worldIn, facingPos);
        }
        return (BlockState)stateIn.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(stateIn)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean hasWater = context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_;
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            state = this.setConnection(dir, state, this.shouldConnectToDir(state, pos, (LevelReader)world, dir));
        }
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (BlockState)state.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(state)));
        return state;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.f_46443_) {
            worldIn.m_186460_(pos, (Block)this, 1);
            if (CompatHandler.DECO_BLOCKS) {
                BlockPos down = pos.m_7495_();
                DecoBlocksCompat.tryConvertingRopeChandelier(worldIn.m_8055_(down), (LevelAccessor)worldIn, down);
            }
        }
    }

    public boolean hasMiddleKnot(BlockState state) {
        boolean up = this.hasConnection(Direction.UP, state);
        boolean down = this.hasConnection(Direction.DOWN, state);
        boolean north = this.hasConnection(Direction.NORTH, state);
        boolean east = this.hasConnection(Direction.EAST, state);
        boolean south = this.hasConnection(Direction.SOUTH, state);
        boolean west = this.hasConnection(Direction.WEST, state);
        return !(up && down && !north && !south && !east && !west || !up && !down && north && south && !east && !west || !up && !down && !north && !south && east && west);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_().m_122173_(Direction.UP);
        BlockState upstate = world.m_8055_((BlockPos)mutable);
        if (upstate.m_60713_((Block)this)) {
            return true;
        }
        if (IRopeConnection.isSupportingCeiling((BlockPos)mutable, world)) {
            return true;
        }
        if (CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos.MutableBlockPos facingPos = mutable.m_122159_((Vec3i)pos, direction);
                BlockState sideState = world.m_8055_((BlockPos)facingPos);
                Block b = sideState.m_60734_();
                if (b instanceof AbstractRopeBlock) {
                    return true;
                }
                if (!this.shouldConnectToFace(this.m_49966_(), sideState, (BlockPos)facingPos, direction, world)) continue;
                return true;
            }
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || !level.m_8055_(pos.m_121945_(dir)).m_204336_(BlockTags.f_13076_)) continue;
            level.m_186460_(pos.m_121945_(dir), Blocks.f_50083_, 2 + level.f_46441_.m_188503_(1));
            for (Direction d2 : Direction.Plane.HORIZONTAL) {
                BlockPos fp = pos.m_121945_(d2);
                if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)fp, (Direction)d2.m_122424_())) continue;
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)fp);
                if (fireState.m_61138_((Property)FireBlock.f_53408_)) {
                    fireState = (BlockState)fireState.m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(14));
                }
                level.m_46597_(fp, fireState);
                level.m_186460_(pos.m_121945_(dir), Blocks.f_50083_, 2 + level.f_46441_.m_188503_(1));
            }
            return;
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : 10;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : 100;
    }

    private static boolean findConnectedPulley(Level world, BlockPos pos, Player player, int it, Rotation rot) {
        if (it > 64) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block b = state.m_60734_();
        if (b instanceof AbstractRopeBlock) {
            return AbstractRopeBlock.findConnectedPulley(world, pos.m_7494_(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock) {
            PulleyBlock pulley = (PulleyBlock)b;
            if (it != 0) {
                return pulley.windPulley(state, pos, (LevelAccessor)world, rot, null);
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        Item i = stack.m_41720_();
        if (i == this.m_5456_()) {
            if (hit.m_82434_().m_122434_() == Direction.Axis.Y || this.hasConnection(Direction.DOWN, state)) {
                if (this.hasConnection(Direction.UP, state) && !this.hasConnection(Direction.DOWN, state)) {
                    state = this.setConnection(Direction.DOWN, state, true);
                    world.m_7731_(pos, state, 0);
                }
                if (RopeHelper.addRopeDown(pos.m_7495_(), world, player, handIn, (Block)this)) {
                    SoundType soundtype = state.m_60827_();
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            return InteractionResult.PASS;
        }
        if (stack.m_41619_()) {
            if (this.hasConnection(Direction.UP, state) && AbstractRopeBlock.findConnectedPulley(world, pos, player, 0, player.m_6144_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90)) {
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (!player.m_6144_() && handIn == InteractionHand.MAIN_HAND && world.m_8055_(pos.m_7495_()).m_60734_() == this && RopeHelper.removeRopeDown(pos.m_7495_(), world, (Block)this)) {
                world.m_5594_(player, pos, SoundEvents.f_12087_, SoundSource.BLOCKS, 1.0f, 0.6f);
                if (!player.m_150110_().f_35937_) {
                    ItemsUtil.addStackToExisting(player, new ItemStack((ItemLike)this), true);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        } else if (i instanceof ShearsItem) {
            if (this.hasConnection(Direction.DOWN, state)) {
                if (!world.f_46443_) {
                    world.m_5594_(null, pos, SoundEvents.f_12480_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 0.8f, 1.3f);
                    BlockState newState = (BlockState)this.setConnection(Direction.DOWN, state, false).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(pos, newState, 3);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (entityIn instanceof Arrow && !worldIn.f_46443_) {
            worldIn.m_46953_(pos, true, entityIn);
            worldIn.m_5594_(null, pos, SoundEvents.f_12033_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_60713_((Block)this) || super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.SOUTH, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.WEST, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.NORTH, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.EAST, state));
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.EAST, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.SOUTH, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.WEST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.NORTH, state));
            }
            case Rotation.CLOCKWISE_90 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.WEST, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.NORTH, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.EAST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.SOUTH, state));
            }
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.SOUTH, state));
                yield state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.NORTH, state));
            }
            case Mirror.FRONT_BACK -> {
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.WEST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.EAST, state));
            }
            default -> super.m_6943_(state, mirror);
        };
    }

    @Override
    public boolean canSideAcceptConnection(BlockState state, Direction direction) {
        return true;
    }
}

