/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.tysontheember.orbitalrailgun.ForgeOrbitalRailgunMod;
import net.tysontheember.orbitalrailgun.strike.StrikeExecutor;
import net.tysontheember.orbitalrailgun.util.OrbitalRailgunStrikeManager;
import org.slf4j.Logger;

public final class OrbitalStrikeCommand {
    private static final Logger LOGGER = ForgeOrbitalRailgunMod.LOGGER;
    private static final float DEFAULT_POWER = 1.0f;
    private static final int DEFAULT_RADIUS = 3;
    private static final float MIN_POWER = 0.1f;
    private static final float MAX_POWER = 20.0f;
    private static final int MIN_RADIUS = 1;
    private static final int MAX_RADIUS = 64;

    private OrbitalStrikeCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"orbitalstrike").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> OrbitalStrikeCommand.execute((CommandContext<CommandSourceStack>)ctx, 1.0f, 3))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)20.0f)).executes(ctx -> OrbitalStrikeCommand.execute((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"power"), 3))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> OrbitalStrikeCommand.execute((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"power"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, float power, int radius) throws CommandSyntaxException {
        ServerPlayer sp;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int x = IntegerArgumentType.getInteger(context, (String)"x");
        int z = IntegerArgumentType.getInteger(context, (String)"z");
        ServerLevel level = source.m_81372_();
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        BlockPos target = new BlockPos(x, surfaceY, z);
        Entity entity = source.m_81373_();
        ServerPlayer player = entity instanceof ServerPlayer ? (sp = (ServerPlayer)entity) : null;
        OrbitalRailgunStrikeManager.StrikeRequestResult result = StrikeExecutor.queueStrike(level, target, power, radius, player);
        String logMessage = String.format("/orbitalstrike called by %s at %d,%d (y=%d) power=%.2f radius=%d", source.m_81368_(), x, z, surfaceY, Float.valueOf(power), radius);
        LOGGER.info(logMessage);
        if (!OrbitalRailgunStrikeManager.StrikeRequestResult.ok().success()) {
            Component error = result.message();
            if (error != null) {
                source.m_81352_(error);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"Orbital strike failed."));
            }
            return 0;
        }
        MutableComponent success = Component.m_237113_((String)String.format("Scheduled orbital strike at %d, %d, %d (power=%.2f radius=%d)", target.m_123341_(), target.m_123342_(), target.m_123343_(), Float.valueOf(power), radius));
        source.m_288197_(() -> OrbitalStrikeCommand.lambda$execute$4((Component)success), true);
        return 1;
    }

    private static /* synthetic */ Component lambda$execute$4(Component success) {
        return success;
    }
}

