/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.tysontheember.orbitalrailgun.ForgeOrbitalRailgunMod;
import net.tysontheember.orbitalrailgun.compat.ClaimCompat;
import net.tysontheember.orbitalrailgun.compat.ClaimGuards;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;
import net.tysontheember.orbitalrailgun.network.Network;
import net.tysontheember.orbitalrailgun.network.S2C_PlayStrikeEffects;
import net.tysontheember.orbitalrailgun.registry.ModSounds;
import net.tysontheember.orbitalrailgun.strike.StrikeExecutor;
import org.jetbrains.annotations.Nullable;

public final class OrbitalRailgunStrikeManager {
    private static final ResourceKey<DamageType> STRIKE_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)ForgeOrbitalRailgunMod.id("strike"));
    private static final Component CLAIM_BLOCKED_MESSAGE = Component.m_237113_((String)"\u274c Railgun blocked by claim protection.");
    private static final Map<StrikeKey, ActiveStrike> ACTIVE_STRIKES = new ConcurrentHashMap<StrikeKey, ActiveStrike>();

    private OrbitalRailgunStrikeManager() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(OrbitalRailgunStrikeManager::onServerTick);
    }

    public static void startStrike(ServerPlayer player, BlockPos target) {
        ServerLevel serverLevel = player.m_284548_();
        if (serverLevel.m_5776_()) {
            return;
        }
        double configuredDiameter = (Double)OrbitalConfig.DESTRUCTION_DIAMETER.get();
        double clampedDiameter = Mth.m_14008_((double)configuredDiameter, (double)1.0, (double)256.0);
        double radius = clampedDiameter * 0.5;
        OrbitalRailgunStrikeManager.requestStrike(serverLevel, target, player, radius, 1.0f);
    }

    public static StrikeRequestResult requestStrike(ServerLevel level, BlockPos target, @Nullable ServerPlayer shooter, double radius, float damageMultiplier) {
        return OrbitalRailgunStrikeManager.requestStrike(level, target, shooter, radius, damageMultiplier, false);
    }

    public static StrikeRequestResult requestStrike(ServerLevel level, BlockPos target, @Nullable ServerPlayer shooter, double radius, float damageMultiplier, boolean validateClaims) {
        if (level.m_5776_()) {
            return StrikeRequestResult.failure((Component)Component.m_237113_((String)"Orbital strikes can only be scheduled on the server."));
        }
        double normalizedRadius = Mth.m_14008_((double)radius, (double)0.5, (double)128.0);
        float normalizedMultiplier = Math.max(0.0f, damageMultiplier);
        if (validateClaims && OrbitalRailgunStrikeManager.areClaimsEnforced()) {
            if (shooter == null) {
                MutableComponent message = Component.m_237113_((String)String.format("Strike blocked: a player context is required for claim checks at %d, %d, %d.", target.m_123341_(), target.m_123342_(), target.m_123343_()));
                return StrikeRequestResult.failure((Component)message);
            }
            if (!ClaimGuards.canAffectPosFromPos(level, target, level, target, shooter)) {
                shooter.m_5661_(CLAIM_BLOCKED_MESSAGE, true);
                MutableComponent message = Component.m_237113_((String)String.format("Strike blocked by claim protection at %d, %d, %d.", target.m_123341_(), target.m_123342_(), target.m_123343_()));
                return StrikeRequestResult.failure((Component)message);
            }
        }
        OrbitalRailgunStrikeManager.scheduleStrike(level, target, shooter, normalizedRadius, normalizedMultiplier);
        return StrikeRequestResult.ok();
    }

    private static void scheduleStrike(ServerLevel level, BlockPos target, @Nullable ServerPlayer shooter, double radius, float damageMultiplier) {
        double trackedExtent = Math.max(radius * 4.0, 128.0);
        ArrayList<Entity> tracked = new ArrayList<Entity>(level.m_45933_(null, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)target), (double)trackedExtent, (double)trackedExtent, (double)trackedExtent)));
        StrikeKey key = new StrikeKey((ResourceKey<Level>)level.m_46472_(), target.m_7949_());
        UUID shooterId = shooter != null ? shooter.m_20148_() : null;
        int tickCount = level.m_7654_().m_129921_();
        ACTIVE_STRIKES.put(key, new ActiveStrike(key, tracked, tickCount, shooterId, radius, damageMultiplier));
        if (ModSounds.RAILGUN_SHOOT.isPresent()) {
            double soundZ;
            double soundY;
            double soundX;
            if (shooter != null) {
                soundX = shooter.m_20185_();
                soundY = shooter.m_20186_();
                soundZ = shooter.m_20189_();
            } else {
                soundX = target.m_123341_();
                soundY = target.m_123342_();
                soundZ = target.m_123343_();
            }
            level.m_6263_(null, soundX, soundY, soundZ, (SoundEvent)ModSounds.RAILGUN_SHOOT.get(), SoundSource.PLAYERS, 1.6f, 1.0f);
        }
        float serverRadius = (float)radius;
        Network.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), 512.0, level.m_46472_())), (Object)new S2C_PlayStrikeEffects(target, (ResourceKey<Level>)level.m_46472_(), serverRadius));
    }

    private static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<StrikeKey, ActiveStrike>> iterator = ACTIVE_STRIKES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<StrikeKey, ActiveStrike> entry = iterator.next();
            ActiveStrike strike = entry.getValue();
            ServerLevel level = event.getServer().m_129880_(strike.key.dimension());
            if (level == null) {
                iterator.remove();
                continue;
            }
            int age = event.getServer().m_129921_() - strike.startTick;
            if (age >= 700) {
                iterator.remove();
                OrbitalRailgunStrikeManager.damageEntities(level, strike, age);
                OrbitalRailgunStrikeManager.explode(level, strike);
                continue;
            }
            if (age < 400 || !((Boolean)OrbitalConfig.SUCK_ENTITIES.get()).booleanValue()) continue;
            OrbitalRailgunStrikeManager.pushEntities((Level)level, strike, age);
        }
    }

    private static void pushEntities(Level level, ActiveStrike strike, int age) {
        Vec3 center = Vec3.m_82512_((Vec3i)strike.key.pos());
        for (Entity entity : strike.entities) {
            Vec3 direction;
            double length;
            Player player;
            if (entity == null || !entity.m_6084_() || entity.m_9236_() != level || entity instanceof Player && (player = (Player)entity).m_5833_() || (length = (direction = center.m_82546_(entity.m_20182_())).m_82553_()) < 1.0E-4) continue;
            double magnitude = Math.min(1.0 / Math.max(Math.abs(length - 20.0), 0.001) * 4.0 * ((double)age - 400.0) / 300.0, 5.0);
            Vec3 velocity = direction.m_82541_().m_82490_(magnitude);
            entity.m_20256_(entity.m_20184_().m_82549_(velocity));
            entity.f_19864_ = true;
        }
    }

    private static void damageEntities(ServerLevel level, ActiveStrike strike, int age) {
        Vec3 center = Vec3.m_82512_((Vec3i)strike.key.pos());
        double radius = Math.sqrt(strike.radiusSquared);
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(STRIKE_DAMAGE);
        DamageSource source = new DamageSource((Holder)damageType);
        double configuredDamage = ((Integer)OrbitalConfig.STRIKE_DAMAGE.get()).intValue();
        if (configuredDamage <= 0.0) {
            return;
        }
        float damage = (float)configuredDamage * strike.damageMultiplier;
        boolean respectClaims = OrbitalRailgunStrikeManager.areClaimsEnforced();
        ServerPlayer shooter = respectClaims ? OrbitalRailgunStrikeManager.resolveShooter(level, strike) : null;
        boolean blockedAny = false;
        BlockPos blockedPos = null;
        AABB box = AABB.m_165882_((Vec3)center, (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0));
        List targets = level.m_45933_(null, box);
        for (Entity entity : targets) {
            Player p;
            if (entity == null || !entity.m_6084_() || entity.m_9236_() != level || entity instanceof Player && (p = (Player)entity).m_5833_() || entity.m_20182_().m_82557_(center) > strike.radiusSquared) continue;
            if (respectClaims && !ClaimGuards.canDamageEntity(level, shooter, entity)) {
                blockedAny = true;
                blockedPos = entity.m_20183_().m_7949_();
                continue;
            }
            entity.f_19802_ = Math.min(entity.f_19802_, 2);
            entity.m_6469_(source, damage);
        }
        if (blockedAny) {
            OrbitalRailgunStrikeManager.notifyClaimBlocked(strike, shooter, ClaimBlockType.DAMAGE, blockedPos != null ? blockedPos : strike.key.pos());
        }
    }

    private static void explode(ServerLevel level, ActiveStrike strike) {
        ServerPlayer shooter;
        BlockPos center = strike.key.pos();
        boolean respectClaims = OrbitalRailgunStrikeManager.areClaimsEnforced();
        ServerPlayer serverPlayer = shooter = respectClaims ? OrbitalRailgunStrikeManager.resolveShooter(level, strike) : null;
        if (respectClaims && !ClaimGuards.canAffectPosFromPos(level, center, level, center, shooter)) {
            OrbitalRailgunStrikeManager.notifyClaimBlocked(strike, shooter, ClaimBlockType.EXPLOSION, center);
            return;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean blockedAny = false;
        BlockPos blockedPos = null;
        int horizontalRange = strike.horizontalRange;
        int worldMinY = level.m_141937_();
        int worldMaxY = level.m_151558_() - 1;
        int cfgFloor = (Integer)OrbitalConfig.MIN_DESTROY_Y.get();
        int yEnd = Math.max(worldMinY, cfgFloor);
        int yStart = worldMaxY;
        LongOpenHashSet allowedPositions = new LongOpenHashSet();
        for (int y = yStart; y >= yEnd; --y) {
            for (int x = -horizontalRange; x <= horizontalRange; ++x) {
                for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                    double hardness;
                    double horizontalDistanceSq = (double)x * (double)x + (double)z * (double)z;
                    if (horizontalDistanceSq > strike.radiusSquared) continue;
                    mutable.m_122178_(center.m_123341_() + x, y, center.m_123343_() + z);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (state.m_60795_()) continue;
                    if (respectClaims && !ClaimGuards.canBreakBlock(level, shooter, (BlockPos)mutable)) {
                        blockedAny = true;
                        blockedPos = mutable.m_7949_();
                        continue;
                    }
                    double maxHardness = (Double)OrbitalConfig.MAX_BREAK_HARDNESS.get();
                    boolean infinite = maxHardness < 0.0;
                    ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                    if (id != null && OrbitalConfig.isBlockBlacklistedNormalized(id.toString())) {
                        if (!((Boolean)OrbitalConfig.DEBUG.get()).booleanValue()) continue;
                        ForgeOrbitalRailgunMod.LOGGER.info("[OrbitalStrike] Skipped blacklisted block: {}", (Object)id);
                        continue;
                    }
                    if (!infinite && (hardness = (double)state.m_60800_((BlockGetter)level, (BlockPos)mutable)) > maxHardness) {
                        if (!((Boolean)OrbitalConfig.DEBUG.get()).booleanValue()) continue;
                        ForgeOrbitalRailgunMod.LOGGER.info("[OrbitalStrike] Skipped block due to hardness: {} ({} > {})", new Object[]{id, hardness, maxHardness});
                        continue;
                    }
                    allowedPositions.add(mutable.m_121878_());
                }
            }
        }
        if (blockedAny) {
            OrbitalRailgunStrikeManager.notifyClaimBlocked(strike, shooter, ClaimBlockType.BLOCKS, blockedPos != null ? blockedPos : center);
        }
        if (!allowedPositions.isEmpty()) {
            double radius = Math.sqrt(strike.radiusSquared);
            double diameter = radius * 2.0;
            StrikeExecutor.begin(level, center, diameter);
            StrikeExecutor.filterAllowed((LongSet)allowedPositions);
        }
    }

    private static boolean areClaimsEnforced() {
        boolean ftb = ClaimCompat.hasFTB() && (Boolean)OrbitalConfig.RESPECT_CLAIMS.get() != false;
        boolean opac = ClaimCompat.hasOPAC() && (Boolean)OrbitalConfig.RESPECT_OPAC_CLAIMS.get() != false;
        return ftb || opac;
    }

    private static ServerPlayer resolveShooter(ServerLevel level, ActiveStrike strike) {
        if (strike.shooter == null) {
            return null;
        }
        return level.m_7654_().m_6846_().m_11259_(strike.shooter);
    }

    private static void notifyClaimBlocked(ActiveStrike strike, ServerPlayer shooter, ClaimBlockType type, BlockPos pos) {
        if (strike.markNotified(type) && shooter != null) {
            shooter.m_5661_(CLAIM_BLOCKED_MESSAGE, true);
        }
        if (((Boolean)OrbitalConfig.DEBUG.get()).booleanValue()) {
            ForgeOrbitalRailgunMod.LOGGER.info("[OrbitalStrike] Claim protection blocked {} at {}", (Object)type.name().toLowerCase(), (Object)pos);
        }
    }

    public record StrikeRequestResult(boolean success, @Nullable Component message) {
        public static StrikeRequestResult ok() {
            return new StrikeRequestResult(true, null);
        }

        public static StrikeRequestResult failure(Component message) {
            return new StrikeRequestResult(false, message);
        }
    }

    private record StrikeKey(ResourceKey<Level> dimension, BlockPos pos) {
    }

    private static final class ActiveStrike {
        private final StrikeKey key;
        private final List<Entity> entities;
        private final int startTick;
        private final UUID shooter;
        private final double radiusSquared;
        private final int horizontalRange;
        private final float damageMultiplier;
        private boolean blockNotified;
        private boolean explosionNotified;
        private boolean damageNotified;

        private ActiveStrike(StrikeKey key, List<Entity> entities, int startTick, UUID shooter, double radius, float damageMultiplier) {
            this.key = key;
            this.entities = entities;
            this.startTick = startTick;
            this.shooter = shooter;
            this.radiusSquared = radius * radius;
            this.horizontalRange = Math.max(0, Mth.m_14165_((double)radius));
            this.damageMultiplier = damageMultiplier;
        }

        private boolean markNotified(ClaimBlockType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ClaimBlockType.BLOCKS -> {
                    if (this.blockNotified) {
                        yield false;
                    }
                    this.blockNotified = true;
                    yield true;
                }
                case ClaimBlockType.EXPLOSION -> {
                    if (this.explosionNotified) {
                        yield false;
                    }
                    this.explosionNotified = true;
                    yield true;
                }
                case ClaimBlockType.DAMAGE -> {
                    if (this.damageNotified) {
                        yield false;
                    }
                    this.damageNotified = true;
                    yield true;
                }
            };
        }
    }

    private static enum ClaimBlockType {
        BLOCKS,
        EXPLOSION,
        DAMAGE;

    }
}

