/*
 * Decompiled with CFR 0.152.
 */
package urushi.Block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import urushi.ModCore_Urushi;

public class JapaneseTimberBamboo
extends Block
implements IPlantable,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    protected static final AxisAlignedBB Bamboo_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public JapaneseTimberBamboo() {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149752_b(10.0f);
        this.func_149713_g(0);
        this.func_149715_a(0.0f);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Bamboo_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModCore_Urushi.JapaneseTimberBamboo || this.checkForDrop(worldIn, pos, state)) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < ModCore_Urushi.max_height_Bamboo) {
                int j = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                    if (j > 0) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150354_m;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return this.func_176196_c(worldIn, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Bamboo_AABB;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModCore_Urushi.UItems;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModCore_Urushi.UItems);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Beach;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        for (int i = 0; i < 11; ++i) {
            if ((worldIn.func_180495_p(pos.func_177982_a(0, -1 - i, 1)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(0, -1 - i, 1)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(0, -i, 1)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(0, -i, 1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(0, -1 - i, -1)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(0, -1 - i, -1)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(0, -i, -1)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(0, -i, -1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, 0)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, 0)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(1, -i, 0)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(1, -i, 0), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, 0)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, 0)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(-1, -i, 0)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(-1, -i, 0), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, 1)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, 1)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(1, -i, 1)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(1, -i, 1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, -1)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(1, -1 - i, -1)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(1, -i, -1)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(1, -i, -1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if ((worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, 1)).func_177230_c() instanceof BlockGrass || worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, 1)).func_177230_c() instanceof BlockDirt) && worldIn.func_180495_p(pos.func_177982_a(-1, -i, 1)).func_177230_c() instanceof BlockAir && rand.nextInt(3) == 1) {
                worldIn.func_175656_a(pos.func_177982_a(-1, -i, 1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
            }
            if (!(worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, -1)).func_177230_c() instanceof BlockGrass) && !(worldIn.func_180495_p(pos.func_177982_a(-1, -1 - i, -1)).func_177230_c() instanceof BlockDirt) || !(worldIn.func_180495_p(pos.func_177982_a(-1, -i, -1)).func_177230_c() instanceof BlockAir) || rand.nextInt(3) != 1) continue;
            worldIn.func_175656_a(pos.func_177982_a(-1, -i, -1), ModCore_Urushi.JapaneseTimberBambooShoot.func_176223_P());
        }
    }
}

