/*
 * Decompiled with CFR 0.152.
 */
package urushi.Block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import urushi.ModCore_Urushi;

public class SlideDoorBase
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumTypeSlideDoorOpen> OPENCLOSE = PropertyEnum.func_177709_a((String)"openclose", EnumTypeSlideDoorOpen.class);
    public static final PropertyEnum<EnumTypeSlideDoorUnderUpper> UNDERUPPER = PropertyEnum.func_177709_a((String)"underupper", EnumTypeSlideDoorUnderUpper.class);
    protected static final AxisAlignedBB AABB_CLOSED_NORTH = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_CLOSED_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 0.5625);
    protected static final AxisAlignedBB AABB_CLOSED_WEST = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_CLOSED_EAST = new AxisAlignedBB(0.5625, 0.0, 0.0, 0.5625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OPEN_NORTH = new AxisAlignedBB(0.8125, 0.0, 0.4375, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OPEN_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 0.1875, 1.0, 0.5625);
    protected static final AxisAlignedBB AABB_OPEN_WEST = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5, 1.0, 0.1875);
    protected static final AxisAlignedBB AABB_OPEN_EAST = new AxisAlignedBB(0.5, 0.0, 0.8125, 0.5625, 1.0, 1.0);
    int meta;
    BlockRenderLayer renderLayer;

    public SlideDoorBase(int i, BlockRenderLayer j) {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UNDER)));
        this.func_149752_b(10.0f);
        this.func_149713_g(0);
        this.func_149715_a(0.0f);
        this.func_149711_c(0.3f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.meta = i;
        this.renderLayer = j;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumTypeSlideDoorUnderUpper underUpper = (EnumTypeSlideDoorUnderUpper)((Object)state.func_177229_b(UNDERUPPER));
        if (state.func_177229_b(UNDERUPPER) == EnumTypeSlideDoorUnderUpper.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate1.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos1);
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                BlockPos pos1 = state.func_177229_b(UNDERUPPER) == EnumTypeSlideDoorUnderUpper.UNDER ? pos.func_177984_a() : pos.func_177977_b();
                EnumTypeSlideDoorUnderUpper underUpper2 = (EnumTypeSlideDoorUnderUpper)((Object)worldIn.func_180495_p(pos1).func_177229_b(UNDERUPPER));
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos1);
                if (flag) {
                    if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.CLOSE) {
                        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper)));
                        worldIn.func_175656_a(pos1, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper2)));
                        worldIn.func_180498_a(null, 1007, pos, 0);
                    }
                } else if ((blockIn.func_176223_P().func_185897_m() || worldIn.func_180495_p(blockpos1).func_177230_c().func_176223_P().func_185897_m()) && state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN) {
                    worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper)));
                    worldIn.func_175656_a(pos1, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper2)));
                    worldIn.func_180498_a(null, 1013, pos, 0);
                }
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(UNDERUPPER) == EnumTypeSlideDoorUnderUpper.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(UNDERUPPER) == EnumTypeSlideDoorUnderUpper.UNDER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return (state.func_185896_q() || state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumTypeSlideDoorOpen openclose = (EnumTypeSlideDoorOpen)((Object)state.func_177229_b(OPENCLOSE));
        switch (enumfacing) {
            default: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_EAST : AABB_CLOSED_EAST;
            }
            case SOUTH: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_SOUTH : AABB_CLOSED_SOUTH;
            }
            case WEST: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_WEST : AABB_CLOSED_WEST;
            }
            case NORTH: 
        }
        return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_NORTH : AABB_CLOSED_NORTH;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN) {
            SlideDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185506_k);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            SlideDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_NORTH);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            SlideDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_SOUTH);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            SlideDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_WEST);
        } else {
            SlideDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_EAST);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModCore_Urushi.UItems, 1, this.meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.meta;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(UNDERUPPER) == EnumTypeSlideDoorUnderUpper.UPPER ? Items.field_190931_a : ModCore_Urushi.UItems;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 4) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UNDER));
        }
        if (meta < 8) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UNDER));
        }
        if (meta < 12) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UPPER));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UPPER));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + 4 * ((EnumTypeSlideDoorOpen)((Object)state.func_177229_b(OPENCLOSE))).getMetadata() + 8 * ((EnumTypeSlideDoorUnderUpper)((Object)state.func_177229_b(UNDERUPPER))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPENCLOSE, UNDERUPPER});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumTypeSlideDoorUnderUpper underUpper = (EnumTypeSlideDoorUnderUpper)((Object)state.func_177229_b(UNDERUPPER));
        if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.CLOSE) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper)));
            worldIn.func_180498_a(playerIn, 1007, pos, 0);
            if (underUpper == EnumTypeSlideDoorUnderUpper.UPPER) {
                worldIn.func_175656_a(pos.func_177982_a(0, -1, 0), this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UNDER)));
            } else {
                worldIn.func_175656_a(pos.func_177982_a(0, 1, 0), this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UPPER)));
            }
            return true;
        }
        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)underUpper)));
        worldIn.func_180498_a(playerIn, 1013, pos, 0);
        if (underUpper == EnumTypeSlideDoorUnderUpper.UPPER) {
            worldIn.func_175656_a(pos.func_177982_a(0, -1, 0), this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UNDER)));
        } else {
            worldIn.func_175656_a(pos.func_177982_a(0, 1, 0), this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)).func_177226_a(UNDERUPPER, (Comparable)((Object)EnumTypeSlideDoorUnderUpper.UPPER)));
        }
        return true;
    }

    public static enum EnumTypeSlideDoorUnderUpper implements IStringSerializable
    {
        UNDER(0, "under", MapColor.field_151660_b),
        UPPER(1, "upper", MapColor.field_151660_b);

        private static final EnumTypeSlideDoorUnderUpper[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor mapColor;

        private EnumTypeSlideDoorUnderUpper(int metaIn, String nameIn, MapColor mapColorIn) {
            this(metaIn, nameIn, nameIn, mapColorIn);
        }

        private EnumTypeSlideDoorUnderUpper(int metaIn, String nameIn, String unlocalizedNameIn, MapColor mapColorIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
            this.mapColor = mapColorIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumTypeSlideDoorUnderUpper byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumTypeSlideDoorUnderUpper[EnumTypeSlideDoorUnderUpper.values().length];
            EnumTypeSlideDoorUnderUpper[] enumTypeSlideDoorUnderUpperArray = EnumTypeSlideDoorUnderUpper.values();
            int n = enumTypeSlideDoorUnderUpperArray.length;
            for (int i = 0; i < n; ++i) {
                EnumTypeSlideDoorUnderUpper $enumtype;
                EnumTypeSlideDoorUnderUpper.META_LOOKUP[$enumtype.getMetadata()] = $enumtype = enumTypeSlideDoorUnderUpperArray[i];
            }
        }
    }

    public static enum EnumTypeSlideDoorOpen implements IStringSerializable
    {
        CLOSE(0, "close", MapColor.field_151660_b),
        OPEN(1, "open", MapColor.field_151660_b);

        private static final EnumTypeSlideDoorOpen[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor mapColor;

        private EnumTypeSlideDoorOpen(int metaIn, String nameIn, MapColor mapColorIn) {
            this(metaIn, nameIn, nameIn, mapColorIn);
        }

        private EnumTypeSlideDoorOpen(int metaIn, String nameIn, String unlocalizedNameIn, MapColor mapColorIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
            this.mapColor = mapColorIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumTypeSlideDoorOpen byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumTypeSlideDoorOpen[EnumTypeSlideDoorOpen.values().length];
            EnumTypeSlideDoorOpen[] enumTypeSlideDoorOpenArray = EnumTypeSlideDoorOpen.values();
            int n = enumTypeSlideDoorOpenArray.length;
            for (int i = 0; i < n; ++i) {
                EnumTypeSlideDoorOpen $enumtype;
                EnumTypeSlideDoorOpen.META_LOOKUP[$enumtype.getMetadata()] = $enumtype = enumTypeSlideDoorOpenArray[i];
            }
        }
    }
}

