/*
 * Decompiled with CFR 0.152.
 */
package urushi.Block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import urushi.ModCore_Urushi;

public class SlideMonoDoorBase
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumTypeSlideDoorOpen> OPENCLOSE = PropertyEnum.func_177709_a((String)"openclose", EnumTypeSlideDoorOpen.class);
    protected static final AxisAlignedBB AABB_CLOSED_NORTH = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_CLOSED_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 0.5625);
    protected static final AxisAlignedBB AABB_CLOSED_WEST = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_CLOSED_EAST = new AxisAlignedBB(0.5625, 0.0, 0.0, 0.5625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OPEN_NORTH = new AxisAlignedBB(0.8125, 0.0, 0.4375, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OPEN_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 0.1875, 1.0, 0.5625);
    protected static final AxisAlignedBB AABB_OPEN_WEST = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5, 1.0, 0.1875);
    protected static final AxisAlignedBB AABB_OPEN_EAST = new AxisAlignedBB(0.5, 0.0, 0.8125, 0.5625, 1.0, 1.0);
    BlockRenderLayer renderLayer;

    public SlideMonoDoorBase(BlockRenderLayer j) {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)));
        this.func_149752_b(10.0f);
        this.func_149713_g(0);
        this.func_149715_a(0.0f);
        this.func_149711_c(0.3f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(ModCore_Urushi.TabUrushi);
        this.renderLayer = j;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (!placer.func_70093_af()) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumTypeSlideDoorOpen openclose = (EnumTypeSlideDoorOpen)((Object)state.func_177229_b(OPENCLOSE));
        switch (enumfacing) {
            default: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_EAST : AABB_CLOSED_EAST;
            }
            case SOUTH: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_SOUTH : AABB_CLOSED_SOUTH;
            }
            case WEST: {
                return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_WEST : AABB_CLOSED_WEST;
            }
            case NORTH: 
        }
        return openclose == EnumTypeSlideDoorOpen.OPEN ? AABB_OPEN_NORTH : AABB_CLOSED_NORTH;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN) {
            SlideMonoDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185506_k);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            SlideMonoDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_NORTH);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            SlideMonoDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_SOUTH);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            SlideMonoDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_WEST);
        } else {
            SlideMonoDoorBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CLOSED_EAST);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 4) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + 4 * ((EnumTypeSlideDoorOpen)((Object)state.func_177229_b(OPENCLOSE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPENCLOSE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.CLOSE) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)));
            worldIn.func_180498_a(playerIn, 1007, pos, 0);
            return true;
        }
        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)blockFacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)));
        worldIn.func_180498_a(playerIn, 1013, pos, 0);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean flag = worldIn.func_175640_z(pos);
        if (flag) {
            if (state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.CLOSE) {
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.OPEN)));
                worldIn.func_180498_a(null, 1007, pos, 0);
            }
        } else if (blockIn.func_176223_P().func_185897_m() && state.func_177229_b(OPENCLOSE) == EnumTypeSlideDoorOpen.OPEN) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(OPENCLOSE, (Comparable)((Object)EnumTypeSlideDoorOpen.CLOSE)));
            worldIn.func_180498_a(null, 1013, pos, 0);
        }
    }

    public static enum EnumTypeSlideDoorOpen implements IStringSerializable
    {
        CLOSE(0, "close", MapColor.field_151660_b),
        OPEN(1, "open", MapColor.field_151660_b);

        private static final EnumTypeSlideDoorOpen[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor mapColor;

        private EnumTypeSlideDoorOpen(int metaIn, String nameIn, MapColor mapColorIn) {
            this(metaIn, nameIn, nameIn, mapColorIn);
        }

        private EnumTypeSlideDoorOpen(int metaIn, String nameIn, String unlocalizedNameIn, MapColor mapColorIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
            this.mapColor = mapColorIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumTypeSlideDoorOpen byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumTypeSlideDoorOpen[EnumTypeSlideDoorOpen.values().length];
            EnumTypeSlideDoorOpen[] enumTypeSlideDoorOpenArray = EnumTypeSlideDoorOpen.values();
            int n = enumTypeSlideDoorOpenArray.length;
            for (int i = 0; i < n; ++i) {
                EnumTypeSlideDoorOpen $enumtype;
                EnumTypeSlideDoorOpen.META_LOOKUP[$enumtype.getMetadata()] = $enumtype = enumTypeSlideDoorOpenArray[i];
            }
        }
    }
}

