/*
 * Decompiled with CFR 0.152.
 */
package urushi.Block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import urushi.Block.U_Planks;
import urushi.Else.EnumType;
import urushi.ModCore_Urushi;

public class WoodenBucket
extends Block {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 0.9375, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 0.9375, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 0.9375, 1.0);
    public static final PropertyEnum<EnumType.EnumType16> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.EnumType16.class);

    public WoodenBucket() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.EnumType16.TypeA)));
        this.func_149647_a(ModCore_Urushi.TabUrushi);
        this.func_149752_b(10.0f);
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149783_u = true;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType.EnumType16)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType.EnumType16)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public IProperty<?> getVariantProperty() {
        return VARIANT;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.EnumType16.byMetadata(meta)));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType.EnumType16)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        WoodenBucket.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        WoodenBucket.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        WoodenBucket.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        WoodenBucket.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        WoodenBucket.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int blockMeta = ((EnumType.EnumType16)((Object)state.func_177229_b(VARIANT))).getMetadata();
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * blockMeta)) / 16.0f;
        if (!worldIn.field_72995_K && entityIn instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entityIn;
            Item item = entityItem.func_92059_d().func_77973_b();
            ItemStack itemStack = entityItem.func_92059_d();
            double vel = 0.4;
            int itemMeta = entityItem.func_92059_d().func_77952_i();
            int amountItem = entityItem.func_92059_d().func_190916_E();
            if (item == Items.field_151100_aR) {
                if (itemMeta == 0 && this.isRawUrushi(blockMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta + 6);
                    ((EntityItem)entityIn).func_92058_a(new ItemStack(item, amountItem - 1, itemMeta));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (itemMeta == 1 && this.isRawUrushi(blockMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta + 3);
                    ((EntityItem)entityIn).func_92058_a(new ItemStack(item, amountItem - 1, itemMeta));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else if (Block.func_149634_a((Item)item) instanceof BlockPlanks && this.isRedUrushi(blockMeta)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 6));
                entityItem.field_70181_x = vel;
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (Block.func_149634_a((Item)item) instanceof BlockPlanks && this.isBlackUrushi(blockMeta)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 8));
                entityItem.field_70181_x = vel;
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (Block.func_149634_a((Item)item) == ModCore_Urushi.UPlanks) {
                U_Planks uplanks = (U_Planks)Block.func_149634_a((Item)item);
                if (this.isRedUrushi(blockMeta) && uplanks.canStainRedPlanks(itemMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                    entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 6));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (this.isBlackUrushi(blockMeta) && uplanks.canStainBlackPlanks(itemMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                    entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 8));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (this.isRedUrushi(blockMeta) && uplanks.canStainRedSmoothPlanks(itemMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                    entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 7));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (this.isBlackUrushi(blockMeta) && uplanks.canStainBlackSmoothPlanks(itemMeta)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                    entityItem.func_92058_a(new ItemStack(ModCore_Urushi.UPlanks, amountItem, 9));
                    entityItem.field_70181_x = vel;
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else if (item == Items.field_151015_O & this.isRawUrushi(blockMeta)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta - 1);
                ((EntityItem)entityIn).func_92058_a(new ItemStack(ModCore_Urushi.UItems, amountItem, 8));
                entityItem.field_70181_x = vel;
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (this.isWater(blockMeta) && item == Item.func_150898_a((Block)Blocks.field_192444_dS)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
                entityItem.func_92058_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_192443_dR), amountItem, itemStack.func_77952_i()));
                entityItem.field_70181_x = vel;
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (this.isWater(blockMeta) && item == Item.func_150898_a((Block)Blocks.field_150346_d)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
                entityItem.func_92058_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150435_aG), amountItem, 0));
                entityItem.field_70181_x = vel;
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else if (!worldIn.field_72995_K && entityIn.func_70027_ad() && entityIn.func_174813_aQ().field_72338_b <= (double)f && this.isWater(blockMeta)) {
            entityIn.func_70066_B();
            this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        int blockMeta = ((EnumType.EnumType16)((Object)state.func_177229_b(VARIANT))).getMetadata();
        int amountItem = itemstack.func_190916_E();
        int itemMeta = itemstack.func_77952_i();
        if (item == Items.field_151100_aR && this.isRawUrushi(blockMeta)) {
            if (itemMeta == 1) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta + 3);
                itemstack.func_190918_g(1);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (itemMeta == 0) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta + 6);
                itemstack.func_190918_g(1);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (this.isRedUrushi(blockMeta)) {
            if (Block.func_149634_a((Item)item) instanceof BlockPlanks) {
                playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 6));
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (Block.func_149634_a((Item)item) == ModCore_Urushi.UPlanks) {
                U_Planks uPlanks = (U_Planks)Block.func_149634_a((Item)item);
                if (uPlanks.canStainRedPlanks(itemMeta)) {
                    playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 6));
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (uPlanks.canStainRedSmoothPlanks(itemMeta)) {
                    playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 7));
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 4 ? 0 : blockMeta - 1);
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        } else if (this.isBlackUrushi(blockMeta)) {
            if (Block.func_149634_a((Item)item) instanceof BlockPlanks) {
                playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 8));
                this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (Block.func_149634_a((Item)item) == ModCore_Urushi.UPlanks) {
                U_Planks uPlanks = (U_Planks)Block.func_149634_a((Item)item);
                if (uPlanks.canStainBlackPlanks(itemMeta)) {
                    playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 8));
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (uPlanks.canStainBlackSmoothPlanks(itemMeta)) {
                    playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UPlanks, amountItem, 9));
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 7 ? 0 : blockMeta - 1);
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        } else {
            if (item == Items.field_151015_O && this.isRawUrushi(blockMeta)) {
                this.setUrushiLevel(worldIn, pos, state, blockMeta - 1);
                playerIn.func_184611_a(hand, new ItemStack(ModCore_Urushi.UItems, amountItem, 8));
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (this.isWater(blockMeta)) {
                if (item == Items.field_151069_bo) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
                    double vel = 0.4;
                    itemstack.func_190918_g(1);
                    if (!worldIn.field_72995_K) {
                        EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        ItemStack itemstackP = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                        entityItem.func_92058_a(itemstackP);
                        entityItem.field_70181_x = vel;
                        worldIn.func_72838_d((Entity)entityItem);
                    }
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (item == Items.field_151133_ar) {
                    this.setUrushiLevel(worldIn, pos, state, 0);
                    itemstack.func_190918_g(1);
                    double vel = 0.4;
                    if (!worldIn.field_72995_K) {
                        EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        ItemStack itemstackP = new ItemStack(Items.field_151131_as);
                        entityItem.func_92058_a(itemstackP);
                        entityItem.field_70181_x = vel;
                        worldIn.func_72838_d((Entity)entityItem);
                    }
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (item == Items.field_151068_bn && blockMeta != 12) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta + 1);
                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151069_bo, 1, 0));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (item == Item.func_150898_a((Block)Blocks.field_192444_dS)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
                    playerIn.func_184611_a(hand, new ItemStack(Blocks.field_192443_dR, amountItem, itemstack.func_77952_i()));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (item == Item.func_150898_a((Block)Blocks.field_150346_d)) {
                    this.setUrushiLevel(worldIn, pos, state, blockMeta == 10 ? 0 : blockMeta - 1);
                    playerIn.func_184611_a(hand, new ItemStack(Blocks.field_150435_aG, amountItem, 0));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else {
                if (this.isEmpty(blockMeta) && item == Items.field_151131_as) {
                    this.setUrushiLevel(worldIn, pos, state, 12);
                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar, 1, 0));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (this.isEmpty(blockMeta) && item == Items.field_151068_bn) {
                    this.setUrushiLevel(worldIn, pos, state, 10);
                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151069_bo, 1, 0));
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    public void setUrushiLevel(World worldIn, BlockPos pos, IBlockState state, int level) {
        worldIn.func_175656_a(pos, state.func_177230_c().func_176203_a(level));
        worldIn.func_175666_e(pos, (Block)this);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((EnumType.EnumType16)((Object)blockState.func_177229_b(VARIANT))).getMetadata();
    }

    public boolean isEmpty(int meta) {
        return meta == 0;
    }

    public boolean isRawUrushi(int meta) {
        return meta == 1 || meta == 2 || meta == 3;
    }

    public boolean isRedUrushi(int meta) {
        return meta == 4 || meta == 5 || meta == 6;
    }

    public boolean isBlackUrushi(int meta) {
        return meta == 7 || meta == 8 || meta == 9;
    }

    public boolean isWater(int meta) {
        return meta == 10 || meta == 11 || meta == 12;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int metadata = stack.func_77952_i();
        TextComponentTranslation textComponentA = new TextComponentTranslation("item.info.woodenbucket1", new Object[0]);
        TextComponentTranslation textComponentB = new TextComponentTranslation("item.info.woodenbucket2", new Object[0]);
        TextComponentTranslation textComponentC = new TextComponentTranslation("item.info.woodenbucket3", new Object[0]);
        TextComponentTranslation textComponentD = new TextComponentTranslation("item.info.woodenbucket4", new Object[0]);
        if (metadata == 0) {
            tooltip.add(textComponentA.func_150254_d());
            tooltip.add(textComponentB.func_150254_d());
            tooltip.add(textComponentC.func_150254_d());
            tooltip.add(textComponentD.func_150254_d());
        }
    }
}

