/*
 * Decompiled with CFR 0.152.
 */
package urushi.WorldGen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import urushi.WorldGen.NormalTerrainGeneratorTEST;

public class ChunkGeneratorTEST
implements IChunkGenerator {
    private final World worldObj;
    private Random random;
    private Biome[] biomesForGeneration;
    private List<Biome.SpawnListEntry> mobs = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityGiantZombie.class, 100, 2, 2)});
    private MapGenBase caveGenerator = new MapGenCaves();
    private NormalTerrainGeneratorTEST terraingen = new NormalTerrainGeneratorTEST();

    public ChunkGeneratorTEST(World worldObj) {
        this.worldObj = worldObj;
        long seed = worldObj.func_72905_C();
        this.random = new Random((seed + 516L) * 314L);
        this.terraingen.setup(worldObj, this.random);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.terraingen.setBiomesForGeneration(this.biomesForGeneration);
        this.terraingen.generate(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.terraingen.replaceBiomeBlocks(x, z, chunkprimer, this, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        biome.func_180624_a(this.worldObj, this.random, blockpos);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.random);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            return this.mobs;
        }
        return ImmutableList.of();
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

