/*
 * Decompiled with CFR 0.152.
 */
package urushi.WorldGen;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.Biome;
import urushi.WorldGen.BiomeProviderKakuriyo;

public class KakuriyoBiomeCache {
    private final Long2ObjectMap<Entry> entryMap = new Long2ObjectOpenHashMap();
    private final List<Entry> entries = new ArrayList<Entry>();
    private final BiomeProviderKakuriyo provider;
    private final int gridSize;
    private final boolean offset;
    private long lastCleanupTime;

    public KakuriyoBiomeCache(BiomeProviderKakuriyo provider, int gridSize, boolean offset) {
        this.provider = provider;
        this.gridSize = gridSize;
        this.offset = offset;
    }

    private Entry getEntry(int x, int z) {
        long key = KakuriyoBiomeCache.getKey(x = this.toGrid(x), z = this.toGrid(z));
        Entry entry = (Entry)this.entryMap.get(key);
        if (entry == null) {
            entry = new Entry(x, z);
            this.entryMap.put(key, (Object)entry);
            this.entries.add(entry);
        }
        entry.lastAccessTime = MinecraftServer.func_130071_aq();
        return entry;
    }

    public Biome[] getBiomes(int x, int z) {
        return this.getEntry((int)x, (int)z).biomes;
    }

    public void cleanup() {
        long currentTime = MinecraftServer.func_130071_aq();
        long timeSinceCleanup = currentTime - this.lastCleanupTime;
        if (timeSinceCleanup > 7500L || timeSinceCleanup < 0L) {
            this.lastCleanupTime = currentTime;
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                long timeSinceAccess = currentTime - entry.lastAccessTime;
                if (timeSinceAccess <= 30000L && timeSinceAccess >= 0L) continue;
                this.entries.remove(i--);
                long key = KakuriyoBiomeCache.getKey(entry.x, entry.z);
                this.entryMap.remove(key);
            }
        }
    }

    public boolean isGridAligned(int x, int z, int width, int height) {
        return width == this.gridSize && height == this.gridSize && this.gridOffset(x) == 0 && this.gridOffset(z) == 0;
    }

    private int gridOffset(int n) {
        return (n + (this.offset ? this.gridSize / 2 : 0)) % this.gridSize;
    }

    private int toGrid(int n) {
        return (n + (this.offset ? this.gridSize / 2 : 0)) / this.gridSize;
    }

    private int fromGrid(int n) {
        return n * this.gridSize - (this.offset ? this.gridSize / 2 : 0);
    }

    private static long getKey(int x, int z) {
        return Integer.toUnsignedLong(x) | Integer.toUnsignedLong(z) << 32;
    }

    private final class Entry {
        final Biome[] biomes;
        final int x;
        final int z;
        long lastAccessTime;

        Entry(int x, int z) {
            this.biomes = new Biome[KakuriyoBiomeCache.this.gridSize * KakuriyoBiomeCache.this.gridSize];
            this.x = x;
            this.z = z;
            KakuriyoBiomeCache.this.provider.getBiomesForGeneration(this.biomes, KakuriyoBiomeCache.this.fromGrid(x), KakuriyoBiomeCache.this.fromGrid(z), KakuriyoBiomeCache.this.gridSize, KakuriyoBiomeCache.this.gridSize, false);
        }
    }
}

