/*
 * Decompiled with CFR 0.152.
 */
package urushi.WorldGen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import urushi.Block.U_Stone;
import urushi.ModCore_Urushi;
import urushi.WorldGen.WorldGenBamboo;
import urushi.WorldGen.WorldGenCypressTrees;
import urushi.WorldGen.WorldGenIndigo;
import urushi.WorldGen.WorldGenJapaneseApricotTrees;
import urushi.WorldGen.WorldGenLacquerTrees;
import urushi.WorldGen.WorldGenLycoris;
import urushi.WorldGen.WorldGenSakuraTrees;
import urushi.WorldGen.WorldGenTeleportShrine;

public class OreGen
implements IWorldGenerator {
    private final WorldGenerator genSakuraTrees = new WorldGenSakuraTrees(false);
    private final WorldGenerator genUmeTrees = new WorldGenJapaneseApricotTrees(false);
    private final WorldGenerator genLacquerTrees = new WorldGenLacquerTrees(false);
    private final WorldGenerator genBamboo = new WorldGenBamboo();
    private final WorldGenerator genCypressTrees = new WorldGenCypressTrees(false);
    private final WorldGenerator genLycoris = new WorldGenLycoris();
    private final WorldGenerator genIndigo = new WorldGenIndigo();
    private final WorldGenerator genGateShrine = new WorldGenTeleportShrine();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ModCore_Urushi.wheather_ganerate_CopperOre) {
            this.runGenCopper(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        if (ModCore_Urushi.wheather_ganerate_Sakura) {
            this.generate(this.genSakuraTrees, world, random, chunkX, chunkZ, 8.0, 0, 240, 4);
        }
        if (ModCore_Urushi.wheather_ganerate_Ume) {
            this.generate(this.genUmeTrees, world, random, chunkX, chunkZ, 8.0, 0, 240, 4);
        }
        if (ModCore_Urushi.wheather_ganerate_Urushi) {
            this.generate(this.genLacquerTrees, world, random, chunkX, chunkZ, 8.0, 0, 240, 4);
        }
        if (ModCore_Urushi.wheather_ganerate_Bamboo) {
            this.generate(this.genBamboo, world, random, chunkX, chunkZ, 2.0, 0, 240, 18);
        }
        if (ModCore_Urushi.wheather_ganerate_Cypress) {
            this.generate(this.genCypressTrees, world, random, chunkX, chunkZ, 8.0, 0, 240, 3);
        }
        this.generateInKakuriyo(this.genLycoris, world, random, chunkX, chunkZ, 40.0, 0, 240);
        this.generateInKakuriyo(this.genIndigo, world, random, chunkX, chunkZ, 20.0, 0, 240);
        if (ModCore_Urushi.wheather_ganerate_Gate) {
            this.generate(this.genGateShrine, world, random, chunkX, chunkZ, 1.0, 64, 110, 18);
        }
    }

    private void runGenCopper(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateCopperOre(ModCore_Urushi.UStone.func_176223_P().func_177226_a(U_Stone.VARIANT, (Comparable)((Object)U_Stone.EnumType.CopperOre)), world, random, chunkX * 16, chunkZ * 16, 0, 80, random.nextInt(7) + 10, 20);
    }

    private void generateCopperOre(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances) {
        int diff = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(diff), z + random.nextInt(16));
            WorldGenMinable generatorGenMinable = new WorldGenMinable(ore, size, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            generatorGenMinable.func_180709_b(world, random, pos);
        }
    }

    private void generate(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, double chancesToSpawn, int minY, int maxY, int ID) {
        if (chancesToSpawn < 1.0) {
            chancesToSpawn = random.nextDouble() < chancesToSpawn ? 1.0 : 0.0;
        }
        int hightDiff = maxY - minY + 1;
        int i = 0;
        while ((double)i < chancesToSpawn) {
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + random.nextInt(15), minY + random.nextInt(hightDiff), chunkZ * 16 + 10 + random.nextInt(15));
            if (minY < 0) {
                pos = world.func_175645_m(pos);
            }
            if (world.field_73011_w.getBiomeForCoords(pos) == Biome.func_185357_a((int)ID)) {
                generator.func_180709_b(world, random, pos);
            }
            ++i;
        }
    }

    private void generateInKakuriyo(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, double chancesToSpawn, int minY, int maxY) {
        if (chancesToSpawn < 1.0) {
            chancesToSpawn = random.nextDouble() < chancesToSpawn ? 1.0 : 0.0;
        }
        int hightDiff = maxY - minY + 1;
        int i = 0;
        while ((double)i < chancesToSpawn) {
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + random.nextInt(15), minY + random.nextInt(hightDiff), chunkZ * 16 + 10 + random.nextInt(15));
            if (minY < 0) {
                pos = world.func_175645_m(pos);
            }
            if (world.field_73011_w.getDimension() == ModCore_Urushi.KakuriyoDimensionID) {
                generator.func_180709_b(world, random, pos);
            }
            ++i;
        }
    }
}

