/*
 * Decompiled with CFR 0.152.
 */
package urushi.WorldGen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;
import net.minecraftforge.common.IPlantable;
import urushi.Block.U_Leaves;
import urushi.Block.U_Log;
import urushi.ModCore_Urushi;

public class WorldGenMegaCypressTree
extends WorldGenHugeTrees {
    private static final IBlockState TRUNK = ModCore_Urushi.ULog.func_176223_P().func_177226_a(U_Log.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState LEAF = ModCore_Urushi.ULeaves2.func_176223_P().func_177226_a(U_Leaves.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState PODZOL = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
    private final boolean useBaseHeight;

    public WorldGenMegaCypressTree(boolean notify, boolean p_i45457_2_) {
        super(notify, 13, 15, TRUNK, LEAF);
        this.useBaseHeight = p_i45457_2_;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = this.func_150533_a(rand);
        if (!this.func_175929_a(worldIn, rand, position, i)) {
            return false;
        }
        this.createCrown(worldIn, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + i, 0, rand);
        for (int j = 0; j < i; ++j) {
            if (this.isAirLeaves(worldIn, position.func_177981_b(j))) {
                this.func_175903_a(worldIn, position.func_177981_b(j), this.field_76520_b);
            }
            if (j >= i - 1) continue;
            if (this.isAirLeaves(worldIn, position.func_177982_a(1, j, 0))) {
                this.func_175903_a(worldIn, position.func_177982_a(1, j, 0), this.field_76520_b);
            }
            if (this.isAirLeaves(worldIn, position.func_177982_a(1, j, 1))) {
                this.func_175903_a(worldIn, position.func_177982_a(1, j, 1), this.field_76520_b);
            }
            if (!this.isAirLeaves(worldIn, position.func_177982_a(0, j, 1))) continue;
            this.func_175903_a(worldIn, position.func_177982_a(0, j, 1), this.field_76520_b);
        }
        return true;
    }

    private void createCrown(World worldIn, int x, int z, int y, int p_150541_5_, Random rand) {
        int i = rand.nextInt(5) + (this.useBaseHeight ? this.field_76522_a : 3);
        int j = 0;
        for (int k = y - i; k <= y; ++k) {
            int l = y - k;
            int i1 = p_150541_5_ + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.func_175925_a(worldIn, new BlockPos(x, k, z), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0));
            j = i1;
        }
    }

    public void func_180711_a(World worldIn, Random random, BlockPos pos) {
        this.placePodzolCircle(worldIn, pos.func_177976_e().func_177978_c());
        this.placePodzolCircle(worldIn, pos.func_177965_g(2).func_177978_c());
        this.placePodzolCircle(worldIn, pos.func_177976_e().func_177970_e(2));
        this.placePodzolCircle(worldIn, pos.func_177965_g(2).func_177970_e(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.placePodzolCircle(worldIn, pos.func_177982_a(-3 + k, 0, -3 + l));
        }
    }

    private void placePodzolCircle(World worldIn, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePodzolAt(worldIn, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void placePodzolAt(World worldIn, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block.canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) {
                this.func_175903_a(worldIn, blockpos, PODZOL);
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && i < 0) break;
        }
    }

    private boolean isAirLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

