/*
 * Decompiled with CFR 0.152.
 */
package zombiemode;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import zombiemode.AbstractZombieRenderer;
import zombiemode.HandModel;
import zombiemode.HandRenderer;
import zombiemode.ZombieData;
import zombiemode.ZombieModeMod;
import zombiemode.ZombieUtils;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent
    public static void entityJoin(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        ZombieModeMod.queueServerWork(1, () -> Events.modifyGoals(entity));
    }

    public static void modifyGoals(Entity entity) {
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            Set wrapped = zombie.f_21346_.m_148105_();
            zombie.f_21346_.m_25363_(wrapped.toArray(new WrappedGoal[wrapped.size()])[1].m_26015_());
            zombie.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Player.class, true, player -> !ZombieUtils.isZombie(player)));
        } else if (entity instanceof AbstractGolem) {
            AbstractGolem golem = (AbstractGolem)entity;
            golem.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)golem, Player.class, true, player -> ZombieUtils.isZombie(player)));
        }
    }

    @SubscribeEvent
    public static void playerRender(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        ZombieData data = ZombieUtils.getData(player);
        if (!data.isZombie()) {
            return;
        }
        MultiBufferSource buffer = event.getMultiBufferSource();
        int packedLight = event.getPackedLight();
        float partialTick = event.getPartialTick();
        PoseStack pose = event.getPoseStack();
        event.setCanceled(true);
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        EntityRenderDispatcher entityDispatcher = minecraft.m_91290_();
        BlockRenderDispatcher blockDispatcher = minecraft.m_91289_();
        ItemInHandRenderer itemHandRenderer = new ItemInHandRenderer(minecraft, entityDispatcher, itemRenderer);
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(entityDispatcher, itemRenderer, blockDispatcher, itemHandRenderer, minecraft.m_91098_(), minecraft.m_167973_(), minecraft.f_91062_);
        AbstractZombieRenderer renderer = data.getRenderer(context);
        renderer.m_7392_((LivingEntity)((LocalPlayer)player), 0.0f, partialTick, pose, buffer, packedLight);
    }

    @SubscribeEvent
    public static void armRender(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        ZombieData data = ZombieUtils.getData((Player)player);
        if (!data.isZombie()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        EntityRenderDispatcher entityDispatcher = minecraft.m_91290_();
        BlockRenderDispatcher blockDispatcher = minecraft.m_91289_();
        ItemInHandRenderer itemHandRenderer = new ItemInHandRenderer(minecraft, entityDispatcher, itemRenderer);
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(entityDispatcher, itemRenderer, blockDispatcher, itemHandRenderer, minecraft.m_91098_(), minecraft.m_167973_(), minecraft.f_91062_);
        HandRenderer renderer = new HandRenderer(context, new HandModel(context.m_174023_(ModelLayers.f_171223_), false));
        MultiBufferSource buffer = event.getMultiBufferSource();
        int packedLight = event.getPackedLight();
        PoseStack pose = event.getPoseStack();
        renderer.render((AbstractClientPlayer)((LocalPlayer)player), 0.0f, 0.0f, pose, buffer, packedLight);
        event.setCanceled(true);
        if (data.getHand().outerTexture != null) {
            HandRenderer outer = new HandRenderer(context, new HandModel(context.m_174023_(ModelLayers.f_171223_), true));
            outer.render((AbstractClientPlayer)((LocalPlayer)player), 0.0f, 0.0f, pose, buffer, packedLight);
        }
    }

    @SubscribeEvent
    public static void hitbox(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ZombieData data = ZombieUtils.getData(player);
            if (!data.isZombie()) {
                return;
            }
            event.setNewSize(data.getDimensions(), false);
            event.setNewEyeHeight(1.74f);
        }
    }

    @SubscribeEvent
    public static void input(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ZombieData data = ZombieUtils.getData((Player)player);
        if (!data.isZombie()) {
            return;
        }
        Options options = Minecraft.m_91087_().f_91066_;
        KeyMapping crouch = options.f_92090_;
        KeyMapping sprint = options.f_92091_;
        KeyMapping jump = options.f_92089_;
        int key = event.getKey();
        if (key == sprint.getKey().m_84873_() && !data.canSprint()) {
            Events.negateInput(sprint);
        }
        if (key == jump.getKey().m_84873_() && !data.canJump()) {
            Events.negateInput(jump);
        }
        if (key == crouch.getKey().m_84873_() && !data.canCrouch()) {
            Events.negateInput(crouch);
        }
    }

    public static void negateInput(KeyMapping key) {
        ToggleKeyMapping toggleKey;
        if (key instanceof ToggleKeyMapping && (toggleKey = (ToggleKeyMapping)key).m_90857_()) {
            toggleKey.m_7249_(true);
        }
        key.m_7249_(false);
    }

    @SubscribeEvent
    public static void sleep(PlayerSleepInBedEvent event) {
        if (ZombieUtils.isZombie((LivingEntity)event.getEntity())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void entityInteraction(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (ZombieUtils.isZombie((LivingEntity)event.getEntity())) {
            ZombieHorse mount;
            if (target instanceof AbstractVillager || target instanceof Horse && !(target instanceof ZombieHorse)) {
                event.setCanceled(true);
            }
            if (target instanceof ZombieHorse && (mount = (ZombieHorse)target).m_269323_() != event.getEntity()) {
                event.setCanceled(true);
            }
        } else if (target instanceof ZombieHorse) {
            ZombieHorse mount = (ZombieHorse)target;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        ZombieUtils.setup(event.getEntity(), EntityType.f_20532_);
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        ZombieUtils.getData(event.getEntity()).loadAttributes(false);
    }

    @SubscribeEvent
    public static void eatFood(VanillaGameEvent event) {
        Entity entity;
        if (event.getVanillaEvent() == GameEvent.f_157806_ && (entity = event.getCause()) instanceof Player) {
            MobEffectInstance hungerEffect;
            int hungerTime;
            Player player = (Player)entity;
            ZombieData data = ZombieUtils.getData(player);
            if (!data.isZombie()) {
                return;
            }
            if (player.m_21023_(MobEffects.f_19612_) && (hungerTime = (hungerEffect = player.m_21124_(MobEffects.f_19612_)).m_19557_()) == 600) {
                player.m_21195_(MobEffects.f_19612_);
                FoodData food = player.m_36324_();
                food.m_38705_(food.m_38702_() + 4);
                food.m_38717_(food.m_38722_() + 0.7f);
            }
        }
    }

    @SubscribeEvent
    public static void itemInteraction(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ZombieData data = ZombieUtils.getData(player);
        if (!data.isZombie()) {
            return;
        }
        ItemStack stack = player.m_21120_(event.getHand());
        if (!data.isConverting() && player.m_21023_(MobEffects.f_19613_) && stack.m_150930_(Items.f_42436_)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            data.startConverting(player.m_20148_(), player.m_9236_().f_46441_.m_188503_(2401) + 3600);
        } else if (stack.m_41720_().m_41472_() && !stack.getFoodProperties((LivingEntity)player).m_38746_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void killed(LivingDeathEvent event) {
        Player player;
        Level level;
        DamageSource source = event.getSource();
        if (source.m_269014_()) {
            return;
        }
        Entity killer = source.m_7640_();
        if (killer instanceof Player && (level = (player = (Player)killer).m_9236_()) instanceof ServerLevel) {
            Villager villager;
            ServerLevel world = (ServerLevel)level;
            boolean canConvert = world.m_46791_() == Difficulty.NORMAL || world.m_46791_() == Difficulty.HARD;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Villager && ForgeEventFactory.canLivingConvert((LivingEntity)(villager = (Villager)livingEntity), (EntityType)EntityType.f_20530_, timer -> {})) {
                food = player.m_36324_();
                food.m_38705_(food.m_38702_() + 8);
                food.m_38717_(food.m_38722_() + 0.8f);
                if (!canConvert || world.m_46791_() != Difficulty.HARD && world.f_46441_.m_188499_()) {
                    return;
                }
                ZombieVillager zombievillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
                if (zombievillager != null) {
                    zombievillager.m_6518_((ServerLevelAccessor)world, world.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
                    zombievillager.m_34375_(villager.m_7141_());
                    zombievillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                    zombievillager.m_34411_(villager.m_6616_().m_45388_());
                    zombievillager.m_34373_(villager.m_7809_());
                    ForgeEventFactory.onLivingConvert((LivingEntity)villager, (LivingEntity)zombievillager);
                    world.m_5898_((Player)null, 1026, player.m_20183_(), 0);
                }
            } else {
                Horse horse;
                food = event.getEntity();
                if (food instanceof Horse && ForgeEventFactory.canLivingConvert((LivingEntity)(horse = (Horse)food), (EntityType)EntityType.f_20502_, timer -> {})) {
                    food = player.m_36324_();
                    food.m_38705_(food.m_38702_() + 8);
                    food.m_38717_(food.m_38722_() + 0.8f);
                    if (!canConvert || world.m_46791_() != Difficulty.HARD && world.f_46441_.m_188499_()) {
                        return;
                    }
                    ZombieHorse zombiehorse = (ZombieHorse)horse.m_21406_(EntityType.f_20502_, false);
                    if (zombiehorse != null) {
                        AgeableMob.AgeableMobGroupData ageableGroup = horse.m_6162_() ? new AgeableMob.AgeableMobGroupData(100.0f) : new AgeableMob.AgeableMobGroupData(false);
                        zombiehorse.m_6518_((ServerLevelAccessor)world, world.m_6436_(zombiehorse.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)ageableGroup, (CompoundTag)null);
                        ForgeEventFactory.onLivingConvert((LivingEntity)horse, (LivingEntity)zombiehorse);
                        world.m_5898_((Player)null, 1026, player.m_20183_(), 0);
                        zombiehorse.m_30586_(player.m_20148_());
                        zombiehorse.m_30651_(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void hurt(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ZombieData data = ZombieUtils.getData(player);
            if (!data.isZombie()) {
                Events.humanHurt(player, event);
            } else {
                Events.zombieHurt(player, event);
            }
        }
    }

    public static void humanHurt(Player player, LivingAttackEvent event) {
        Entity killer;
        DamageSource source = event.getSource();
        Entity entity = killer = source.m_269014_() ? source.m_7639_() : source.m_7640_();
        if (!(player.m_21223_() - event.getAmount() > 0.0f)) {
            Player attacker;
            ZombieData data;
            if (killer instanceof Zombie) {
                player.m_9236_().m_5898_((Player)null, 1026, player.m_20183_(), 0);
                ZombieUtils.setup(player, killer.m_6095_());
                ZombieUtils.resetAttackers(player);
                event.setCanceled(true);
            } else if (killer instanceof Player && (data = ZombieUtils.getData(attacker = (Player)killer)).isZombie()) {
                FoodData food = attacker.m_36324_();
                food.m_38705_(food.m_38702_() + 8);
                food.m_38717_(food.m_38722_() + 0.8f);
                player.m_9236_().m_5898_((Player)null, 1026, player.m_20183_(), 0);
                ZombieUtils.setup(player, data.type);
                ZombieUtils.resetAttackers(player);
                event.setCanceled(true);
            }
        }
    }

    public static void zombieHurt(Player player, LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source.m_276093_(DamageTypes.f_268722_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"zombie").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"cure").executes(arguments -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)arguments, (String)"player");
            ZombieUtils.setup((Player)player, EntityType.f_20532_);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"infect").executes(arguments -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)arguments, (String)"player");
            ZombieUtils.setup((Player)player, EntityType.f_20501_);
            return 0;
        })).then(Commands.m_82127_((String)"husk").executes(arguments -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)arguments, (String)"player");
            ZombieUtils.setup((Player)player, EntityType.f_20458_);
            return 0;
        }))).then(Commands.m_82127_((String)"drowned").executes(arguments -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)arguments, (String)"player");
            ZombieUtils.setup((Player)player, EntityType.f_20562_);
            return 0;
        })))));
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            if (player.m_9236_().m_5776_()) {
                return;
            }
            ZombieData data = ZombieUtils.getData(player);
            if (!data.isZombie()) {
                return;
            }
            if (player.m_20142_() && !data.canSprint()) {
                player.m_6858_(false);
            }
            if (player.m_6047_() && !data.canCrouch()) {
                player.m_20260_(false);
            }
            if (!player.m_9236_().f_46443_ && player.m_6084_() && data.isConverting()) {
                int i = data.getConversionProgress();
                data.cureConversionTime -= i;
                if (data.cureConversionTime <= 0) {
                    data.finishConversion((ServerLevel)player.m_9236_());
                }
            }
            int maxAir = player.m_6062_();
            player.m_20301_(maxAir);
            if (!player.m_9236_().f_46443_ && player.m_6084_()) {
                if (data.isUnderWaterConverting()) {
                    --data.conversionTime;
                    if (data.conversionTime < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)player, (EntityType)data.drownInto(), timer -> {
                        data.conversionTime = timer;
                    })) {
                        data.doUnderWaterConversion();
                    }
                    player.m_20301_(0);
                } else if (data.convertsInWater()) {
                    if (player.m_204029_(FluidTags.f_13131_)) {
                        ++data.inWaterTime;
                        if (data.inWaterTime >= 600) {
                            data.startUnderWaterConversion(300);
                        }
                        player.m_20301_(300 - data.inWaterTime / 2);
                    } else {
                        data.inWaterTime = -1;
                    }
                }
            }
            if (player.m_6084_()) {
                boolean flag;
                boolean bl = flag = data.isSunSensitive() && data.isSunBurnTick();
                if (flag) {
                    ItemStack itemstack = player.m_6844_(EquipmentSlot.HEAD);
                    if (!itemstack.m_41619_()) {
                        if (itemstack.m_41763_()) {
                            itemstack.m_41721_(itemstack.m_41773_() + data.world.f_46441_.m_188503_(2));
                            if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                                player.m_21166_(EquipmentSlot.HEAD);
                                player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                            }
                        }
                        flag = false;
                    }
                    if (flag) {
                        player.m_20254_(8);
                    }
                }
            }
        }
    }
}

