/*
 * Decompiled with CFR 0.152.
 */
package zombiemode;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import zombiemode.AbstractZombieRenderer;
import zombiemode.AttributeUtils;
import zombiemode.DrownedRenderer;
import zombiemode.HandData;
import zombiemode.HuskRenderer;
import zombiemode.ZombieRenderer;
import zombiemode.ZombieUtils;

public class ZombieData {
    public Player player;
    public Level world;
    public EntityType type = EntityType.f_20532_;
    public boolean isUnderWaterConverting = false;
    public int conversionTime = 0;
    public int inWaterTime = -1;
    @Nullable
    public UUID conversionStarter;
    public boolean isCureConverting = false;
    public int cureConversionTime = 0;

    public ZombieData(@Nullable Player player) {
        this.player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            this.player = player;
        }
        if (this.player != null) {
            this.world = this.player.m_9236_();
            this.sync();
        }
    }

    public void updatePlayer(Player player) {
        if (this.player == null) {
            this.player = player;
        }
        this.world = this.player.m_9236_();
        this.sync();
    }

    public ZombieData(CompoundTag data, Level world) {
        if (world != null) {
            this.world = world;
            if (data.m_128441_("player")) {
                this.player = world.m_46003_(data.m_128342_("player"));
            }
        }
        if (data.m_128441_("isConverting")) {
            this.isUnderWaterConverting = data.m_128471_("isConverting");
        }
        if (data.m_128441_("convertTime")) {
            this.conversionTime = data.m_128451_("convertTime");
        }
        if (data.m_128441_("inWater")) {
            this.inWaterTime = data.m_128451_("inWater");
        }
        if (data.m_128441_("isCureConverting")) {
            this.isCureConverting = data.m_128471_("isCureConverting");
        }
        if (data.m_128441_("cureConvertTime")) {
            this.cureConversionTime = data.m_128451_("cureConvertTime");
        }
        if (data.m_128441_("cureStarter")) {
            this.conversionStarter = data.m_128342_("cureStarter");
        }
        if (data.m_128441_("type")) {
            EntityType.m_20632_((String)data.m_128461_("type")).ifPresent(type -> {
                this.type = type;
            });
        }
        this.sync();
    }

    public CompoundTag saveTag() {
        CompoundTag data = new CompoundTag();
        if (this.player != null) {
            data.m_128362_("player", this.player.m_20148_());
        }
        if (this.conversionStarter != null) {
            data.m_128362_("cureStarter", this.conversionStarter);
        }
        data.m_128359_("type", EntityType.m_20613_((EntityType)this.type).toString());
        data.m_128379_("isConverting", this.isUnderWaterConverting);
        data.m_128405_("convertTime", this.conversionTime);
        data.m_128405_("inWater", this.inWaterTime);
        data.m_128379_("isCureConverting", this.isCureConverting);
        data.m_128405_("cureConvertTime", this.cureConversionTime);
        return data;
    }

    public void sync() {
        ZombieUtils.syncData(this.player, this);
    }

    public boolean isZombie() {
        return this.type != EntityType.f_20532_;
    }

    public void setup(EntityType type) {
        this.type = type == EntityType.f_20530_ ? EntityType.f_20501_ : type;
        this.loadAttributes(true);
        this.sync();
    }

    public void loadAttributes(boolean fullheal) {
        AttributeSupplier attributes = this.getAttributes().m_22265_();
        AttributeUtils.replace((LivingEntity)this.player, attributes);
        if (fullheal) {
            this.player.m_21153_(this.player.m_21233_());
        }
        if (this.isZombie()) {
            double speed = attributes.m_22253_(Attributes.f_22279_);
            AttributeUtils.replace((LivingEntity)this.player, speed / 4.0, Attributes.f_22279_);
        }
    }

    public AttributeSupplier.Builder getAttributes() {
        if (this.isZombie()) {
            return Zombie.m_34328_();
        }
        return Player.m_36340_();
    }

    public AbstractZombieRenderer getRenderer(EntityRendererProvider.Context context) {
        if (this.type == EntityType.f_20562_) {
            return new DrownedRenderer(context);
        }
        if (this.type == EntityType.f_20458_) {
            return new HuskRenderer(context);
        }
        return new ZombieRenderer(context);
    }

    public EntityDimensions getDimensions() {
        return this.type.m_20680_();
    }

    public HandData getHand() {
        HandData hand = new HandData();
        Object texture = "textures/entity/zombie/";
        texture = (String)texture + (this.type == EntityType.f_20501_ ? "zombie.png" : (this.type == EntityType.f_20458_ ? "husk.png" : "drowned.png"));
        hand.texture = new ResourceLocation((String)texture);
        hand.setScale(1.0f, 1.0f, 1.0f);
        hand.setPosition(5.25f, 21.5f, -1.1f);
        hand.setRotation(3.2f, 1.6f, 0.15f);
        if (this.type == EntityType.f_20562_) {
            hand.outerTexture = new ResourceLocation("textures/entity/zombie/drowned_outer_layer.png");
        }
        return hand;
    }

    public boolean isAggressive() {
        return this.player.m_21231_().m_19295_() > 0;
    }

    public boolean isUnderWaterConverting() {
        return this.isUnderWaterConverting;
    }

    public void startUnderWaterConversion(int time) {
        this.conversionTime = time;
        this.isUnderWaterConverting = true;
        this.sync();
    }

    public void doUnderWaterConversion() {
        this.inWaterTime = 0;
        this.conversionTime = 0;
        this.isUnderWaterConverting = false;
        this.convertToZombieType((EntityType<? extends Zombie>)this.drownInto());
        this.world.m_5898_((Player)null, 1040, this.player.m_20183_(), 0);
    }

    public void convertToZombieType(EntityType<? extends Zombie> type) {
        this.type = type;
        this.sync();
    }

    public EntityType drownInto() {
        if (this.type == EntityType.f_20458_) {
            return EntityType.f_20501_;
        }
        return EntityType.f_20562_;
    }

    public boolean canSprint() {
        if (this.player.m_5842_()) {
            return this.type == EntityType.f_20562_;
        }
        return false;
    }

    public boolean canCrouch() {
        return this.player.m_20159_();
    }

    public boolean canJump() {
        if (!this.player.m_5842_()) {
            return true;
        }
        if (this.type == EntityType.f_20562_) {
            return true;
        }
        BlockPos underPlayer = this.player.m_20183_().m_7495_();
        Block block = this.world.m_8055_(underPlayer).m_60734_();
        return !(block instanceof LiquidBlock);
    }

    public boolean convertsInWater() {
        return this.type != EntityType.f_20562_;
    }

    public boolean isSunSensitive() {
        return this.type != EntityType.f_20458_;
    }

    public boolean isSunBurnTick() {
        if (this.world.m_46461_() && !this.world.f_46443_) {
            boolean flag;
            float f = this.player.m_213856_();
            boolean bl = flag = this.player.m_20071_() || this.player.f_146808_ || this.player.f_146809_;
            if (f > 0.5f && this.world.f_46441_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.world.m_45527_(this.player.m_20183_())) {
                return true;
            }
        }
        return false;
    }

    public boolean isConverting() {
        return this.isCureConverting;
    }

    public int getConversionProgress() {
        int i = 1;
        if (this.world.f_46441_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.player.m_20185_() - 4; k < (int)this.player.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.player.m_20186_() - 4; l < (int)this.player.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.player.m_20189_() - 4; i1 < (int)this.player.m_20189_() + 4 && j < 14; ++i1) {
                        BlockState blockstate = this.world.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1));
                        if (!blockstate.m_60713_(Blocks.f_50183_) && !(blockstate.m_60734_() instanceof BedBlock)) continue;
                        if (this.world.f_46441_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public void startConverting(@Nullable UUID uuid, int time) {
        this.conversionStarter = uuid;
        this.cureConversionTime = time;
        this.isCureConverting = true;
        this.player.m_21195_(MobEffects.f_19613_);
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time, Math.min(this.world.m_46791_().m_19028_() - 1, 0)));
        this.world.m_7785_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), SoundEvents.f_12644_, this.player.m_5720_(), 1.0f + this.world.f_46441_.m_188501_(), this.world.f_46441_.m_188501_() * 0.7f + 0.3f, false);
        this.sync();
    }

    public void finishConversion(ServerLevel server) {
        Player player;
        if (this.conversionStarter != null && (player = server.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation("minecraft:story/cure_zombie_villager"));
            serverPlayer.m_8960_().m_135988_(advancement, "cured_zombie_villager");
        }
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        server.m_5898_((Player)null, 1027, this.player.m_20183_(), 0);
        this.type = EntityType.f_20532_;
        this.loadAttributes(false);
        this.sync();
    }
}

