/*
 * Decompiled with CFR 0.152.
 */
package zombiemode;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import zombiemode.ZombieData;
import zombiemode.ZombieModeMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZombieVariables {
    public static final Capability<Variables> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Variables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ZombieModeMod.addNetworkMessage(VariablesSync.class, VariablesSync::buffer, VariablesSync::new, VariablesSync::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(Variables.class);
    }

    public static class VariablesSync {
        private final Variables data;

        public VariablesSync(FriendlyByteBuf buffer) {
            this.data = new Variables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public VariablesSync(Variables data) {
            this.data = data;
        }

        public static void buffer(VariablesSync message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(VariablesSync message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    Variables variables = (Variables)Minecraft.m_91087_().f_91074_.getCapability(CAPABILITY, null).orElse((Object)new Variables());
                    variables.zombieData = message.data.zombieData;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class Variables {
        public ZombieData zombieData = new ZombieData(null);

        public void syncVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ZombieModeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new VariablesSync(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("saved", (Tag)this.zombieData.saveTag());
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            if (nbt.m_128441_("saved")) {
                this.zombieData = new ZombieData(nbt.m_128469_("saved"), null);
            }
        }
    }

    @Mod.EventBusSubscriber
    private static class VariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final Variables variables = new Variables();
        private final LazyOptional<Variables> instance = LazyOptional.of(() -> this.variables);

        private VariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("zombie", "data"), (ICapabilityProvider)new VariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.variables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.variables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((Variables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new Variables())).syncVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((Variables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new Variables())).syncVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((Variables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new Variables())).syncVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            Variables original = (Variables)event.getOriginal().getCapability(CAPABILITY, null).orElse((Object)new Variables());
            Variables clone = (Variables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new Variables());
            clone.zombieData = original.zombieData;
            clone.zombieData.updatePlayer(event.getEntity());
        }
    }
}

