/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.entity;

import net.eternal_tales.init.EternalTalesModEntities;
import net.eternal_tales.init.EternalTalesModItems;
import net.eternal_tales.procedures.MucunhornProjectileHitsBlockProcedure;
import net.eternal_tales.procedures.MucunhornProjectileHitsProcedure;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MucunhornEntity
extends AbstractArrow
implements ItemSupplier {
    public MucunhornEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)EternalTalesModEntities.MUCUNHORN.get(), world);
    }

    public MucunhornEntity(EntityType<? extends MucunhornEntity> type, Level world) {
        super(type, world);
    }

    public MucunhornEntity(EntityType<? extends MucunhornEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public MucunhornEntity(EntityType<? extends MucunhornEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)EternalTalesModItems.SKYLITE_CANNONBALL.get());
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_6123_(Player entity) {
        super.m_6123_(entity);
        MucunhornProjectileHitsProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)entity, this.m_19749_());
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        MucunhornProjectileHitsProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), entityHitResult.m_82443_(), this.m_19749_());
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        MucunhornProjectileHitsBlockProcedure.execute((LevelAccessor)this.f_19853_, blockHitResult.m_82425_().m_123341_(), blockHitResult.m_82425_().m_123342_(), blockHitResult.m_82425_().m_123343_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static MucunhornEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MucunhornEntity entityarrow = new MucunhornEntity((EntityType<? extends MucunhornEntity>)((EntityType)EternalTalesModEntities.MUCUNHORN.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static MucunhornEntity shoot(LivingEntity entity, LivingEntity target) {
        MucunhornEntity entityarrow = new MucunhornEntity((EntityType<? extends MucunhornEntity>)((EntityType)EternalTalesModEntities.MUCUNHORN.get()), entity, entity.f_19853_);
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(5.0);
        entityarrow.m_36735_(1);
        entityarrow.m_36762_(false);
        entity.f_19853_.m_7967_((Entity)entityarrow);
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

