/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.eternal_tales.EternalTalesMod;
import net.eternal_tales.procedures.Bank1TradeProcedure;
import net.eternal_tales.procedures.Bank2TradeProcedure;
import net.eternal_tales.procedures.Bank3TradeProcedure;
import net.eternal_tales.world.inventory.CashMachineGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CashMachineGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CashMachineGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CashMachineGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CashMachineGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CashMachineGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CashMachineGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = CashMachineGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            Bank1TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Bank1TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Bank2TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Bank2TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Bank3TradeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(CashMachineGUIButtonMessage.class, CashMachineGUIButtonMessage::buffer, CashMachineGUIButtonMessage::new, CashMachineGUIButtonMessage::handler);
    }
}

