/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import java.util.function.Supplier;
import net.eternal_tales.EternalTalesMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EternalTalesModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        EternalTalesMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.skill_digging_level = message.data.skill_digging_level;
                    variables.skill_digging_points = message.data.skill_digging_points;
                    variables.skill_digging_points_need = message.data.skill_digging_points_need;
                    variables.skill_fishing_level = message.data.skill_fishing_level;
                    variables.skill_fishing_points = message.data.skill_fishing_points;
                    variables.skill_fishing_points_need = message.data.skill_fishing_points_need;
                    variables.skill_growing_level = message.data.skill_growing_level;
                    variables.skill_growing_points = message.data.skill_growing_points;
                    variables.skill_growing_points_need = message.data.skill_growing_points_need;
                    variables.skill_sorcery_level = message.data.skill_sorcery_level;
                    variables.skill_sorcery_points = message.data.skill_sorcery_points;
                    variables.skill_sorcery_points_need = message.data.skill_sorcery_points_need;
                    variables.firstmission = message.data.firstmission;
                    variables.show_essence = message.data.show_essence;
                    variables.tefius = message.data.tefius;
                    variables.isaris = message.data.isaris;
                    variables.ayeris = message.data.ayeris;
                    variables.tefiusmax = message.data.tefiusmax;
                    variables.isarismax = message.data.isarismax;
                    variables.ayerismax = message.data.ayerismax;
                    variables.isaris_boosted = message.data.isaris_boosted;
                    variables.ayeris_boosted = message.data.ayeris_boosted;
                    variables.tefius_boosted = message.data.tefius_boosted;
                    variables.truadamantite_boosted = message.data.truadamantite_boosted;
                    variables.dark_mage_boosted = message.data.dark_mage_boosted;
                    variables.iwa_cooldown = message.data.iwa_cooldown;
                    variables.amber_quest_progress = message.data.amber_quest_progress;
                    variables.chthonic_boosted = message.data.chthonic_boosted;
                    variables.orichancum_boosted = message.data.orichancum_boosted;
                    variables.unahzaal_boosted = message.data.unahzaal_boosted;
                    variables.spawn_arky = message.data.spawn_arky;
                    variables.spawn_dylan_moremi = message.data.spawn_dylan_moremi;
                    variables.otherworldly_eyes_on = message.data.otherworldly_eyes_on;
                    variables.arsonist_of_lands_on = message.data.arsonist_of_lands_on;
                    variables.vivid_kills = message.data.vivid_kills;
                    variables.martyr_kills = message.data.martyr_kills;
                    variables.kraken_kills = message.data.kraken_kills;
                    variables.terribletree_kills = message.data.terribletree_kills;
                    variables.rockblaze_kills = message.data.rockblaze_kills;
                    variables.nyetet_kills = message.data.nyetet_kills;
                    variables.jaghax_kills = message.data.jaghax_kills;
                    variables.pterion_kills = message.data.pterion_kills;
                    variables.arla_kills = message.data.arla_kills;
                    variables.haciru_kills = message.data.haciru_kills;
                    variables.ikkorh_kills = message.data.ikkorh_kills;
                    variables.hirots_kills = message.data.hirots_kills;
                    variables.enicrih_kills = message.data.enicrih_kills;
                    variables.arahulum_kills = message.data.arahulum_kills;
                    variables.volcanicgolem_kills = message.data.volcanicgolem_kills;
                    variables.xaxxasxix_kills = message.data.xaxxasxix_kills;
                    variables.unahzaal_kills = message.data.unahzaal_kills;
                    variables.halloweenspirit_kills = message.data.halloweenspirit_kills;
                    variables.brimstoneagaric_kills = message.data.brimstoneagaric_kills;
                    variables.areispirit_kills = message.data.areispirit_kills;
                    variables.william_kills = message.data.william_kills;
                    variables.piglinwarlock_kills = message.data.piglinwarlock_kills;
                    variables.tsarofpiglins_kills = message.data.tsarofpiglins_kills;
                    variables.khogachi_kills = message.data.khogachi_kills;
                    variables.ravritequeen_kills = message.data.ravritequeen_kills;
                    variables.skill_fear_level = message.data.skill_fear_level;
                    variables.skill_fear_points = message.data.skill_fear_points;
                    variables.skill_fear_points_need = message.data.skill_fear_points_need;
                    variables.fear_counting = message.data.fear_counting;
                    variables.crimson_tears = message.data.crimson_tears;
                    variables.humanity = message.data.humanity;
                    variables.luciden_kills = message.data.luciden_kills;
                    variables.noxifer_kills = message.data.noxifer_kills;
                    variables.destiny_space = message.data.destiny_space;
                    variables.destiny_power = message.data.destiny_power;
                    variables.destiny_reality = message.data.destiny_reality;
                    variables.destiny_mind = message.data.destiny_mind;
                    variables.destiny_soul = message.data.destiny_soul;
                    variables.destiny_time = message.data.destiny_time;
                    variables.kills = message.data.kills;
                    variables.great_emblem_fly = message.data.great_emblem_fly;
                    variables.ekatebrina_kills = message.data.ekatebrina_kills;
                    variables.show_skills = message.data.show_skills;
                    variables.chainsaw_active = message.data.chainsaw_active;
                    variables.terra_hammer_active = message.data.terra_hammer_active;
                    variables.nether_hammer_active = message.data.nether_hammer_active;
                    variables.skill_speech_level = message.data.skill_speech_level;
                    variables.skill_speech_points = message.data.skill_speech_points;
                    variables.skill_speech_points_need = message.data.skill_speech_points_need;
                    variables.level_points = message.data.level_points;
                    variables.player_level = message.data.player_level;
                    variables.level_points_need = message.data.level_points_need;
                    variables.level_skill_points = message.data.level_skill_points;
                    variables.show_crimson_tears = message.data.show_crimson_tears;
                    variables.active_quest = message.data.active_quest;
                    variables.has_active_quest = message.data.has_active_quest;
                    variables.overworld_quest = message.data.overworld_quest;
                    variables.nether_quest = message.data.nether_quest;
                    variables.end_quest = message.data.end_quest;
                    variables.comets_quest = message.data.comets_quest;
                    variables.purgatorium_quest = message.data.purgatorium_quest;
                    variables.eden_quest = message.data.eden_quest;
                    variables.rayana_quest = message.data.rayana_quest;
                    variables.karvat_quest = message.data.karvat_quest;
                    variables.volcanech_quest = message.data.volcanech_quest;
                    variables.amber_quest = message.data.amber_quest;
                    variables.quest_overworld_stage = message.data.quest_overworld_stage;
                    variables.active_quest_id = message.data.active_quest_id;
                    variables.quest_nether_stage = message.data.quest_nether_stage;
                    variables.quest_end_stage = message.data.quest_end_stage;
                    variables.quest_comets_stage = message.data.quest_comets_stage;
                    variables.quest_purgatorium_stage = message.data.quest_purgatorium_stage;
                    variables.quest_eden_stage = message.data.quest_eden_stage;
                    variables.quest_rayana_stage = message.data.quest_rayana_stage;
                    variables.quest_karvat_stage = message.data.quest_karvat_stage;
                    variables.quest_volcanech_stage = message.data.quest_volcanech_stage;
                    variables.quest_amber_stage = message.data.quest_amber_stage;
                    variables.comet_fleas_killed = message.data.comet_fleas_killed;
                    variables.eternal_dawn_kills = message.data.eternal_dawn_kills;
                    variables.celestial_comets_x = message.data.celestial_comets_x;
                    variables.celestial_comets_y = message.data.celestial_comets_y;
                    variables.celestial_comets_z = message.data.celestial_comets_z;
                    variables.celestial_eden_x = message.data.celestial_eden_x;
                    variables.celestial_eden_y = message.data.celestial_eden_y;
                    variables.celestial_eden_z = message.data.celestial_eden_z;
                    variables.celestial_comets_binded = message.data.celestial_comets_binded;
                    variables.celestial_eden_binded = message.data.celestial_eden_binded;
                    variables.guitar_skill = message.data.guitar_skill;
                    variables.guitar_points = message.data.guitar_points;
                    variables.ender_dragon_kills = message.data.ender_dragon_kills;
                    variables.wither_kills = message.data.wither_kills;
                    variables.elder_guardian_kills = message.data.elder_guardian_kills;
                    variables.warden_kills = message.data.warden_kills;
                    variables.dice_player = message.data.dice_player;
                    variables.dice_bartender = message.data.dice_bartender;
                    variables.eternity_hammer_active = message.data.eternity_hammer_active;
                    variables.spawn_lenot = message.data.spawn_lenot;
                    variables.skill_catching_level = message.data.skill_catching_level;
                    variables.skill_catching_points = message.data.skill_catching_points;
                    variables.skill_catching_points_need = message.data.skill_catching_points_need;
                    variables.skill_slaying_level = message.data.skill_slaying_level;
                    variables.skill_slaying_points = message.data.skill_slaying_points;
                    variables.skill_slaying_points_need = message.data.skill_slaying_points_need;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double skill_digging_level = 0.0;
        public double skill_digging_points = 0.0;
        public double skill_digging_points_need = 5.0;
        public double skill_fishing_level = 0.0;
        public double skill_fishing_points = 0.0;
        public double skill_fishing_points_need = 5.0;
        public double skill_growing_level = 0.0;
        public double skill_growing_points = 0.0;
        public double skill_growing_points_need = 5.0;
        public double skill_sorcery_level = 0.0;
        public double skill_sorcery_points = 0.0;
        public double skill_sorcery_points_need = 5.0;
        public double firstmission = 1.0;
        public boolean show_essence = false;
        public double tefius = 0.0;
        public double isaris = 0.0;
        public double ayeris = 0.0;
        public double tefiusmax = 0.0;
        public double isarismax = 0.0;
        public double ayerismax = 0.0;
        public boolean isaris_boosted = false;
        public boolean ayeris_boosted = false;
        public boolean tefius_boosted = false;
        public boolean truadamantite_boosted = false;
        public boolean dark_mage_boosted = false;
        public double iwa_cooldown = 0.0;
        public double amber_quest_progress = 0.0;
        public boolean chthonic_boosted = false;
        public boolean orichancum_boosted = false;
        public boolean unahzaal_boosted = false;
        public boolean spawn_arky = false;
        public boolean spawn_dylan_moremi = false;
        public boolean otherworldly_eyes_on = false;
        public boolean arsonist_of_lands_on = false;
        public double vivid_kills = 0.0;
        public double martyr_kills = 0.0;
        public double kraken_kills = 0.0;
        public double terribletree_kills = 0.0;
        public double rockblaze_kills = 0.0;
        public double nyetet_kills = 0.0;
        public double jaghax_kills = 0.0;
        public double pterion_kills = 0.0;
        public double arla_kills = 0.0;
        public double haciru_kills = 0.0;
        public double ikkorh_kills = 0.0;
        public double hirots_kills = 0.0;
        public double enicrih_kills = 0.0;
        public double arahulum_kills = 0.0;
        public double volcanicgolem_kills = 0.0;
        public double xaxxasxix_kills = 0.0;
        public double unahzaal_kills = 0.0;
        public double halloweenspirit_kills = 0.0;
        public double brimstoneagaric_kills = 0.0;
        public double areispirit_kills = 0.0;
        public double william_kills = 0.0;
        public double piglinwarlock_kills = 0.0;
        public double tsarofpiglins_kills = 0.0;
        public double khogachi_kills = 0.0;
        public double ravritequeen_kills = 0.0;
        public double skill_fear_level = 0.0;
        public double skill_fear_points = 0.0;
        public double skill_fear_points_need = 5.0;
        public double fear_counting = 0.0;
        public double crimson_tears = 5.0;
        public double humanity = 0.0;
        public double luciden_kills = 0.0;
        public double noxifer_kills = 0.0;
        public boolean destiny_space = false;
        public boolean destiny_power = false;
        public boolean destiny_reality = false;
        public boolean destiny_mind = false;
        public boolean destiny_soul = false;
        public boolean destiny_time = false;
        public double kills = 0.0;
        public boolean great_emblem_fly = false;
        public double ekatebrina_kills = 0.0;
        public boolean show_skills = false;
        public boolean chainsaw_active = false;
        public boolean terra_hammer_active = false;
        public boolean nether_hammer_active = false;
        public double skill_speech_level = 0.0;
        public double skill_speech_points = 0.0;
        public double skill_speech_points_need = 5.0;
        public double level_points = 0.0;
        public double player_level = 0.0;
        public double level_points_need = 5.0;
        public double level_skill_points = 0.0;
        public boolean show_crimson_tears = true;
        public String active_quest = "--";
        public boolean has_active_quest = false;
        public String overworld_quest = "???";
        public String nether_quest = "???";
        public String end_quest = "???";
        public String comets_quest = "???";
        public String purgatorium_quest = "???";
        public String eden_quest = "???";
        public String rayana_quest = "???";
        public String karvat_quest = "???";
        public String volcanech_quest = "???";
        public String amber_quest = "???";
        public double quest_overworld_stage = 0.0;
        public double active_quest_id = 0.0;
        public double quest_nether_stage = 0.0;
        public double quest_end_stage = 0.0;
        public double quest_comets_stage = 0.0;
        public double quest_purgatorium_stage = 0.0;
        public double quest_eden_stage = 0.0;
        public double quest_rayana_stage = 0.0;
        public double quest_karvat_stage = 0.0;
        public double quest_volcanech_stage = 0.0;
        public double quest_amber_stage = 0.0;
        public double comet_fleas_killed = 0.0;
        public double eternal_dawn_kills = 0.0;
        public double celestial_comets_x = 0.0;
        public double celestial_comets_y = 0.0;
        public double celestial_comets_z = 0.0;
        public double celestial_eden_x = 0.0;
        public double celestial_eden_y = 0.0;
        public double celestial_eden_z = 0.0;
        public boolean celestial_comets_binded = false;
        public boolean celestial_eden_binded = false;
        public boolean guitar_skill = false;
        public double guitar_points = 0.0;
        public double ender_dragon_kills = 0.0;
        public double wither_kills = 0.0;
        public double elder_guardian_kills = 0.0;
        public double warden_kills = 0.0;
        public double dice_player = 0.0;
        public double dice_bartender = 0.0;
        public boolean eternity_hammer_active = false;
        public boolean spawn_lenot = false;
        public double skill_catching_level = 0.0;
        public double skill_catching_points = 0.0;
        public double skill_catching_points_need = 5.0;
        public double skill_slaying_level = 0.0;
        public double skill_slaying_points = 0.0;
        public double skill_slaying_points_need = 5.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("skill_digging_level", this.skill_digging_level);
            nbt.m_128347_("skill_digging_points", this.skill_digging_points);
            nbt.m_128347_("skill_digging_points_need", this.skill_digging_points_need);
            nbt.m_128347_("skill_fishing_level", this.skill_fishing_level);
            nbt.m_128347_("skill_fishing_points", this.skill_fishing_points);
            nbt.m_128347_("skill_fishing_points_need", this.skill_fishing_points_need);
            nbt.m_128347_("skill_growing_level", this.skill_growing_level);
            nbt.m_128347_("skill_growing_points", this.skill_growing_points);
            nbt.m_128347_("skill_growing_points_need", this.skill_growing_points_need);
            nbt.m_128347_("skill_sorcery_level", this.skill_sorcery_level);
            nbt.m_128347_("skill_sorcery_points", this.skill_sorcery_points);
            nbt.m_128347_("skill_sorcery_points_need", this.skill_sorcery_points_need);
            nbt.m_128347_("firstmission", this.firstmission);
            nbt.m_128379_("show_essence", this.show_essence);
            nbt.m_128347_("tefius", this.tefius);
            nbt.m_128347_("isaris", this.isaris);
            nbt.m_128347_("ayeris", this.ayeris);
            nbt.m_128347_("tefiusmax", this.tefiusmax);
            nbt.m_128347_("isarismax", this.isarismax);
            nbt.m_128347_("ayerismax", this.ayerismax);
            nbt.m_128379_("isaris_boosted", this.isaris_boosted);
            nbt.m_128379_("ayeris_boosted", this.ayeris_boosted);
            nbt.m_128379_("tefius_boosted", this.tefius_boosted);
            nbt.m_128379_("truadamantite_boosted", this.truadamantite_boosted);
            nbt.m_128379_("dark_mage_boosted", this.dark_mage_boosted);
            nbt.m_128347_("iwa_cooldown", this.iwa_cooldown);
            nbt.m_128347_("amber_quest_progress", this.amber_quest_progress);
            nbt.m_128379_("chthonic_boosted", this.chthonic_boosted);
            nbt.m_128379_("orichancum_boosted", this.orichancum_boosted);
            nbt.m_128379_("unahzaal_boosted", this.unahzaal_boosted);
            nbt.m_128379_("spawn_arky", this.spawn_arky);
            nbt.m_128379_("spawn_dylan_moremi", this.spawn_dylan_moremi);
            nbt.m_128379_("otherworldly_eyes_on", this.otherworldly_eyes_on);
            nbt.m_128379_("arsonist_of_lands_on", this.arsonist_of_lands_on);
            nbt.m_128347_("vivid_kills", this.vivid_kills);
            nbt.m_128347_("martyr_kills", this.martyr_kills);
            nbt.m_128347_("kraken_kills", this.kraken_kills);
            nbt.m_128347_("terribletree_kills", this.terribletree_kills);
            nbt.m_128347_("rockblaze_kills", this.rockblaze_kills);
            nbt.m_128347_("nyetet_kills", this.nyetet_kills);
            nbt.m_128347_("jaghax_kills", this.jaghax_kills);
            nbt.m_128347_("pterion_kills", this.pterion_kills);
            nbt.m_128347_("arla_kills", this.arla_kills);
            nbt.m_128347_("haciru_kills", this.haciru_kills);
            nbt.m_128347_("ikkorh_kills", this.ikkorh_kills);
            nbt.m_128347_("hirots_kills", this.hirots_kills);
            nbt.m_128347_("enicrih_kills", this.enicrih_kills);
            nbt.m_128347_("arahulum_kills", this.arahulum_kills);
            nbt.m_128347_("volcanicgolem_kills", this.volcanicgolem_kills);
            nbt.m_128347_("xaxxasxix_kills", this.xaxxasxix_kills);
            nbt.m_128347_("unahzaal_kills", this.unahzaal_kills);
            nbt.m_128347_("halloweenspirit_kills", this.halloweenspirit_kills);
            nbt.m_128347_("brimstoneagaric_kills", this.brimstoneagaric_kills);
            nbt.m_128347_("areispirit_kills", this.areispirit_kills);
            nbt.m_128347_("william_kills", this.william_kills);
            nbt.m_128347_("piglinwarlock_kills", this.piglinwarlock_kills);
            nbt.m_128347_("tsarofpiglins_kills", this.tsarofpiglins_kills);
            nbt.m_128347_("khogachi_kills", this.khogachi_kills);
            nbt.m_128347_("ravritequeen_kills", this.ravritequeen_kills);
            nbt.m_128347_("skill_fear_level", this.skill_fear_level);
            nbt.m_128347_("skill_fear_points", this.skill_fear_points);
            nbt.m_128347_("skill_fear_points_need", this.skill_fear_points_need);
            nbt.m_128347_("fear_counting", this.fear_counting);
            nbt.m_128347_("crimson_tears", this.crimson_tears);
            nbt.m_128347_("humanity", this.humanity);
            nbt.m_128347_("luciden_kills", this.luciden_kills);
            nbt.m_128347_("noxifer_kills", this.noxifer_kills);
            nbt.m_128379_("destiny_space", this.destiny_space);
            nbt.m_128379_("destiny_power", this.destiny_power);
            nbt.m_128379_("destiny_reality", this.destiny_reality);
            nbt.m_128379_("destiny_mind", this.destiny_mind);
            nbt.m_128379_("destiny_soul", this.destiny_soul);
            nbt.m_128379_("destiny_time", this.destiny_time);
            nbt.m_128347_("kills", this.kills);
            nbt.m_128379_("great_emblem_fly", this.great_emblem_fly);
            nbt.m_128347_("ekatebrina_kills", this.ekatebrina_kills);
            nbt.m_128379_("show_skills", this.show_skills);
            nbt.m_128379_("chainsaw_active", this.chainsaw_active);
            nbt.m_128379_("terra_hammer_active", this.terra_hammer_active);
            nbt.m_128379_("nether_hammer_active", this.nether_hammer_active);
            nbt.m_128347_("skill_speech_level", this.skill_speech_level);
            nbt.m_128347_("skill_speech_points", this.skill_speech_points);
            nbt.m_128347_("skill_speech_points_need", this.skill_speech_points_need);
            nbt.m_128347_("level_points", this.level_points);
            nbt.m_128347_("player_level", this.player_level);
            nbt.m_128347_("level_points_need", this.level_points_need);
            nbt.m_128347_("level_skill_points", this.level_skill_points);
            nbt.m_128379_("show_crimson_tears", this.show_crimson_tears);
            nbt.m_128359_("active_quest", this.active_quest);
            nbt.m_128379_("has_active_quest", this.has_active_quest);
            nbt.m_128359_("overworld_quest", this.overworld_quest);
            nbt.m_128359_("nether_quest", this.nether_quest);
            nbt.m_128359_("end_quest", this.end_quest);
            nbt.m_128359_("comets_quest", this.comets_quest);
            nbt.m_128359_("purgatorium_quest", this.purgatorium_quest);
            nbt.m_128359_("eden_quest", this.eden_quest);
            nbt.m_128359_("rayana_quest", this.rayana_quest);
            nbt.m_128359_("karvat_quest", this.karvat_quest);
            nbt.m_128359_("volcanech_quest", this.volcanech_quest);
            nbt.m_128359_("amber_quest", this.amber_quest);
            nbt.m_128347_("quest_overworld_stage", this.quest_overworld_stage);
            nbt.m_128347_("active_quest_id", this.active_quest_id);
            nbt.m_128347_("quest_nether_stage", this.quest_nether_stage);
            nbt.m_128347_("quest_end_stage", this.quest_end_stage);
            nbt.m_128347_("quest_comets_stage", this.quest_comets_stage);
            nbt.m_128347_("quest_purgatorium_stage", this.quest_purgatorium_stage);
            nbt.m_128347_("quest_eden_stage", this.quest_eden_stage);
            nbt.m_128347_("quest_rayana_stage", this.quest_rayana_stage);
            nbt.m_128347_("quest_karvat_stage", this.quest_karvat_stage);
            nbt.m_128347_("quest_volcanech_stage", this.quest_volcanech_stage);
            nbt.m_128347_("quest_amber_stage", this.quest_amber_stage);
            nbt.m_128347_("comet_fleas_killed", this.comet_fleas_killed);
            nbt.m_128347_("eternal_dawn_kills", this.eternal_dawn_kills);
            nbt.m_128347_("celestial_comets_x", this.celestial_comets_x);
            nbt.m_128347_("celestial_comets_y", this.celestial_comets_y);
            nbt.m_128347_("celestial_comets_z", this.celestial_comets_z);
            nbt.m_128347_("celestial_eden_x", this.celestial_eden_x);
            nbt.m_128347_("celestial_eden_y", this.celestial_eden_y);
            nbt.m_128347_("celestial_eden_z", this.celestial_eden_z);
            nbt.m_128379_("celestial_comets_binded", this.celestial_comets_binded);
            nbt.m_128379_("celestial_eden_binded", this.celestial_eden_binded);
            nbt.m_128379_("guitar_skill", this.guitar_skill);
            nbt.m_128347_("guitar_points", this.guitar_points);
            nbt.m_128347_("ender_dragon_kills", this.ender_dragon_kills);
            nbt.m_128347_("wither_kills", this.wither_kills);
            nbt.m_128347_("elder_guardian_kills", this.elder_guardian_kills);
            nbt.m_128347_("warden_kills", this.warden_kills);
            nbt.m_128347_("dice_player", this.dice_player);
            nbt.m_128347_("dice_bartender", this.dice_bartender);
            nbt.m_128379_("eternity_hammer_active", this.eternity_hammer_active);
            nbt.m_128379_("spawn_lenot", this.spawn_lenot);
            nbt.m_128347_("skill_catching_level", this.skill_catching_level);
            nbt.m_128347_("skill_catching_points", this.skill_catching_points);
            nbt.m_128347_("skill_catching_points_need", this.skill_catching_points_need);
            nbt.m_128347_("skill_slaying_level", this.skill_slaying_level);
            nbt.m_128347_("skill_slaying_points", this.skill_slaying_points);
            nbt.m_128347_("skill_slaying_points_need", this.skill_slaying_points_need);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.skill_digging_level = nbt.m_128459_("skill_digging_level");
            this.skill_digging_points = nbt.m_128459_("skill_digging_points");
            this.skill_digging_points_need = nbt.m_128459_("skill_digging_points_need");
            this.skill_fishing_level = nbt.m_128459_("skill_fishing_level");
            this.skill_fishing_points = nbt.m_128459_("skill_fishing_points");
            this.skill_fishing_points_need = nbt.m_128459_("skill_fishing_points_need");
            this.skill_growing_level = nbt.m_128459_("skill_growing_level");
            this.skill_growing_points = nbt.m_128459_("skill_growing_points");
            this.skill_growing_points_need = nbt.m_128459_("skill_growing_points_need");
            this.skill_sorcery_level = nbt.m_128459_("skill_sorcery_level");
            this.skill_sorcery_points = nbt.m_128459_("skill_sorcery_points");
            this.skill_sorcery_points_need = nbt.m_128459_("skill_sorcery_points_need");
            this.firstmission = nbt.m_128459_("firstmission");
            this.show_essence = nbt.m_128471_("show_essence");
            this.tefius = nbt.m_128459_("tefius");
            this.isaris = nbt.m_128459_("isaris");
            this.ayeris = nbt.m_128459_("ayeris");
            this.tefiusmax = nbt.m_128459_("tefiusmax");
            this.isarismax = nbt.m_128459_("isarismax");
            this.ayerismax = nbt.m_128459_("ayerismax");
            this.isaris_boosted = nbt.m_128471_("isaris_boosted");
            this.ayeris_boosted = nbt.m_128471_("ayeris_boosted");
            this.tefius_boosted = nbt.m_128471_("tefius_boosted");
            this.truadamantite_boosted = nbt.m_128471_("truadamantite_boosted");
            this.dark_mage_boosted = nbt.m_128471_("dark_mage_boosted");
            this.iwa_cooldown = nbt.m_128459_("iwa_cooldown");
            this.amber_quest_progress = nbt.m_128459_("amber_quest_progress");
            this.chthonic_boosted = nbt.m_128471_("chthonic_boosted");
            this.orichancum_boosted = nbt.m_128471_("orichancum_boosted");
            this.unahzaal_boosted = nbt.m_128471_("unahzaal_boosted");
            this.spawn_arky = nbt.m_128471_("spawn_arky");
            this.spawn_dylan_moremi = nbt.m_128471_("spawn_dylan_moremi");
            this.otherworldly_eyes_on = nbt.m_128471_("otherworldly_eyes_on");
            this.arsonist_of_lands_on = nbt.m_128471_("arsonist_of_lands_on");
            this.vivid_kills = nbt.m_128459_("vivid_kills");
            this.martyr_kills = nbt.m_128459_("martyr_kills");
            this.kraken_kills = nbt.m_128459_("kraken_kills");
            this.terribletree_kills = nbt.m_128459_("terribletree_kills");
            this.rockblaze_kills = nbt.m_128459_("rockblaze_kills");
            this.nyetet_kills = nbt.m_128459_("nyetet_kills");
            this.jaghax_kills = nbt.m_128459_("jaghax_kills");
            this.pterion_kills = nbt.m_128459_("pterion_kills");
            this.arla_kills = nbt.m_128459_("arla_kills");
            this.haciru_kills = nbt.m_128459_("haciru_kills");
            this.ikkorh_kills = nbt.m_128459_("ikkorh_kills");
            this.hirots_kills = nbt.m_128459_("hirots_kills");
            this.enicrih_kills = nbt.m_128459_("enicrih_kills");
            this.arahulum_kills = nbt.m_128459_("arahulum_kills");
            this.volcanicgolem_kills = nbt.m_128459_("volcanicgolem_kills");
            this.xaxxasxix_kills = nbt.m_128459_("xaxxasxix_kills");
            this.unahzaal_kills = nbt.m_128459_("unahzaal_kills");
            this.halloweenspirit_kills = nbt.m_128459_("halloweenspirit_kills");
            this.brimstoneagaric_kills = nbt.m_128459_("brimstoneagaric_kills");
            this.areispirit_kills = nbt.m_128459_("areispirit_kills");
            this.william_kills = nbt.m_128459_("william_kills");
            this.piglinwarlock_kills = nbt.m_128459_("piglinwarlock_kills");
            this.tsarofpiglins_kills = nbt.m_128459_("tsarofpiglins_kills");
            this.khogachi_kills = nbt.m_128459_("khogachi_kills");
            this.ravritequeen_kills = nbt.m_128459_("ravritequeen_kills");
            this.skill_fear_level = nbt.m_128459_("skill_fear_level");
            this.skill_fear_points = nbt.m_128459_("skill_fear_points");
            this.skill_fear_points_need = nbt.m_128459_("skill_fear_points_need");
            this.fear_counting = nbt.m_128459_("fear_counting");
            this.crimson_tears = nbt.m_128459_("crimson_tears");
            this.humanity = nbt.m_128459_("humanity");
            this.luciden_kills = nbt.m_128459_("luciden_kills");
            this.noxifer_kills = nbt.m_128459_("noxifer_kills");
            this.destiny_space = nbt.m_128471_("destiny_space");
            this.destiny_power = nbt.m_128471_("destiny_power");
            this.destiny_reality = nbt.m_128471_("destiny_reality");
            this.destiny_mind = nbt.m_128471_("destiny_mind");
            this.destiny_soul = nbt.m_128471_("destiny_soul");
            this.destiny_time = nbt.m_128471_("destiny_time");
            this.kills = nbt.m_128459_("kills");
            this.great_emblem_fly = nbt.m_128471_("great_emblem_fly");
            this.ekatebrina_kills = nbt.m_128459_("ekatebrina_kills");
            this.show_skills = nbt.m_128471_("show_skills");
            this.chainsaw_active = nbt.m_128471_("chainsaw_active");
            this.terra_hammer_active = nbt.m_128471_("terra_hammer_active");
            this.nether_hammer_active = nbt.m_128471_("nether_hammer_active");
            this.skill_speech_level = nbt.m_128459_("skill_speech_level");
            this.skill_speech_points = nbt.m_128459_("skill_speech_points");
            this.skill_speech_points_need = nbt.m_128459_("skill_speech_points_need");
            this.level_points = nbt.m_128459_("level_points");
            this.player_level = nbt.m_128459_("player_level");
            this.level_points_need = nbt.m_128459_("level_points_need");
            this.level_skill_points = nbt.m_128459_("level_skill_points");
            this.show_crimson_tears = nbt.m_128471_("show_crimson_tears");
            this.active_quest = nbt.m_128461_("active_quest");
            this.has_active_quest = nbt.m_128471_("has_active_quest");
            this.overworld_quest = nbt.m_128461_("overworld_quest");
            this.nether_quest = nbt.m_128461_("nether_quest");
            this.end_quest = nbt.m_128461_("end_quest");
            this.comets_quest = nbt.m_128461_("comets_quest");
            this.purgatorium_quest = nbt.m_128461_("purgatorium_quest");
            this.eden_quest = nbt.m_128461_("eden_quest");
            this.rayana_quest = nbt.m_128461_("rayana_quest");
            this.karvat_quest = nbt.m_128461_("karvat_quest");
            this.volcanech_quest = nbt.m_128461_("volcanech_quest");
            this.amber_quest = nbt.m_128461_("amber_quest");
            this.quest_overworld_stage = nbt.m_128459_("quest_overworld_stage");
            this.active_quest_id = nbt.m_128459_("active_quest_id");
            this.quest_nether_stage = nbt.m_128459_("quest_nether_stage");
            this.quest_end_stage = nbt.m_128459_("quest_end_stage");
            this.quest_comets_stage = nbt.m_128459_("quest_comets_stage");
            this.quest_purgatorium_stage = nbt.m_128459_("quest_purgatorium_stage");
            this.quest_eden_stage = nbt.m_128459_("quest_eden_stage");
            this.quest_rayana_stage = nbt.m_128459_("quest_rayana_stage");
            this.quest_karvat_stage = nbt.m_128459_("quest_karvat_stage");
            this.quest_volcanech_stage = nbt.m_128459_("quest_volcanech_stage");
            this.quest_amber_stage = nbt.m_128459_("quest_amber_stage");
            this.comet_fleas_killed = nbt.m_128459_("comet_fleas_killed");
            this.eternal_dawn_kills = nbt.m_128459_("eternal_dawn_kills");
            this.celestial_comets_x = nbt.m_128459_("celestial_comets_x");
            this.celestial_comets_y = nbt.m_128459_("celestial_comets_y");
            this.celestial_comets_z = nbt.m_128459_("celestial_comets_z");
            this.celestial_eden_x = nbt.m_128459_("celestial_eden_x");
            this.celestial_eden_y = nbt.m_128459_("celestial_eden_y");
            this.celestial_eden_z = nbt.m_128459_("celestial_eden_z");
            this.celestial_comets_binded = nbt.m_128471_("celestial_comets_binded");
            this.celestial_eden_binded = nbt.m_128471_("celestial_eden_binded");
            this.guitar_skill = nbt.m_128471_("guitar_skill");
            this.guitar_points = nbt.m_128459_("guitar_points");
            this.ender_dragon_kills = nbt.m_128459_("ender_dragon_kills");
            this.wither_kills = nbt.m_128459_("wither_kills");
            this.elder_guardian_kills = nbt.m_128459_("elder_guardian_kills");
            this.warden_kills = nbt.m_128459_("warden_kills");
            this.dice_player = nbt.m_128459_("dice_player");
            this.dice_bartender = nbt.m_128459_("dice_bartender");
            this.eternity_hammer_active = nbt.m_128471_("eternity_hammer_active");
            this.spawn_lenot = nbt.m_128471_("spawn_lenot");
            this.skill_catching_level = nbt.m_128459_("skill_catching_level");
            this.skill_catching_points = nbt.m_128459_("skill_catching_points");
            this.skill_catching_points_need = nbt.m_128459_("skill_catching_points_need");
            this.skill_slaying_level = nbt.m_128459_("skill_slaying_level");
            this.skill_slaying_points = nbt.m_128459_("skill_slaying_points");
            this.skill_slaying_points_need = nbt.m_128459_("skill_slaying_points_need");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("eternal_tales", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "eternal_tales_mapvars";
        public double eternaltowngen = 2.0;
        public boolean maze_visited = false;
        public boolean unahzaal_killed = false;
        public boolean arahulum_killed = false;
        public boolean eternity_darkness = false;
        public boolean kraken_killed = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.eternaltowngen = nbt.m_128459_("eternaltowngen");
            this.maze_visited = nbt.m_128471_("maze_visited");
            this.unahzaal_killed = nbt.m_128471_("unahzaal_killed");
            this.arahulum_killed = nbt.m_128471_("arahulum_killed");
            this.eternity_darkness = nbt.m_128471_("eternity_darkness");
            this.kraken_killed = nbt.m_128471_("kraken_killed");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("eternaltowngen", this.eternaltowngen);
            nbt.m_128379_("maze_visited", this.maze_visited);
            nbt.m_128379_("unahzaal_killed", this.unahzaal_killed);
            nbt.m_128379_("arahulum_killed", this.arahulum_killed);
            nbt.m_128379_("eternity_darkness", this.eternity_darkness);
            nbt.m_128379_("kraken_killed", this.kraken_killed);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "eternal_tales_worldvars";
        public boolean amber_visited = false;
        public boolean unahzaal_visited = false;
        public boolean superduperdarknessmode = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.amber_visited = nbt.m_128471_("amber_visited");
            this.unahzaal_visited = nbt.m_128471_("unahzaal_visited");
            this.superduperdarknessmode = nbt.m_128471_("superduperdarknessmode");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("amber_visited", this.amber_visited);
            nbt.m_128379_("unahzaal_visited", this.unahzaal_visited);
            nbt.m_128379_("superduperdarknessmode", this.superduperdarknessmode);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.skill_digging_level = original.skill_digging_level;
            clone.skill_digging_points = original.skill_digging_points;
            clone.skill_digging_points_need = original.skill_digging_points_need;
            clone.skill_fishing_level = original.skill_fishing_level;
            clone.skill_fishing_points = original.skill_fishing_points;
            clone.skill_fishing_points_need = original.skill_fishing_points_need;
            clone.skill_growing_level = original.skill_growing_level;
            clone.skill_growing_points = original.skill_growing_points;
            clone.skill_growing_points_need = original.skill_growing_points_need;
            clone.skill_sorcery_level = original.skill_sorcery_level;
            clone.skill_sorcery_points = original.skill_sorcery_points;
            clone.skill_sorcery_points_need = original.skill_sorcery_points_need;
            clone.firstmission = original.firstmission;
            clone.show_essence = original.show_essence;
            clone.tefius = original.tefius;
            clone.isaris = original.isaris;
            clone.ayeris = original.ayeris;
            clone.tefiusmax = original.tefiusmax;
            clone.isarismax = original.isarismax;
            clone.ayerismax = original.ayerismax;
            clone.dark_mage_boosted = original.dark_mage_boosted;
            clone.amber_quest_progress = original.amber_quest_progress;
            clone.spawn_arky = original.spawn_arky;
            clone.spawn_dylan_moremi = original.spawn_dylan_moremi;
            clone.arsonist_of_lands_on = original.arsonist_of_lands_on;
            clone.vivid_kills = original.vivid_kills;
            clone.martyr_kills = original.martyr_kills;
            clone.kraken_kills = original.kraken_kills;
            clone.terribletree_kills = original.terribletree_kills;
            clone.rockblaze_kills = original.rockblaze_kills;
            clone.nyetet_kills = original.nyetet_kills;
            clone.jaghax_kills = original.jaghax_kills;
            clone.pterion_kills = original.pterion_kills;
            clone.arla_kills = original.arla_kills;
            clone.haciru_kills = original.haciru_kills;
            clone.ikkorh_kills = original.ikkorh_kills;
            clone.hirots_kills = original.hirots_kills;
            clone.enicrih_kills = original.enicrih_kills;
            clone.arahulum_kills = original.arahulum_kills;
            clone.volcanicgolem_kills = original.volcanicgolem_kills;
            clone.xaxxasxix_kills = original.xaxxasxix_kills;
            clone.unahzaal_kills = original.unahzaal_kills;
            clone.halloweenspirit_kills = original.halloweenspirit_kills;
            clone.brimstoneagaric_kills = original.brimstoneagaric_kills;
            clone.areispirit_kills = original.areispirit_kills;
            clone.william_kills = original.william_kills;
            clone.piglinwarlock_kills = original.piglinwarlock_kills;
            clone.tsarofpiglins_kills = original.tsarofpiglins_kills;
            clone.khogachi_kills = original.khogachi_kills;
            clone.ravritequeen_kills = original.ravritequeen_kills;
            clone.skill_fear_level = original.skill_fear_level;
            clone.skill_fear_points = original.skill_fear_points;
            clone.skill_fear_points_need = original.skill_fear_points_need;
            clone.crimson_tears = original.crimson_tears;
            clone.humanity = original.humanity;
            clone.luciden_kills = original.luciden_kills;
            clone.noxifer_kills = original.noxifer_kills;
            clone.destiny_space = original.destiny_space;
            clone.destiny_power = original.destiny_power;
            clone.destiny_reality = original.destiny_reality;
            clone.destiny_mind = original.destiny_mind;
            clone.destiny_soul = original.destiny_soul;
            clone.destiny_time = original.destiny_time;
            clone.ekatebrina_kills = original.ekatebrina_kills;
            clone.show_skills = original.show_skills;
            clone.chainsaw_active = original.chainsaw_active;
            clone.terra_hammer_active = original.terra_hammer_active;
            clone.nether_hammer_active = original.nether_hammer_active;
            clone.skill_speech_level = original.skill_speech_level;
            clone.skill_speech_points = original.skill_speech_points;
            clone.skill_speech_points_need = original.skill_speech_points_need;
            clone.level_points = original.level_points;
            clone.player_level = original.player_level;
            clone.level_points_need = original.level_points_need;
            clone.level_skill_points = original.level_skill_points;
            clone.show_crimson_tears = original.show_crimson_tears;
            clone.active_quest = original.active_quest;
            clone.has_active_quest = original.has_active_quest;
            clone.overworld_quest = original.overworld_quest;
            clone.nether_quest = original.nether_quest;
            clone.end_quest = original.end_quest;
            clone.comets_quest = original.comets_quest;
            clone.purgatorium_quest = original.purgatorium_quest;
            clone.eden_quest = original.eden_quest;
            clone.rayana_quest = original.rayana_quest;
            clone.karvat_quest = original.karvat_quest;
            clone.volcanech_quest = original.volcanech_quest;
            clone.amber_quest = original.amber_quest;
            clone.quest_overworld_stage = original.quest_overworld_stage;
            clone.active_quest_id = original.active_quest_id;
            clone.quest_nether_stage = original.quest_nether_stage;
            clone.quest_end_stage = original.quest_end_stage;
            clone.quest_comets_stage = original.quest_comets_stage;
            clone.quest_purgatorium_stage = original.quest_purgatorium_stage;
            clone.quest_eden_stage = original.quest_eden_stage;
            clone.quest_rayana_stage = original.quest_rayana_stage;
            clone.quest_karvat_stage = original.quest_karvat_stage;
            clone.quest_volcanech_stage = original.quest_volcanech_stage;
            clone.quest_amber_stage = original.quest_amber_stage;
            clone.comet_fleas_killed = original.comet_fleas_killed;
            clone.eternal_dawn_kills = original.eternal_dawn_kills;
            clone.celestial_comets_x = original.celestial_comets_x;
            clone.celestial_comets_y = original.celestial_comets_y;
            clone.celestial_comets_z = original.celestial_comets_z;
            clone.celestial_eden_x = original.celestial_eden_x;
            clone.celestial_eden_y = original.celestial_eden_y;
            clone.celestial_eden_z = original.celestial_eden_z;
            clone.celestial_comets_binded = original.celestial_comets_binded;
            clone.celestial_eden_binded = original.celestial_eden_binded;
            clone.guitar_skill = original.guitar_skill;
            clone.guitar_points = original.guitar_points;
            clone.ender_dragon_kills = original.ender_dragon_kills;
            clone.wither_kills = original.wither_kills;
            clone.elder_guardian_kills = original.elder_guardian_kills;
            clone.warden_kills = original.warden_kills;
            clone.dice_player = original.dice_player;
            clone.dice_bartender = original.dice_bartender;
            clone.eternity_hammer_active = original.eternity_hammer_active;
            clone.spawn_lenot = original.spawn_lenot;
            clone.skill_catching_level = original.skill_catching_level;
            clone.skill_catching_points = original.skill_catching_points;
            clone.skill_catching_points_need = original.skill_catching_points_need;
            clone.skill_slaying_level = original.skill_slaying_level;
            clone.skill_slaying_points = original.skill_slaying_points;
            clone.skill_slaying_points_need = original.skill_slaying_points_need;
            if (!event.isWasDeath()) {
                clone.isaris_boosted = original.isaris_boosted;
                clone.ayeris_boosted = original.ayeris_boosted;
                clone.tefius_boosted = original.tefius_boosted;
                clone.truadamantite_boosted = original.truadamantite_boosted;
                clone.iwa_cooldown = original.iwa_cooldown;
                clone.chthonic_boosted = original.chthonic_boosted;
                clone.orichancum_boosted = original.orichancum_boosted;
                clone.unahzaal_boosted = original.unahzaal_boosted;
                clone.otherworldly_eyes_on = original.otherworldly_eyes_on;
                clone.fear_counting = original.fear_counting;
                clone.kills = original.kills;
                clone.great_emblem_fly = original.great_emblem_fly;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                EternalTalesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

