/*
 * Decompiled with CFR 0.152.
 */
package com.kennerhartman.realisticcampfires.mixin;

import com.kennerhartman.realisticcampfires.duck.CampfireBlockEntityProperties;
import com.kennerhartman.realisticcampfires.duck.CampfireBlockProperties;
import com.kennerhartman.realisticcampfires.state.enums.LogType;
import com.kennerhartman.realisticcampfires.state.property.ModProperties;
import com.kennerhartman.realisticcampfires.util.Utils;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3922;
import net.minecraft.class_3924;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3922.class})
public abstract class MixinCampfireBlock
extends class_2237
implements CampfireBlockProperties {
    @Unique
    private static final class_2746 LOG_ON_CAMPFIRE = ModProperties.LOG_ON_CAMPFIRE;
    @Unique
    private static final class_2754<LogType> LOG_BLOCK = ModProperties.LOG_BLOCK;

    protected MixinCampfireBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LOG_ON_CAMPFIRE, (Comparable)Boolean.valueOf(false))).method_11657(LOG_BLOCK, (Comparable)((Object)LogType.AIR)));
    }

    @Shadow
    public static boolean method_23896(class_2680 state) {
        return state.method_28498((class_2769)class_3922.field_17352) && state.method_26164(class_3481.field_23799) && (Boolean)state.method_11654((class_2769)class_3922.field_17352) != false;
    }

    @Inject(method={"<init>(ZILnet/minecraft/block/AbstractBlock$Settings;)V"}, at={@At(value="TAIL")})
    private void disableFireOnSetDefaultState(boolean emitsParticles, int fireDamage, class_4970.class_2251 settings, CallbackInfo ci) {
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.FALSE)).method_11657((class_2769)LOG_ON_CAMPFIRE, (Comparable)Boolean.FALSE));
    }

    @ModifyReturnValue(method={"getPlacementState"}, at={@At(value="RETURN")})
    private class_2680 disableFireOnGetPlacementState(class_2680 original) {
        return (class_2680)((class_2680)original.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.FALSE)).method_11657((class_2769)LOG_ON_CAMPFIRE, (Comparable)Boolean.FALSE);
    }

    @Inject(method={"appendProperties"}, at={@At(value="TAIL")})
    private void appendLogOnCampfireProperty(class_2689.class_2690<class_2248, class_2680> builder, CallbackInfo ci) {
        builder.method_11667(new class_2769[]{LOG_ON_CAMPFIRE});
        builder.method_11667(new class_2769[]{LOG_BLOCK});
    }

    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAndRemoveLogFromCampfire(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> cir) {
        boolean removedLog;
        boolean addedLog = this.addLogToCampfire(world, player, state, pos, player.method_6047());
        if (addedLog) {
            player.method_7281(class_3468.field_17486);
            cir.setReturnValue((Object)class_1269.field_5812);
            cir.cancel();
        }
        if (player.method_5715() && this.realistic_campfires$isAbleToLightOnFire(state) && (removedLog = this.realistic_campfires$removeLog(world, (class_1297)player, state, pos))) {
            class_3924 campfireBlockEntity = (class_3924)world.method_8321(pos);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(((CampfireBlockEntityProperties)campfireBlockEntity).realistic_campfires$getLog());
            class_1799 itemStack = new class_1799((class_1935)item, 1);
            player.method_7270(itemStack);
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            player.method_7281(class_3468.field_17486);
            cir.setReturnValue((Object)class_1269.field_5812);
            cir.cancel();
        }
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockWithEntity;onStateReplaced(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Z)V")})
    private void dropLogWhenBroken(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved, CallbackInfo ci) {
        if (this.realistic_campfires$isAbleToLightOnFire(state)) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(((LogType)((Object)state.method_11654(LOG_BLOCK))).asIdentifier());
            class_1799 itemStack = new class_1799((class_1935)item, 1);
            class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)class_2371.method_10213((int)1, (Object)itemStack));
        }
    }

    @Unique
    private boolean addLogToCampfire(class_1937 world, class_1657 player, class_2680 state, class_2338 blockPos, class_1799 itemStack) {
        if (!itemStack.method_7909().toString().contains("log")) {
            return false;
        }
        if (MixinCampfireBlock.method_23896(state)) {
            return false;
        }
        if (this.realistic_campfires$isAbleToLightOnFire(state)) {
            return false;
        }
        class_3924 campfireBlockEntity = (class_3924)world.method_8321(blockPos);
        int newStackSize = this.addLogToCampfireHelper(world, player, itemStack, state, blockPos, campfireBlockEntity);
        itemStack.method_7939(newStackSize);
        return true;
    }

    @Unique
    private int addLogToCampfireHelper(class_1937 world, class_1657 player, class_1799 itemStack, class_2680 state, class_2338 blockPos, class_3924 campfireBlockEntity) {
        int newItemStackSize = itemStack.method_7947();
        if (newItemStackSize > 0 && !this.realistic_campfires$isAbleToLightOnFire(state)) {
            if (!world.method_8608()) {
                LogType logType = ModProperties.returnLogType(Utils.translationKeyToIdentifier(itemStack.method_7922()));
                world.method_8652(blockPos, (class_2680)((class_2680)state.method_11657((class_2769)ModProperties.LOG_ON_CAMPFIRE, (Comparable)Boolean.TRUE)).method_11657(ModProperties.LOG_BLOCK, (Comparable)((Object)logType)), 11);
                world.method_33596(null, class_5712.field_28733, blockPos);
                ((CampfireBlockEntityProperties)campfireBlockEntity).realistic_campfires$setLog(class_7923.field_41178.method_10221((Object)itemStack.method_7909()));
            }
            if (!player.method_7337()) {
                --newItemStackSize;
            }
        }
        return newItemStackSize;
    }

    @Override
    public boolean realistic_campfires$removeLog(class_1937 world, class_1297 entity, class_2680 state, class_2338 pos) {
        if (!world.method_8608()) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)ModProperties.LOG_ON_CAMPFIRE, (Comparable)Boolean.valueOf(false))).method_11657(ModProperties.LOG_BLOCK, (Comparable)((Object)LogType.AIR)), 11);
            world.method_33596(entity, class_5712.field_28733, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean realistic_campfires$isAbleToLightOnFire(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)ModProperties.LOG_ON_CAMPFIRE);
    }
}

