/*
 * Decompiled with CFR 0.152.
 */
package com.kennerhartman.realisticcampfires.mixin;

import com.kennerhartman.realisticcampfires.duck.CampfireBlockEntityProperties;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3924;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3924.class})
public abstract class MixinCampfireBlockEntity
extends class_2586
implements CampfireBlockEntityProperties {
    @Unique
    private int burningTicks;
    @Unique
    private class_2960 log;
    @Unique
    private String logNamespace = "minecraft";
    @Unique
    private String logPath = "air";

    public MixinCampfireBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void readBurningTicksNbt(class_2487 nbt, CallbackInfo ci) {
        this.burningTicks = nbt.method_10550("burningTicks");
        this.log = nbt.method_10545("logNamespace") && nbt.method_10545("logPath") ? class_2960.method_43902((String)nbt.method_10558("logNamespace"), (String)nbt.method_10558("logPath")) : class_7923.field_41178.method_10221((Object)class_1802.field_8162);
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void writeBurningTicksNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("burningTicks", this.burningTicks);
        nbt.method_10582("logNamespace", this.logNamespace);
        nbt.method_10582("logPath", this.logPath);
    }

    @Inject(method={"litServerTick"}, at={@At(value="HEAD")})
    private static void trackTimeOnFire(class_1937 world, class_2338 pos, class_2680 state, class_3924 campfire, CallbackInfo ci) {
        ((CampfireBlockEntityProperties)campfire).realistic_campfires$burningTick(world, pos, state, (class_2586)campfire);
    }

    @Inject(method={"unlitServerTick"}, at={@At(value="HEAD")})
    private static void resetBurningTicks(class_1937 world, class_2338 pos, class_2680 state, class_3924 campfire, CallbackInfo ci) {
        ((CampfireBlockEntityProperties)campfire).realistic_campfires$notBurningTick(world, pos, state, (class_2586)campfire);
    }

    @Unique
    private boolean isRainingAround(class_1937 world, class_2338 pos) {
        return world.method_8520(pos) || world.method_8520(pos.method_10067()) || world.method_8520(pos.method_10078()) || world.method_8520(pos.method_10095()) || world.method_8520(pos.method_10072());
    }

    @Override
    public void realistic_campfires$burningTick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (!world.method_8608()) {
            ++this.burningTicks;
            boolean dimensionInfiniteBurn = state.method_26164(world.method_8597().comp_654());
            if (!dimensionInfiniteBurn && world.method_8419() && this.isRainingAround(world, pos) && world.field_9229.method_43057() < (float)(this.burningTicks / 20) * 20.0f) {
                this.extinguish(world, state, pos);
                this.burningTicks = 0;
            }
            if (world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) {
                this.extinguish(world, state, pos);
                this.burningTicks = 0;
            }
            if (this.burningTicks % 2400 == 0) {
                this.extinguish(world, state, pos);
                this.burningTicks = 0;
            }
        }
    }

    @Unique
    private void extinguish(class_1937 world, class_2680 state, class_2338 pos) {
        if (!world.method_8608()) {
            world.method_8444(null, 1009, pos, 0);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.FALSE), 11);
        }
    }

    @Override
    public void realistic_campfires$notBurningTick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        this.burningTicks = 0;
    }

    @Override
    public class_2960 realistic_campfires$getLog() {
        return this.log;
    }

    @Override
    public void realistic_campfires$setLog(class_2960 id) {
        this.log = id;
        this.logNamespace = id.method_12836();
        this.logPath = id.method_12832();
    }
}

