/*
 * Decompiled with CFR 0.152.
 */
package com.ilyrash.pebblemod.block;

import com.ilyrash.pebblemod.item.ModItems;
import java.util.EnumMap;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class PebbleBlock
extends class_2248 {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2758 PEBBLES = class_2758.method_11867((String)"pebbles", (int)1, (int)4);
    public static final class_2754<PebbleType> PEBBLE_TYPE = class_2754.method_11850((String)"pebble_type", PebbleType.class);
    private static final EnumMap<class_2350, class_265[]> SHAPES = new EnumMap(class_2350.class);

    public PebbleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)PEBBLES, (Comparable)Integer.valueOf(1))).method_11657(PEBBLE_TYPE, (Comparable)((Object)PebbleType.STONE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, PEBBLES, PEBBLE_TYPE});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        class_1799 stack = ctx.method_8041();
        if (blockState.method_26204() instanceof PebbleBlock) {
            int currentPebbles = (Integer)blockState.method_11654((class_2769)PEBBLES);
            PebbleType currentType = (PebbleType)((Object)blockState.method_11654(PEBBLE_TYPE));
            PebbleType stackType = this.getPebbleTypeFromItem(stack, ctx.method_8045(), ctx.method_8037());
            if (currentPebbles < 4 && currentType == stackType) {
                return (class_2680)blockState.method_11657((class_2769)PEBBLES, (Comparable)Integer.valueOf(currentPebbles + 1));
            }
        }
        PebbleType type = this.getPebbleTypeFromItem(stack, ctx.method_8045(), ctx.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(PEBBLE_TYPE, (Comparable)((Object)type));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        boolean canAdd;
        class_1268 hand = class_1268.field_5808;
        class_1799 stack = player.method_5998(hand);
        if (!(stack.method_31574(ModItems.STONE_PEBBLE) || stack.method_31574(ModItems.SANDSTONE_PEBBLE) || stack.method_31574(ModItems.RED_SANDSTONE_PEBBLE))) {
            return class_1269.field_5811;
        }
        int currentPebbles = (Integer)state.method_11654((class_2769)PEBBLES);
        PebbleType currentType = (PebbleType)((Object)state.method_11654(PEBBLE_TYPE));
        PebbleType stackType = this.getPebbleTypeFromItem(stack, world, pos);
        if (currentType == PebbleType.SNOW_STONE) {
            canAdd = stack.method_31574(ModItems.STONE_PEBBLE) && currentPebbles < 4;
        } else {
            boolean bl = canAdd = currentType == stackType && currentPebbles < 4;
        }
        if (!canAdd) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)PEBBLES, (Comparable)Integer.valueOf(currentPebbles + 1)));
            world.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, 1.0f, 0.8f);
            if (!player.method_68878()) {
                stack.method_7934(1);
            }
        } else {
            player.method_6104(hand);
        }
        return class_1269.field_5812;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == class_2350.field_11033 && !this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654(FACING);
        int pebbles = (Integer)state.method_11654((class_2769)PEBBLES);
        return SHAPES.get(facing)[pebbles - 1];
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        PebbleType type = (PebbleType)((Object)state.method_11654(PEBBLE_TYPE));
        int pebbles = (Integer)state.method_11654((class_2769)PEBBLES);
        return new class_1799((class_1935)this.getItemFromPebbleType(type), pebbles);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && !player.method_31549().field_7477) {
            int pebbles = (Integer)state.method_11654((class_2769)PEBBLES);
            PebbleType type = (PebbleType)((Object)state.method_11654(PEBBLE_TYPE));
            class_1799 dropStack = new class_1799((class_1935)this.getItemFromPebbleType(type), pebbles);
            PebbleBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)dropStack);
        }
        return super.method_9576(world, pos, state, player);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        int currentPebbles = (Integer)state.method_11654((class_2769)PEBBLES);
        class_1799 stack = context.method_8041();
        PebbleType currentType = (PebbleType)((Object)state.method_11654(PEBBLE_TYPE));
        PebbleType stackType = this.getPebbleTypeFromItem(stack, context.method_8045(), context.method_8037());
        if ((stack.method_7909().equals(ModItems.STONE_PEBBLE) || stack.method_7909().equals(ModItems.SANDSTONE_PEBBLE) || stack.method_7909().equals(ModItems.RED_SANDSTONE_PEBBLE)) && currentPebbles < 4 && currentType == stackType) {
            return true;
        }
        return super.method_9616(state, context);
    }

    private PebbleType getPebbleTypeFromItem(class_1799 stack, class_1937 world, class_2338 pos) {
        class_6880 biomeEntry = world.method_23753(pos);
        class_1959 biome = (class_1959)biomeEntry.comp_349();
        boolean isSnowyBiome = biome.method_33599(pos, world.method_8615());
        if (stack.method_31574(ModItems.STONE_PEBBLE) && isSnowyBiome) {
            return PebbleType.SNOW_STONE;
        }
        if (stack.method_31574(ModItems.STONE_PEBBLE)) {
            return PebbleType.STONE;
        }
        if (stack.method_31574(ModItems.SANDSTONE_PEBBLE)) {
            return PebbleType.SANDSTONE;
        }
        if (stack.method_31574(ModItems.RED_SANDSTONE_PEBBLE)) {
            return PebbleType.RED_SANDSTONE;
        }
        return PebbleType.STONE;
    }

    private class_1792 getItemFromPebbleType(PebbleType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> ModItems.STONE_PEBBLE;
            case 1 -> ModItems.SANDSTONE_PEBBLE;
            case 2 -> ModItems.RED_SANDSTONE_PEBBLE;
        };
    }

    static {
        SHAPES.put(class_2350.field_11043, new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)2.0, (double)8.0, (double)3.0, (double)7.0), class_2248.method_9541((double)3.0, (double)0.0, (double)2.0, (double)12.0, (double)3.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)2.0, (double)12.0, (double)3.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)15.0)});
        SHAPES.put(class_2350.field_11034, new class_265[]{class_2248.method_9541((double)9.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)8.0), class_2248.method_9541((double)1.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)12.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)12.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)15.0)});
        SHAPES.put(class_2350.field_11035, new class_265[]{class_2248.method_9541((double)8.0, (double)0.0, (double)9.0, (double)13.0, (double)3.0, (double)14.0), class_2248.method_9541((double)4.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)14.0), class_2248.method_9541((double)4.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)14.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)14.0)});
        SHAPES.put(class_2350.field_11039, new class_265[]{class_2248.method_9541((double)2.0, (double)0.0, (double)8.0, (double)7.0, (double)3.0, (double)13.0), class_2248.method_9541((double)2.0, (double)0.0, (double)4.0, (double)15.0, (double)3.0, (double)13.0), class_2248.method_9541((double)2.0, (double)0.0, (double)4.0, (double)15.0, (double)3.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)});
    }

    public static enum PebbleType implements class_3542
    {
        STONE("stone"),
        SANDSTONE("sandstone"),
        RED_SANDSTONE("red_sandstone"),
        SNOW_STONE("snow_stone");

        private final String name;

        private PebbleType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

