/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TESClientUtil {
    @Nullable
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Nullable
    public static Entity getClientCamera() {
        return Minecraft.getInstance().getCameraEntity();
    }

    public static Vec3 getCameraPosition() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().position();
    }

    public static Vec3 getClosestEntityPosition(Entity entity) {
        Vec3 cameraPos = TESClientUtil.getCameraPosition();
        Vec3 angle = TESClientUtil.getClientPlayer().getLookAngle();
        return entity.getBoundingBox().clip(cameraPos, cameraPos.add(angle.scale(500.0))).orElseGet(() -> new Vec3(entity.getX() + (double)(Mth.cos((float)((float)(-angle.x))) * entity.getBbWidth() * 0.5f), Mth.clamp((double)cameraPos.y, (double)entity.getY(), (double)entity.getY(1.0)), entity.getZ() + (double)(Mth.sin((float)((float)(-angle.z))) * entity.getBbWidth() * 0.5f)));
    }
}

