/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.object;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESRenderUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface TESParticle<D> {
    public void updateData(D var1);

    public void submitRender(TESHudRenderContext.InWorldArgs var1, Minecraft var2, Font var3);

    public void tick(Minecraft var1);

    public boolean isValid();

    default public void defaultedTextRender(Minecraft mc, PoseStack poseStack, Vector3f prevPos, Vector3f pos, float partialTick, Runnable renderCallback) {
        float scale = 0.035f * TESAPI.getConfig().particleScale();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vector3f renderPos = prevPos.lerp((Vector3fc)pos, partialTick, new Vector3f()).sub((Vector3fc)camera.getPosition().toVector3f());
        poseStack.pushPose();
        poseStack.translate(renderPos.x, renderPos.y, renderPos.z);
        TESRenderUtil.positionFacingCamera(poseStack);
        poseStack.scale(scale, scale, scale);
        renderCallback.run();
        poseStack.popPose();
    }

    public static abstract class Animation {
        public static final Animation POP_OFF = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                return new Vector3f((float)random.nextGaussian() * 0.03f + 0.025f, random.nextFloat() * 0.035f + 0.37f, (float)random.nextGaussian() * 0.03f + 0.025f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.05f, 0.0f);
                pos.add((Vector3fc)velocity);
            }
        };
        public static final Animation RISE = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                position.add((float)random.nextGaussian() * 0.05f, 0.4f, (float)random.nextGaussian() * 0.05f);
                return new Vector3f(0.0f, 0.2f, 0.0f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.02f, 0.0f);
                if (velocity.y() < 0.0f) {
                    velocity.mul(1.0f, 0.5f, 1.0f);
                }
                pos.add((Vector3fc)velocity);
            }
        };

        public abstract Vector3f getInitialVelocity(TESParticle<?> var1, Vector3f var2, Random var3);

        public abstract void perTickModifier(TESParticle<?> var1, int var2, Vector3f var3, Vector3f var4, Vector3f var5, Random var6);
    }
}

