/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESEntityType;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESRenderUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.api.util.render.TextRenderHelper;
import net.tslat.tes.api.util.render.TextureRenderHelper;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    public static int renderEntityName(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        TextRenderHelper namespaceRenderer;
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudEntityName() && (!config.inWorldHudNameOverride() || !entity.hasCustomName()) : !config.hudEntityName()) {
            return 0;
        }
        Objects.requireNonNull(mc.font);
        int lineHeight = 9;
        boolean inWorldHud = renderContext.isInWorld();
        TextRenderHelper nameRenderer = TextRenderHelper.of(entity.getDisplayName()).colour(ARGB.white((float)opacity));
        TextRenderHelper textRenderHelper = (inWorldHud ? config.inWorldHudEntityNamespace() : config.hudEntityNamespace()) ? TextRenderHelper.of((Component)Component.literal((String)("(" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getNamespace() + ")"))).colour(200, 200, 200, Mth.floor((float)(opacity * 255.0f))) : (namespaceRenderer = null);
        if (inWorldHud) {
            nameRenderer.style(config.inWorldHudEntityNameFontStyle()).centered();
            if (namespaceRenderer != null) {
                namespaceRenderer.style(config.inWorldHudEntityNameFontStyle()).centered();
            }
        } else {
            nameRenderer.style(config.hudEntityNameFontStyle());
            if (namespaceRenderer != null) {
                namespaceRenderer.style(config.hudEntityNameFontStyle());
            }
        }
        nameRenderer.render(renderContext, 0.0f, 0.0f);
        if (namespaceRenderer != null) {
            namespaceRenderer.render(renderContext, 0.0f, lineHeight);
            Objects.requireNonNull(mc.font);
            lineHeight += 9;
        }
        TESEntityTracking.markNameRendered(entity);
        return lineHeight;
    }

    public static int renderEntityHealth(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        boolean inWorldHud = renderContext.isInWorld();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        renderContext.pushMatrix();
        renderContext.translate(inWorldHud ? (float)barWidth * -0.5f : 0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float filledPercent = entityState.getHealth() / entity.getMaxHealth();
            float transitionPercent = entityState.getLastTransitionHealth() / entity.getMaxHealth();
            boolean doSegmentsOverlay = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            TESEntityType entityType = TESConstants.UTILS.getEntityType(entity);
            TextureAtlasSprite emptyBar = TESRenderUtil.getGuiAtlasSprite(entityType.backgroundTexture());
            TextureAtlasSprite filledBar = TESRenderUtil.getGuiAtlasSprite(entityType.overlayTexture());
            TextureAtlasSprite barBackground = TESRenderUtil.getGuiAtlasSprite(TESTextures.BAR_EMPTY);
            TextureAtlasSprite barOverlay = doSegmentsOverlay ? TESRenderUtil.getGuiAtlasSprite(TESTextures.BAR_OVERLAY_SEGMENTS) : null;
            TESRenderUtil.renderBar(renderContext, 0, 0, barWidth, filledPercent, transitionPercent, opacity, barBackground, emptyBar, filledBar, barOverlay);
        }
        if (renderType != TESHud.BarRenderType.BAR && renderType != TESHud.BarRenderType.BAR_ICONS) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.getMaxHealth(), 1);
            if (inWorldHud) {
                renderContext.translate(0.0f, 0.0f, 0.019f);
            }
            TextRenderHelper healthRenderer = TextRenderHelper.of((Component)Component.literal((String)healthText)).colour(255, 255, 255, Mth.floor((float)(opacity * 255.0f))).withBackdrop(ARGB.color((int)Mth.floor((float)(opacity * 255.0f * config.hudBarFontBackingOpacity())), (int)9, (int)9, (int)9)).centered();
            if (inWorldHud) {
                healthRenderer.lightLevel(renderContext.getPackedLight());
            }
            healthRenderer.render(renderContext, (float)barWidth / 2.0f, -1.0f);
        }
        renderContext.popMatrix();
        Objects.requireNonNull(mc.font);
        return 9;
    }

    public static int renderEntityStats(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudStats() : !config.hudStats()) {
            return 0;
        }
        boolean inWorldHud = renderContext.isInWorld();
        int armour = TESUtil.getArmour(entity);
        float toughness = TESUtil.getArmourToughness(entity);
        float meleeDamage = TESUtil.getMeleeDamage(entity);
        float health = TESUtil.getHealth(entity);
        int hearts = health <= 0.0f ? 0 : Math.max(1, Mth.floor((float)(health / 2.0f)));
        int colour = ARGB.white((float)opacity);
        MutableComponent armourString = armour > 0 ? Component.literal((String)("x" + armour)) : null;
        MutableComponent toughnessString = toughness > 0.0f ? Component.literal((String)("x" + TESUtil.roundToDecimal(toughness, 1))) : null;
        MutableComponent meleeDamageString = meleeDamage > 0.0f ? Component.literal((String)("x" + TESUtil.roundToDecimal(meleeDamage, 1))) : null;
        MutableComponent heartsString = (inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType()) == TESHud.BarRenderType.BAR_ICONS ? Component.literal((String)("x" + hearts)) : null;
        int armourX = 0;
        int toughnessX = armourX + (armourString == null ? 0 : 11 + mc.font.width((FormattedText)armourString));
        int meleeDamageX = toughnessX + (toughnessString == null ? 0 : 11 + mc.font.width((FormattedText)toughnessString));
        int healthX = meleeDamageX + (meleeDamageString == null ? 0 : 11 + mc.font.width((FormattedText)meleeDamageString));
        if (healthX == 0 && heartsString == null) {
            return 0;
        }
        renderContext.pushMatrix();
        if (inWorldHud) {
            renderContext.translate((float)(healthX + (heartsString == null ? 0 : mc.font.width((FormattedText)heartsString)) + 2) * -0.5f, 0.0f, 0.0f);
        }
        if (armour > 0) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_ARMOUR).sized(9.0f, 9.0f).colour(colour).render(renderContext, armourX, 0.0f);
        }
        if (toughness > 0.0f) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_TOUGHNESS).sized(9.0f, 9.0f).colour(colour).render(renderContext, toughnessX, 0.0f);
        }
        if (meleeDamage > 0.0f) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_MELEE_DAMAGE).sized(9.0f, 9.0f).colour(colour).render(renderContext, meleeDamageX, 0.0f);
        }
        if (heartsString != null) {
            TextureRenderHelper.ofSprite(ResourceLocation.withDefaultNamespace((String)"hud/heart/container")).sized(9.0f, 9.0f).colour(colour).render(renderContext, healthX, 0.0f);
            TextureRenderHelper.ofSprite(ResourceLocation.withDefaultNamespace((String)"hud/heart/full")).sized(9.0f, 9.0f).colour(colour).render(renderContext, healthX, 0.0f);
        }
        if (armour > 0) {
            TextRenderHelper.of((Component)armourString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, armourX + 10, 1.0f);
        }
        if (toughness > 0.0f) {
            TextRenderHelper.of((Component)toughnessString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, toughnessX + 10, 1.0f);
        }
        if (meleeDamage > 0.0f) {
            TextRenderHelper.of((Component)meleeDamageString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, meleeDamageX + 10, 1.0f);
        }
        if (heartsString != null) {
            TextRenderHelper.of((Component)heartsString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, healthX + 10, 1.0f);
        }
        renderContext.popMatrix();
        Objects.requireNonNull(mc.font);
        return 9;
    }

    public static int renderEntityIcons(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudEntityIcons() : !config.hudEntityIcons()) {
            return 0;
        }
        float x = 0.0f;
        List<TESHudEntityIcon> icons = TESHud.getEntityIcons();
        ObjectArrayList toRender = new ObjectArrayList(icons.size());
        for (TESHudEntityIcon icon : icons) {
            if (!icon.shouldRender(entity)) continue;
            toRender.add(icon);
            x += 9.0f;
        }
        x = renderContext.isInWorld() ? -(x / 2.0f) : 0.0f;
        for (TESHudEntityIcon icon : toRender) {
            icon.render(renderContext, entity, x, 0.0f, opacity);
            x += 9.0f;
        }
        return toRender.isEmpty() ? 0 : 8;
    }

    public static int renderEntityEffects(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudPotionIcons() : !config.hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        boolean inWorldHud = renderContext.isInWorld();
        int effectsSize = entityState.getEffects().size();
        int barLength = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        renderContext.pushMatrix();
        renderContext.scale(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            renderContext.translate(0.0f, Mth.floor((float)((float)(effectsSize * 18) / maxX)) * -18, 0.0f);
        }
        for (Holder<MobEffect> effect : entityState.getEffects()) {
            TextureRenderHelper effectRenderer = TextureRenderHelper.ofSprite(Gui.getMobEffectSprite(effect)).sized(18.0f, 18.0f).colour(ARGB.white((float)opacity));
            if (inWorldHud) {
                effectRenderer.lightLevel(renderContext.getPackedLight());
            }
            effectRenderer.render(renderContext, i * 18 + x, y);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        renderContext.popMatrix();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }

    public static int renderHorseStats(TESHudRenderContext renderContext, Minecraft mc, LivingEntity entity, float opacity) {
        AbstractChestedHorse chestedHorse;
        boolean hasChest;
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudHorseStats() : !config.hudHorseStats()) {
            return 0;
        }
        if (!(entity instanceof AbstractHorse)) {
            return 0;
        }
        AbstractHorse horse = (AbstractHorse)entity;
        boolean bl = hasChest = entity instanceof AbstractChestedHorse && (chestedHorse = (AbstractChestedHorse)entity).hasChest();
        int x = renderContext.isInWorld() ? (hasChest ? -18 : -11) : 1;
        double healthRatio = (horse.getAttributeValue(Attributes.MAX_HEALTH) - (double)AbstractHorse.MIN_HEALTH) / (double)(AbstractHorse.MAX_HEALTH - AbstractHorse.MIN_HEALTH);
        double moveSpeedRatio = (horse.getAttributeValue(Attributes.MOVEMENT_SPEED) - (double)AbstractHorse.MIN_MOVEMENT_SPEED) / (double)(AbstractHorse.MAX_MOVEMENT_SPEED - AbstractHorse.MIN_MOVEMENT_SPEED);
        double jumpStrengthRatio = (horse.getAttributeValue(Attributes.JUMP_STRENGTH) - (double)AbstractHorse.MIN_JUMP_STRENGTH) / (double)(AbstractHorse.MAX_JUMP_STRENGTH - AbstractHorse.MIN_JUMP_STRENGTH);
        TextRenderHelper health = TextRenderHelper.of("H:" + Mth.floor((double)(healthRatio * 100.0)) + "%").colour(ARGB.color((float)opacity, (int)TESRenderUtil.colourGradeForValue(healthRatio)));
        TextRenderHelper speed = TextRenderHelper.of("S:" + Mth.floor((double)(moveSpeedRatio * 100.0)) + "%").colour(ARGB.color((float)opacity, (int)TESRenderUtil.colourGradeForValue(moveSpeedRatio)));
        TextRenderHelper jumpStrength = TextRenderHelper.of("J:" + Mth.floor((double)(jumpStrengthRatio * 100.0)) + "%").colour(ARGB.color((float)opacity, (int)TESRenderUtil.colourGradeForValue(jumpStrengthRatio)));
        TextureRenderHelper storageSprite = TextureRenderHelper.ofSprite(TESTextures.PROPERTY_STORAGE).sized(8.0f, 8.0f).colour(ARGB.white((float)opacity));
        if (hasChest) {
            storageSprite.render(renderContext, x, 1.0f);
            x += 10;
        }
        health.render(renderContext, x, 1.0f);
        speed.render(renderContext, x + 34, 1.0f);
        jumpStrength.render(renderContext, x + 68, 1.0f);
        return 9;
    }
}

