/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_10017;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.render.TextureRenderHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class TESRenderUtil {
    public static class_1058 getGuiAtlasSprite(class_2960 texture) {
        return class_310.method_1551().method_72703().method_73025(class_10725.field_56385).method_4608(texture);
    }

    public static void centerTextForRender(class_2561 text, float x, float y, BiConsumer<Float, Float> renderRunnable) {
        Float f = Float.valueOf(x - (float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        renderRunnable.accept(f, Float.valueOf(y + (float)(9 - 1) / 2.0f));
    }

    public static int colourGradeForLerp(double value, double minValue, double maxValue) {
        return TESRenderUtil.colourGradeForValue((value - minValue) / (maxValue - minValue));
    }

    public static int colourGradeForValue(double value) {
        return class_3532.method_60599((float)((float)class_3532.method_15350((double)((double)0.35f * value), (double)0.0, (double)0.35f)), (float)1.0f, (float)1.0f, (int)255);
    }

    public static void positionFacingCamera(class_4587 poseStack) {
        poseStack.method_22905(-1.0f, -1.0f, -1.0f);
        poseStack.method_22907((Quaternionfc)class_310.method_1551().field_1773.method_19418().method_23767());
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
    }

    public static void renderBar(TESHudRenderContext renderContext, int x, int y, int barWidth, float completionPercentage, float transitionPercentage, float opacity, class_1058 background, class_1058 emptyBar, class_1058 filledBar, @Nullable class_1058 overlayBar) {
        TESRenderUtil.renderBarLayer(renderContext, x, y, background, barWidth, 1.0f, opacity);
        renderContext.translate(0.0f, 0.0f, 0.01f);
        TESRenderUtil.renderBarLayer(renderContext.withRenderOrder(1), x, y, emptyBar, barWidth, transitionPercentage, opacity);
        renderContext.translate(0.0f, 0.0f, 0.01f);
        TESRenderUtil.renderBarLayer(renderContext.withRenderOrder(2), x, y, filledBar, barWidth, completionPercentage, opacity);
        if (overlayBar != null) {
            renderContext.translate(0.0f, 0.0f, 0.01f);
            TESRenderUtil.renderBarLayer(renderContext.withRenderOrder(3), x, y, overlayBar, barWidth, 1.0f, 0.75f * opacity);
        }
    }

    public static void renderBarLayer(TESHudRenderContext renderContext, int x, int y, class_1058 sprite, float barWidth, float filledPercent, float opacity) {
        TextureRenderHelper barRight;
        float pixelWidth = sprite.method_45851().method_45807();
        float barPercent = Math.round(barWidth * filledPercent);
        float pixelPercent = Math.round(pixelWidth * filledPercent);
        float midBarWidth = barWidth - 10.0f;
        float leftEndPixels = Math.min(5.0f, Math.min(barPercent, pixelPercent));
        float rightEndPixels = Math.min(5.0f, 5.0f - (pixelWidth - pixelPercent));
        TextureRenderHelper barLeft = TextureRenderHelper.of(sprite).uWidth(leftEndPixels).width(leftEndPixels).colour(class_9848.method_61317((float)opacity));
        TextureRenderHelper barMiddle = pixelWidth <= 10.0f || midBarWidth <= 0.0f || barPercent <= 10.0f ? null : TextureRenderHelper.of(sprite).uWidth(pixelPercent - 10.0f).uOffset(5.0f).width(barPercent >= barWidth - 5.0f ? midBarWidth : barPercent - 10.0f).colour(class_9848.method_61317((float)opacity));
        TextureRenderHelper textureRenderHelper = barRight = rightEndPixels <= 0.0f || barPercent - 5.0f <= 0.0f ? null : TextureRenderHelper.of(sprite).uWidth(rightEndPixels).uOffset(pixelWidth - 5.0f).width(Math.min(5.0f, rightEndPixels)).colour(class_9848.method_61317((float)opacity));
        if (renderContext.isInWorld()) {
            int packedLight = renderContext.getPackedLight();
            barLeft.lightLevel(packedLight);
            if (barMiddle != null) {
                barMiddle.lightLevel(packedLight);
            }
            if (barRight != null) {
                barRight.lightLevel(packedLight);
            }
        }
        barLeft.render(renderContext, class_10799.field_56883, class_1921::method_23580, x, y);
        if (barMiddle != null) {
            barMiddle.render(renderContext, class_10799.field_56883, class_1921::method_23580, x + 5, y);
        }
        if (barRight != null) {
            barRight.render(renderContext, class_10799.field_56883, class_1921::method_23580, (float)(x + 5) + midBarWidth, y);
        }
    }

    public static void renderEntityIcon(TESHudRenderContext.InGuiArgs args, class_310 mc, class_1309 entity, float opacity, boolean includeFrame) {
        TESConfig config = TESAPI.getConfig();
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.method_17681(), 40.0f / entity.method_17682()), 0.95f) * -20.0f;
        boolean scissor = config.hudPreventEntityOverflow();
        class_332 guiGraphics = args.guiGraphics();
        if (scissor) {
            guiGraphics.method_44379(2, 2, 36, 47);
        }
        if (includeFrame) {
            TextureRenderHelper.ofSprite(TESTextures.ENTITY_ICON_FRAME).colour(class_9848.method_61317((float)(0.5f * opacity))).renderForHud(args, 2.0f, 2.0f);
        }
        float yBodyRotPrev = entity.field_6283;
        float yRotPrev = entity.method_36454();
        float xRotPrev = entity.method_36455();
        float yHeadRotOldPrev = entity.field_6259;
        float yHeadRotPrev = entity.field_6241;
        int hurtTicks = entity.field_6235;
        float attackTimePrev = entity.field_6251;
        float attackTimeOldPrev = entity.field_6229;
        class_2561 displayName = entity.method_5797();
        entity.method_36456(22.5f);
        entity.method_36457(0.0f);
        entity.field_6283 = 22.5f;
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        entity.field_6235 = config.hudEntityDamageOverlay() ? entity.field_6235 : 0;
        entity.field_6251 = 0.0f;
        entity.field_6229 = 0.0f;
        entity.method_5665(null);
        class_10017 renderState = mc.method_1561().method_3953((class_1297)entity).method_62425((class_1297)entity, 1.0f);
        renderState.field_58169 = null;
        renderState.field_61820 = 0xF000F0;
        guiGraphics.method_70856(renderState, scale / entity.method_55693(), new Vector3f(0.0f, entity.method_17682() * -0.5f, 0.0f), new Quaternionf(), null, 2, 2, 36, 47);
        entity.method_5665(displayName);
        entity.method_36456(yRotPrev);
        entity.method_36457(xRotPrev);
        entity.field_6283 = yBodyRotPrev;
        entity.field_6241 = yHeadRotPrev;
        entity.field_6259 = yHeadRotOldPrev;
        entity.field_6235 = hurtTicks;
        entity.field_6251 = attackTimePrev;
        entity.field_6229 = attackTimeOldPrev;
        if (scissor) {
            guiGraphics.method_44380();
        }
    }
}

