/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.state.EntityState;
import org.jetbrains.annotations.Nullable;

public final class TESEntityTracking {
    private static final Int2ObjectOpenHashMap<EntityState> ENTITY_STATES = new Int2ObjectOpenHashMap(50);
    private static final IntSet RENDERED_NAMES = new IntOpenHashSet();
    private static List<class_1309> ENTITIES_TO_RENDER = new ObjectArrayList();

    public static void accountForEntity(class_1309 entity) {
        ENTITY_STATES.compute(entity.method_5628(), (key, value) -> {
            class_310 mc = class_310.method_1551();
            if (entity.method_24204().anyMatch(passenger -> passenger == mc.field_1724) && !TESAPI.getConfig().inWorldHudForSelf()) {
                return null;
            }
            if (entity.method_5864().method_20210(TESConstants.NO_TES_HANDLING)) {
                return null;
            }
            double trackingDist = TESAPI.getConfig().getEntityTrackingDistance();
            if (TESClientUtil.getClosestEntityPosition((class_1297)entity).method_1025(TESClientUtil.getCameraPosition()) > trackingDist * trackingDist) {
                return null;
            }
            return value == null ? new EntityState(entity) : value;
        });
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (!mc.method_1493() && mc.field_1687 != null && !mc.field_1687.method_54719().method_54754()) {
            TESParticleManager.clearClaims();
            ObjectIterator iterator = ENTITY_STATES.values().iterator();
            while (iterator.hasNext()) {
                EntityState state = (EntityState)iterator.next();
                if (!state.isValid()) {
                    iterator.remove();
                    continue;
                }
                state.tick();
            }
        }
    }

    public static void addEntityToRender(class_1309 entity) {
        ENTITIES_TO_RENDER.add(entity);
    }

    @Nullable
    public static EntityState getStateForEntity(class_1309 entity) {
        return TESEntityTracking.getStateForEntityId(entity.method_5628());
    }

    @Nullable
    public static EntityState getStateForEntityId(int id) {
        return (EntityState)ENTITY_STATES.get(id);
    }

    public static List<class_1309> getEntitiesToRender() {
        List<class_1309> entities = ENTITIES_TO_RENDER;
        ENTITIES_TO_RENDER = new ObjectArrayList(ENTITIES_TO_RENDER.size());
        RENDERED_NAMES.clear();
        return entities;
    }

    public static boolean wasNameRendered(int entityId) {
        return RENDERED_NAMES.contains(entityId);
    }

    public static void markNameRendered(class_1309 entity) {
        RENDERED_NAMES.add(entity.method_5628());
    }
}

