/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.function.BiConsumer;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrankBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)2.0, (double)2.0, (double)5.0, (double)14.0, (double)14.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)11.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public CrankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return facing.getOpposite() == stateIn.getValue((Property)FACING) && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = worldIn.getBlockState(blockpos);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return CrankBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)blockpos, (Direction)direction);
        }
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, direction);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 0) {
            if (level.isClientSide) {
                CrankBlock.addParticle(state, level, pos, (ParticleOptions)ParticleTypes.SMOKE);
            }
            return true;
        }
        return super.triggerEvent(state, level, pos, id, param);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockPos behind;
            BlockState backState;
            level.blockEvent(pos, (Block)this, 0, 0);
            boolean ccw = player.isShiftKeyDown();
            this.turn(state, level, pos, ccw, player);
            Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
            if (dir.getAxis() != Direction.Axis.Y && (backState = level.getBlockState(behind = pos.relative(dir))).is(ModRegistry.PULLEY_BLOCK.get()) && dir.getAxis() == backState.getValue((Property)PulleyBlock.AXIS)) {
                ((PulleyBlock)backState.getBlock()).windPulley(backState, behind, (LevelAccessor)level, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (explosion.canTriggerBlocks()) {
            this.turn(state, level, pos, true, null);
        }
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }

    public void turn(BlockState state, Level level, BlockPos pos, boolean ccw, @Nullable Player player) {
        int newPower = (16 + (Integer)state.getValue((Property)POWER) + (ccw ? -1 : 1)) % 16;
        state = (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower));
        level.setBlock(pos, state, 3);
        this.updateNeighbors(state, level, pos);
        float f = 0.55f + (float)((Integer)state.getValue((Property)POWER)).intValue() * 0.04f;
        level.playSound(null, pos, ModSounds.CRANK.get(), SoundSource.BLOCKS, 0.5f, f);
        level.gameEvent((Entity)player, (Holder)(newPower == 0 ? GameEvent.BLOCK_DEACTIVATE : GameEvent.BLOCK_ACTIVATE), pos);
    }

    private void updateNeighbors(BlockState state, Level level, BlockPos pos) {
        level.updateNeighborsAt(pos, (Block)this);
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.getValue((Property)FACING) == side ? (Integer)blockState.getValue((Property)POWER) : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.is(newState.getBlock())) {
            if ((Integer)state.getValue((Property)POWER) != 0) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if ((Integer)stateIn.getValue((Property)POWER) > 0 && rand.nextFloat() < 0.25f) {
            CrankBlock.addParticle(stateIn, worldIn, pos, (ParticleOptions)new DustParticleOptions(DustParticleOptions.REDSTONE_PARTICLE_COLOR, 0.5f));
        }
    }

    private static void addParticle(BlockState stateIn, Level worldIn, BlockPos pos, ParticleOptions particle) {
        Direction direction = ((Direction)stateIn.getValue((Property)FACING)).getOpposite();
        double x = (double)pos.getX() + 0.5 + 0.1 * (double)direction.getStepX() + 0.2 * (double)direction.getStepX();
        double y = (double)pos.getY() + 0.5 + 0.1 * (double)direction.getStepY() + 0.2 * (double)direction.getStepY();
        double z = (double)pos.getZ() + 0.5 + 0.1 * (double)direction.getStepZ() + 0.2 * (double)direction.getStepZ();
        worldIn.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE_SOUTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] directions;
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        BlockState blockstate = this.defaultBlockState();
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : directions = context.getNearestLookingDirections()) {
            Direction direction1 = direction.getOpposite();
            if (!(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction1)).canSurvive((LevelReader)level, blockpos)) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }
}

