/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SignPostWallBlock
extends WaterBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);

    public SignPostWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction.getAxis() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SignPostBlockTile(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof SignPostItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SignPostBlockTile) {
                SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
                return tile.handleInteraction(state, serverLevel, pos, player, hand, hitResult, stack);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            SignPostBlockTile.Sign sign = tile.getSignUp();
            if (sign.active()) {
                return sign.getItem();
            }
            SignPostBlockTile.Sign sign2 = tile.getSignDown();
            if (sign2.active()) {
                return sign2.getItem();
            }
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        SignPostBlockTile tile;
        SignPostBlockTile.Sign sign;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile && (sign = (tile = (SignPostBlockTile)blockEntity).getClickedSign(target.getLocation())).active()) {
            return sign.getItem();
        }
        return new ItemStack((ItemLike)this);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)object;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)tile.getHeldBlock().getBlock()));
            SignPostBlockTile.Sign up = tile.getSignUp();
            SignPostBlockTile.Sign down = tile.getSignDown();
            if (up.active()) {
                list.add(up.getItem());
            }
            if (down.active()) {
                list.add(down.getItem());
            }
            return list;
        }
        return super.getDrops(state, builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos behind = pos.relative(facing.getOpposite());
        return level.getBlockState(behind).isFaceSturdy((BlockGetter)level, behind, facing);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }
}

