/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.ILevelEventRedirect;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.MovingDispenserBlockEntity;
import net.mehvahdjukaar.supplementaries.common.misc.IMovingBlockSource;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DispenserMinecartEntity
extends Minecart
implements Container,
MenuProvider {
    private static final BlockState BLOCK_STATE = (BlockState)Blocks.DISPENSER.defaultBlockState().setValue((Property)DispenserBlock.FACING, (Comparable)Direction.UP);
    private final MovingDispenserBlockEntity dispenser = new MovingDispenserBlockEntity(BlockEntityType.DISPENSER, BlockPos.ZERO, BLOCK_STATE, this);
    private boolean onActivator = false;
    private boolean powered = false;

    public DispenserMinecartEntity(Level level, double x, double y, double z) {
        this(ModEntities.DISPENSER_MINECART.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public DispenserMinecartEntity(EntityType<DispenserMinecartEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("Dispenser", (Tag)this.dispenser.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess()));
        pCompound.putBoolean("Powered", this.powered);
        pCompound.putBoolean("OnActivator", this.onActivator);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.dispenser.loadWithComponents(pCompound.getCompound("Dispenser"), (HolderLookup.Provider)this.level().registryAccess());
        this.powered = pCompound.getBoolean("Powered");
        this.onActivator = pCompound.getBoolean("OnActivator");
    }

    public ItemStack getPickResult() {
        return ModRegistry.DISPENSER_MINECART_ITEM.get().getDefaultInstance();
    }

    protected Item getDropItem() {
        return ModRegistry.DISPENSER_MINECART_ITEM.get();
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    public BlockState getDefaultDisplayBlockState() {
        return BLOCK_STATE;
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = InteractionResult.PASS;
        if (ret.consumesAction()) {
            return ret;
        }
        pPlayer.openMenu((MenuProvider)this);
        if (!pPlayer.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public int getContainerSize() {
        return this.dispenser.getContainerSize();
    }

    public boolean isEmpty() {
        return this.dispenser.isEmpty();
    }

    public ItemStack getItem(int pIndex) {
        return this.dispenser.getItem(pIndex);
    }

    public ItemStack removeItem(int pIndex, int pCount) {
        return this.dispenser.removeItem(pIndex, pCount);
    }

    public ItemStack removeItemNoUpdate(int pIndex) {
        return this.dispenser.removeItemNoUpdate(pIndex);
    }

    public void setItem(int pIndex, ItemStack pStack) {
        this.dispenser.setItem(pIndex, pStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player pPlayer) {
        if (this.isRemoved()) {
            return false;
        }
        return pPlayer.distanceToSqr((Entity)this) <= 64.0;
    }

    public void clearContent() {
        this.dispenser.clearContent();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return this.dispenser.createMenu(pContainerId, pInventory, pPlayer);
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    protected void applyNaturalSlowdown() {
        float f = 0.98f;
        int i = 15 - AbstractContainerMenu.getRedstoneSignalFromContainer((Container)this);
        f += (float)i * 0.001f;
        if (this.isInWater()) {
            f *= 0.95f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.0, (double)f));
    }

    public SlotAccess getSlot(final int pSlot) {
        return pSlot >= 0 && pSlot < this.getContainerSize() ? new SlotAccess(){

            public ItemStack get() {
                return DispenserMinecartEntity.this.dispenser.getItem(pSlot);
            }

            public boolean set(ItemStack carried) {
                DispenserMinecartEntity.this.dispenser.setItem(pSlot, carried);
                return true;
            }
        } : super.getSlot(pSlot);
    }

    public void activateMinecart(int pX, int pY, int pZ, boolean pReceivingPower) {
        Level level;
        this.onActivator = true;
        if (!this.powered && pReceivingPower && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dispenseFrom(serverLevel, this.blockPosition());
        }
        this.powered = pReceivingPower;
    }

    public void tick() {
        super.tick();
        this.dispenser.setLevel(this.level());
        if (!this.level().isClientSide && this.isAlive() && this.powered) {
            if (!this.onActivator) {
                this.powered = false;
            }
            this.onActivator = false;
        }
    }

    public void teleportTo(double pX, double pY, double pZ) {
        super.teleportTo(pX, pY, pZ);
        this.level().broadcastEntityEvent((Entity)this, (byte)46);
    }

    protected void dispenseFrom(ServerLevel level, BlockPos pPos) {
        ((ILevelEventRedirect)level).supp$setRedirected(true, this.position());
        int i = this.dispenser.getRandomSlot(level.getRandom());
        if (i < 0) {
            level.levelEvent(1001, pPos, 0);
            level.gameEvent((Entity)this, (Holder)GameEvent.BLOCK_ACTIVATE, pPos);
        } else {
            ItemStack itemstack = this.dispenser.getItem(i);
            try {
                DispenseItemBehavior dispenseitembehavior = ((DispenserBlock)Blocks.DISPENSER).getDispenseMethod((Level)level, itemstack);
                if (dispenseitembehavior != DispenseItemBehavior.NOOP) {
                    ItemStack dispensed;
                    Item item;
                    BlockSource blockSource = IMovingBlockSource.create(level, (Entity)this, this.dispenser);
                    if (CommonConfigs.Redstone.DISPENSER_MINECART_ANGLE.get().booleanValue() && (item = itemstack.getItem()) instanceof ProjectileItem) {
                        ProjectileItem pb = (ProjectileItem)item;
                        dispensed = this.executeAbstractProjectileBehavior(pb, blockSource, itemstack);
                    } else {
                        dispensed = dispenseitembehavior.dispense(blockSource, itemstack);
                    }
                    this.dispenser.setItem(i, dispensed);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("Failed to execute Dispenser Minecart behavior for item {}", (Object)itemstack.getItem());
            }
        }
        ((ILevelEventRedirect)level).supp$setRedirected(false, Vec3.ZERO);
    }

    private ItemStack executeAbstractProjectileBehavior(ProjectileItem ap, BlockSource source, ItemStack stack) {
        BaseRailBlock br;
        RailShape railShape;
        boolean ascending;
        ServerLevel level = source.level();
        ProjectileItem.DispenseConfig config = ap.createDispenseConfig();
        Position position = config.positionFunction().getDispensePosition(source, Direction.UP);
        Projectile projectile = ap.asProjectile((Level)level, position, stack, Direction.UP);
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        projectile.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ(), config.power(), config.uncertainty());
        BlockState rail = level.getBlockState(this.blockPosition());
        Block block = rail.getBlock();
        if (block instanceof BaseRailBlock && (ascending = (railShape = (RailShape)rail.getValue((br = (BaseRailBlock)block).getShapeProperty())).isAscending())) {
            DispenserMinecartEntity.adjustMovementRelativeToRail(projectile, railShape);
        }
        Vec3 mySpeed = this.getDeltaMovement().scale(0.25);
        projectile.setDeltaMovement(projectile.getDeltaMovement().add(mySpeed.x, this.onGround() ? 0.0 : mySpeed.y, mySpeed.z));
        level.addFreshEntity((Entity)projectile);
        stack.shrink(1);
        source.level().levelEvent(config.overrideDispenseEvent().orElse(1002), source.pos(), 0);
        source.level().levelEvent(2000, source.pos(), direction.get3DDataValue());
        return stack;
    }

    private static void adjustMovementRelativeToRail(Projectile projectile, RailShape railShape) {
        Vec3 movement = projectile.getDeltaMovement();
        switch (railShape) {
            case ASCENDING_EAST: {
                movement = movement.zRot(-0.7853982f);
                break;
            }
            case ASCENDING_WEST: {
                movement = movement.zRot(0.7853982f);
                break;
            }
            case ASCENDING_SOUTH: {
                movement = movement.xRot(0.7853982f);
                break;
            }
            case ASCENDING_NORTH: {
                movement = movement.xRot(-0.7853982f);
            }
        }
        projectile.setDeltaMovement(movement);
    }
}

